/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.world.block.builtin;

import com.elmakers.mine.bukkit.block.MaterialAndData;
import com.elmakers.mine.bukkit.world.BlockResult;
import com.elmakers.mine.bukkit.world.block.BlockRule;
import com.elmakers.mine.bukkit.world.tasks.ModifyBlockTask;
import java.util.Random;
import javax.annotation.Nullable;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ReplaceRule
extends BlockRule {
    private MaterialAndData replace = null;

    @Override
    public boolean onLoad(ConfigurationSection config) {
        String materialKey = config.getString("replace");
        if (materialKey != null && !materialKey.isEmpty() && !materialKey.equalsIgnoreCase("none")) {
            this.replace = new MaterialAndData(materialKey);
            if (!this.replace.isValid()) {
                this.controller.getLogger().warning("Invalid replace material in block rule: " + materialKey);
            }
        }
        if (this.replace != null) {
            this.logBlockRule("Replacing with " + String.valueOf(this.replace));
        }
        return this.replace != null;
    }

    @Override
    @Nullable
    public BlockResult onHandle(Block block, Random random, Player cause) {
        if (this.replace == null || !this.replace.isValid()) {
            return BlockResult.SKIP;
        }
        Plugin plugin = this.controller.getPlugin();
        plugin.getServer().getScheduler().runTaskLater(plugin, (Runnable)new ModifyBlockTask(block, this.replace), 1L);
        return BlockResult.STOP;
    }
}

