/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.world.populator;

import com.elmakers.mine.bukkit.magic.MagicController;
import com.elmakers.mine.bukkit.utility.CompatibilityLib;
import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.world.BlockResult;
import com.elmakers.mine.bukkit.world.populator.MagicChunkPopulator;
import java.util.Random;
import java.util.Set;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.configuration.ConfigurationSection;

public abstract class BaseBlockPopulator
extends MagicChunkPopulator {
    private Integer maxY = null;
    private Integer minY = null;
    private Integer maxAirY = null;
    private int cooldown;
    private long lastPopulate;
    private Set<Biome> biomes;
    private Set<Biome> notBiomes;

    @Override
    public boolean load(ConfigurationSection config, MagicController controller) {
        if (!super.load(config, controller)) {
            return false;
        }
        this.maxY = ConfigurationUtils.getOptionalInteger(config, "max_y");
        this.minY = ConfigurationUtils.getOptionalInteger(config, "min_y");
        this.maxAirY = ConfigurationUtils.getOptionalInteger(config, "max_air_y");
        this.cooldown = config.getInt("cooldown", 0);
        this.biomes = ConfigurationUtils.loadBiomes(ConfigurationUtils.getStringList(config, "biomes"), controller.getLogger(), "block populator");
        this.notBiomes = ConfigurationUtils.loadBiomes(ConfigurationUtils.getStringList(config, "not_biomes"), controller.getLogger(), "block populator");
        return true;
    }

    public void populate(World world, Random random, Chunk chunk) {
        int minY = this.minY != null ? this.minY.intValue() : CompatibilityLib.getCompatibilityUtils().getMinHeight(world);
        int maxY = this.maxY != null ? this.maxY.intValue() : CompatibilityLib.getCompatibilityUtils().getMaxHeight(world);
        for (int x = 0; x <= 15; ++x) {
            block1: for (int z = 0; z <= 15; ++z) {
                for (int y = minY; y <= maxY; ++y) {
                    BlockResult result;
                    Block block = chunk.getBlock(x, y, z);
                    if (this.maxAirY != null && y > this.maxAirY && block.getType() == Material.AIR) continue block1;
                    if (this.biomes != null && !this.biomes.contains(block.getBiome()) || this.notBiomes != null && this.notBiomes.contains(block.getBiome())) continue;
                    long now = System.currentTimeMillis();
                    if (this.cooldown > 0 && now < this.lastPopulate + (long)this.cooldown || (result = this.populate(block, random)) == BlockResult.SKIP) continue;
                    this.lastPopulate = now;
                }
            }
        }
    }

    public abstract BlockResult populate(Block var1, Random var2);
}

