/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.world.populator.builtin;

import com.elmakers.mine.bukkit.utility.ConfigurationUtils;
import com.elmakers.mine.bukkit.utility.StringUtils;
import com.elmakers.mine.bukkit.utility.random.RandomUtils;
import com.elmakers.mine.bukkit.utility.random.WeightedPair;
import com.elmakers.mine.bukkit.world.populator.MagicChunkPopulator;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class ChestPopulator
extends MagicChunkPopulator {
    private final Deque<WeightedPair<Integer>> baseProbability = new ArrayDeque<WeightedPair<Integer>>();
    private final Deque<WeightedPair<String>> itemProbability = new ArrayDeque<WeightedPair<String>>();
    private final Set<Material> removeItems = new HashSet<Material>();
    private boolean clearItems = false;
    private int maxY = 255;
    private int minY = 0;

    @Override
    public boolean onLoad(ConfigurationSection config) {
        ConfigurationSection wands;
        this.baseProbability.clear();
        this.itemProbability.clear();
        this.maxY = config.getInt("max_y", this.maxY);
        this.minY = config.getInt("min_y", this.minY);
        ConfigurationSection base = config.getConfigurationSection("base_probability");
        if (base != null) {
            RandomUtils.populateIntegerProbabilityMap(this.baseProbability, base);
        }
        if ((wands = config.getConfigurationSection("item_probability")) != null) {
            RandomUtils.populateStringProbabilityMap(this.itemProbability, wands);
        }
        this.clearItems = config.getBoolean("clear_items", false);
        List<String> removeItemKeys = ConfigurationUtils.getStringList(config, "remove_items");
        if (removeItemKeys != null && !removeItemKeys.isEmpty()) {
            for (String removeItemKey : removeItemKeys) {
                try {
                    Material itemType = Material.valueOf((String)removeItemKey.toUpperCase());
                    this.removeItems.add(itemType);
                }
                catch (Exception ex) {
                    this.controller.getLogger().warning("Invalid material in remove_items list: " + removeItemKey);
                }
            }
        }
        return this.clearItems || this.baseProbability.size() > 0 && this.itemProbability.size() > 0 || !this.removeItems.isEmpty();
    }

    protected int clearChest(Chest chest) {
        int itemsRemoved = 0;
        if (this.clearItems) {
            chest.getInventory().clear();
        } else if (!this.removeItems.isEmpty()) {
            Inventory inventory = chest.getInventory();
            for (int i = 0; i < inventory.getSize(); ++i) {
                ItemStack item = inventory.getItem(i);
                if (item == null || !this.removeItems.contains(item.getType())) continue;
                inventory.setItem(i, null);
                ++itemsRemoved;
            }
        }
        return itemsRemoved;
    }

    @Nullable
    protected String[] populateChest(Chest chest) {
        String[] itemsAdded = null;
        if (!this.baseProbability.isEmpty()) {
            Integer itemCount = (Integer)RandomUtils.weightedRandom(this.baseProbability);
            itemsAdded = new String[itemCount.intValue()];
            for (int i = 0; i < itemCount; ++i) {
                Object wandName = (String)RandomUtils.weightedRandom(this.itemProbability);
                ItemStack item = this.controller.createItem((String)wandName);
                if (item != null) {
                    chest.getInventory().addItem(new ItemStack[]{item});
                } else {
                    wandName = "*" + (String)wandName;
                }
                itemsAdded[i] = wandName;
            }
        }
        return itemsAdded;
    }

    public void setMaxY(int maxY) {
        this.maxY = maxY;
    }

    public void populate(World world, Random random, Chunk chunk) {
        BlockState[] tiles;
        for (BlockState block : tiles = chunk.getTileEntities()) {
            if (block.getType() != Material.CHEST || !(block instanceof Chest) || block.getY() < this.minY || block.getY() > this.maxY) continue;
            Chest chest = (Chest)block;
            if (block.getType() != Material.CHEST) continue;
            Object[] itemsAdded = this.populateChest(chest);
            int itemsRemoved = this.clearChest(chest);
            if (this.controller == null) continue;
            Location location = block.getLocation();
            if (this.clearItems) {
                this.controller.info("Cleared chest at: " + location.getWorld().getName() + "," + String.valueOf(location.toVector()));
            } else if (itemsRemoved > 0) {
                this.controller.info("Removed " + itemsRemoved + " items from chest at: " + location.getWorld().getName() + "," + String.valueOf(location.toVector()));
            }
            if (itemsAdded == null || itemsAdded.length <= 0) continue;
            this.controller.info("Added items to chest: " + StringUtils.join(itemsAdded, ", ") + " at " + location.getWorld().getName() + "," + String.valueOf(location.toVector()));
        }
    }
}

