/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena;

import com.garbagemule.MobArena.ArenaClass;
import com.garbagemule.MobArena.ArenaListener;
import com.garbagemule.MobArena.ArenaPlayer;
import com.garbagemule.MobArena.ClassLimitManager;
import com.garbagemule.MobArena.MASpawnThread;
import com.garbagemule.MobArena.MAUtils;
import com.garbagemule.MobArena.Messenger;
import com.garbagemule.MobArena.MobArena;
import com.garbagemule.MobArena.MonsterManager;
import com.garbagemule.MobArena.Msg;
import com.garbagemule.MobArena.RewardManager;
import com.garbagemule.MobArena.ScoreboardManager;
import com.garbagemule.MobArena.events.ArenaEndEvent;
import com.garbagemule.MobArena.events.ArenaPlayerDeathEvent;
import com.garbagemule.MobArena.events.ArenaPlayerJoinEvent;
import com.garbagemule.MobArena.events.ArenaPlayerLeaveEvent;
import com.garbagemule.MobArena.events.ArenaPlayerReadyEvent;
import com.garbagemule.MobArena.events.ArenaStartEvent;
import com.garbagemule.MobArena.framework.Arena;
import com.garbagemule.MobArena.leaderboards.Leaderboard;
import com.garbagemule.MobArena.region.ArenaRegion;
import com.garbagemule.MobArena.repairable.Repairable;
import com.garbagemule.MobArena.repairable.RepairableComparator;
import com.garbagemule.MobArena.repairable.RepairableContainer;
import com.garbagemule.MobArena.steps.PlayerJoinArena;
import com.garbagemule.MobArena.steps.PlayerSpecArena;
import com.garbagemule.MobArena.steps.Step;
import com.garbagemule.MobArena.steps.StepFactory;
import com.garbagemule.MobArena.things.Thing;
import com.garbagemule.MobArena.util.ClassChests;
import com.garbagemule.MobArena.util.config.ConfigUtils;
import com.garbagemule.MobArena.util.inventory.InventoryManager;
import com.garbagemule.MobArena.util.timer.AutoStartTimer;
import com.garbagemule.MobArena.util.timer.StartDelayTimer;
import com.garbagemule.MobArena.waves.SheepBouncer;
import com.garbagemule.MobArena.waves.WaveManager;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Horse;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Wolf;
import org.bukkit.event.Event;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;

public class ArenaImpl
implements Arena {
    private MobArena plugin;
    private String name;
    private World world;
    private Messenger messenger;
    private ConfigurationSection settings;
    private boolean enabled;
    private boolean protect;
    private boolean running;
    private boolean edit;
    private boolean allowMonsters;
    private boolean allowAnimals;
    private ArenaRegion region;
    private Leaderboard leaderboard;
    private InventoryManager inventoryManager;
    private RewardManager rewardManager;
    private ClassLimitManager limitManager;
    private Map<Player, ArenaPlayer> arenaPlayerMap;
    private Set<Player> arenaPlayers;
    private Set<Player> lobbyPlayers;
    private Set<Player> readyPlayers;
    private Set<Player> specPlayers;
    private Set<Player> deadPlayers;
    private Set<Player> movingPlayers;
    private Set<Player> leavingPlayers;
    private Set<Player> randoms;
    private ArenaClass defaultClass;
    private Map<String, ArenaClass> classes;
    private Map<Player, PermissionAttachment> attachments;
    private PriorityBlockingQueue<Repairable> repairQueue;
    private Set<Block> blocks;
    private LinkedList<Repairable> repairables;
    private LinkedList<Repairable> containables;
    private MonsterManager monsterManager;
    private WaveManager waveManager;
    private MASpawnThread spawnThread;
    private SheepBouncer sheepBouncer;
    private Map<Integer, List<Thing>> everyWaveMap;
    private Map<Integer, List<Thing>> afterWaveMap;
    private ArenaListener eventListener;
    private List<Thing> entryFee;
    private AutoStartTimer autoStartTimer;
    private StartDelayTimer startDelayTimer;
    private boolean isolatedChat;
    private ScoreboardManager scoreboard;
    private Player lastStanding;
    private Map<Player, Step> histories;
    private StepFactory playerJoinArena;
    private StepFactory playerSpecArena;

    public ArenaImpl(MobArena plugin, ConfigurationSection section, String name, World world) {
        if (world == null) {
            throw new NullPointerException("[MobArena] ERROR! World for arena '" + name + "' does not exist!");
        }
        this.name = name;
        this.world = world;
        this.plugin = plugin;
        this.settings = ConfigUtils.makeSection(section, "settings");
        this.region = new ArenaRegion(section, this);
        this.enabled = this.settings.getBoolean("enabled", false);
        this.protect = this.settings.getBoolean("protect", true);
        this.running = false;
        this.edit = false;
        this.inventoryManager = new InventoryManager();
        this.rewardManager = new RewardManager(this);
        this.leaderboard = new Leaderboard(plugin, this, this.region.getLeaderboard());
        this.arenaPlayerMap = new HashMap<Player, ArenaPlayer>();
        this.arenaPlayers = new HashSet<Player>();
        this.lobbyPlayers = new HashSet<Player>();
        this.readyPlayers = new HashSet<Player>();
        this.specPlayers = new HashSet<Player>();
        this.deadPlayers = new HashSet<Player>();
        this.randoms = new HashSet<Player>();
        this.movingPlayers = new HashSet<Player>();
        this.leavingPlayers = new HashSet<Player>();
        this.classes = plugin.getArenaMaster().getClasses();
        this.attachments = new HashMap<Player, PermissionAttachment>();
        this.limitManager = new ClassLimitManager(this, this.classes, ConfigUtils.makeSection(section, "class-limits"));
        String defaultClassName = this.settings.getString("default-class", null);
        if (defaultClassName != null) {
            this.defaultClass = this.classes.get(defaultClassName);
        }
        this.repairQueue = new PriorityBlockingQueue<Repairable>(100, new RepairableComparator());
        this.blocks = new HashSet<Block>();
        this.repairables = new LinkedList();
        this.containables = new LinkedList();
        this.monsterManager = new MonsterManager();
        this.waveManager = new WaveManager(this, section.getConfigurationSection("waves"));
        this.everyWaveMap = MAUtils.getArenaRewardMap(plugin, section, name, "every");
        this.afterWaveMap = MAUtils.getArenaRewardMap(plugin, section, name, "after");
        this.eventListener = new ArenaListener(this, plugin);
        this.allowMonsters = world.getAllowMonsters();
        this.allowAnimals = world.getAllowAnimals();
        this.entryFee = new ArrayList<Thing>();
        String feeString = this.settings.getString("entry-fee", "");
        if (feeString != null && !feeString.isEmpty()) {
            for (String fee : feeString.split(",")) {
                try {
                    Thing thing = plugin.getThingManager().parse(fee.trim());
                    if (thing == null) {
                        plugin.getLogger().warning("Failed to parse entry fee: " + fee.trim());
                        continue;
                    }
                    this.entryFee.add(thing);
                }
                catch (Exception e) {
                    plugin.getLogger().severe("Exception parsing entry fee '" + fee.trim() + "': " + e.getLocalizedMessage());
                }
            }
        }
        this.autoStartTimer = new AutoStartTimer(this);
        this.startDelayTimer = new StartDelayTimer(this, this.autoStartTimer);
        this.isolatedChat = this.settings.getBoolean("isolated-chat", false);
        this.scoreboard = this.settings.getBoolean("use-scoreboards", true) ? new ScoreboardManager(this) : new ScoreboardManager.NullScoreboardManager(this);
        String prefix = this.settings.getString("prefix", "");
        this.messenger = !prefix.isEmpty() ? new Messenger(prefix) : plugin.getGlobalMessenger();
        this.histories = new HashMap<Player, Step>();
        this.playerJoinArena = PlayerJoinArena.create(this);
        this.playerSpecArena = PlayerSpecArena.create(this);
    }

    @Override
    public ConfigurationSection getSettings() {
        return this.settings;
    }

    @Override
    public World getWorld() {
        return this.world;
    }

    @Override
    public void setWorld(World world) {
        this.world = world;
        this.settings.set("world", (Object)world.getName());
        this.plugin.saveConfig();
        if (this.region != null) {
            this.region.refreshWorld();
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean value) {
        this.enabled = value;
        this.settings.set("enabled", (Object)this.enabled);
    }

    @Override
    public boolean isProtected() {
        return this.protect;
    }

    @Override
    public void setProtected(boolean value) {
        this.protect = value;
        this.settings.set("protect", (Object)this.protect);
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public boolean inEditMode() {
        return this.edit;
    }

    @Override
    public void setEditMode(boolean value) {
        this.edit = value;
    }

    @Override
    public int getMinPlayers() {
        return this.settings.getInt("min-players");
    }

    @Override
    public int getMaxPlayers() {
        return this.settings.getInt("max-players");
    }

    private int getJoinDistance() {
        return this.settings.getInt("max-join-distance");
    }

    @Override
    public List<Thing> getEntryFee() {
        return this.entryFee;
    }

    @Override
    public Set<Map.Entry<Integer, List<Thing>>> getEveryWaveEntrySet() {
        return this.everyWaveMap.entrySet();
    }

    @Override
    public List<Thing> getAfterWaveReward(int wave) {
        return this.afterWaveMap.get(wave);
    }

    @Override
    public Set<Player> getPlayersInArena() {
        return Collections.unmodifiableSet(this.arenaPlayers);
    }

    @Override
    public Set<Player> getPlayersInLobby() {
        return Collections.unmodifiableSet(this.lobbyPlayers);
    }

    @Override
    public Set<Player> getReadyPlayersInLobby() {
        return Collections.unmodifiableSet(this.readyPlayers);
    }

    @Override
    public Set<Player> getSpectators() {
        return Collections.unmodifiableSet(this.specPlayers);
    }

    @Override
    public MASpawnThread getSpawnThread() {
        return this.spawnThread;
    }

    @Override
    public WaveManager getWaveManager() {
        return this.waveManager;
    }

    @Override
    public ArenaListener getEventListener() {
        return this.eventListener;
    }

    @Override
    public void setLeaderboard(Leaderboard leaderboard) {
        this.leaderboard = leaderboard;
    }

    @Override
    public ArenaPlayer getArenaPlayer(Player p) {
        return this.arenaPlayerMap.get(p);
    }

    @Override
    public Set<Block> getBlocks() {
        return this.blocks;
    }

    @Override
    public void addBlock(Block b) {
        this.blocks.add(b);
    }

    @Override
    public boolean removeBlock(Block b) {
        return this.blocks.remove(b);
    }

    @Override
    public boolean hasPet(Entity e) {
        return this.monsterManager.hasPet(e);
    }

    @Override
    public void addRepairable(Repairable r) {
        this.repairables.add(r);
    }

    @Override
    public ArenaRegion getRegion() {
        return this.region;
    }

    @Override
    public InventoryManager getInventoryManager() {
        return this.inventoryManager;
    }

    @Override
    public RewardManager getRewardManager() {
        return this.rewardManager;
    }

    @Override
    public MonsterManager getMonsterManager() {
        return this.monsterManager;
    }

    @Override
    public ClassLimitManager getClassLimitManager() {
        return this.limitManager;
    }

    @Override
    public ScoreboardManager getScoreboard() {
        return this.scoreboard;
    }

    @Override
    public Messenger getMessenger() {
        return this.messenger;
    }

    @Override
    public Messenger getGlobalMessenger() {
        return this.plugin.getGlobalMessenger();
    }

    @Override
    public void announce(String msg) {
        for (Player p : this.getAllPlayers()) {
            this.messenger.tell((CommandSender)p, msg);
        }
    }

    @Override
    public void announce(Msg msg, String s) {
        this.announce(msg.format(s));
    }

    @Override
    public void announce(Msg msg) {
        this.announce(msg.toString());
    }

    @Override
    public boolean startArena() {
        if (this.running || this.lobbyPlayers.isEmpty() || !this.readyPlayers.containsAll(this.lobbyPlayers)) {
            return false;
        }
        if (this.startDelayTimer.isRunning()) {
            return false;
        }
        this.autoStartTimer.stop();
        ArenaStartEvent event = new ArenaStartEvent(this);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        this.storeContainerContents();
        this.arenaPlayers.addAll(this.lobbyPlayers);
        this.lobbyPlayers.clear();
        this.readyPlayers.clear();
        for (Player p : this.randoms) {
            this.assignRandomClass(p);
        }
        this.randoms.clear();
        if (this.arenaPlayers.isEmpty()) {
            return false;
        }
        this.scoreboard.initialize();
        for (Player p : this.arenaPlayers) {
            if (this.inSpec(p)) {
                this.specPlayers.remove(p);
                System.out.println("[MobArena] Player " + p.getName() + " joined the arena from the spec area!");
                System.out.println("[MobArena] Invincibility glitch attempt stopped!");
            }
            this.movingPlayers.add(p);
            p.teleport(this.region.getArenaWarp());
            this.movingPlayers.remove(p);
            this.assignClassPermissions(p);
            this.arenaPlayerMap.get(p).resetStats();
            Thing price = this.arenaPlayerMap.get(p).getArenaClass().getPrice();
            if (price != null) {
                price.takeFrom(p);
            }
            this.scoreboard.addPlayer(p);
        }
        this.startSpawner();
        this.startBouncingSheep();
        this.running = true;
        this.spawnPets();
        this.spawnMounts();
        this.limitManager.clearClassesInUse();
        this.rewardManager.reset();
        this.leaderboard.initialize();
        this.leaderboard.startTracking();
        this.announce(Msg.ARENA_START);
        return true;
    }

    @Override
    public boolean endArena() {
        if (!this.running || !this.arenaPlayers.isEmpty()) {
            return false;
        }
        ArenaEndEvent event = new ArenaEndEvent(this);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        this.lastStanding = null;
        boolean en = this.enabled;
        this.enabled = false;
        this.running = false;
        this.leaderboard.stopTracking();
        this.leaderboard.update();
        this.stopSpawner();
        if (this.settings.getBoolean("global-end-announce", false)) {
            for (Player p : Bukkit.getOnlinePlayers()) {
                this.messenger.tell((CommandSender)p, Msg.ARENA_END_GLOBAL, this.configName());
            }
        } else {
            this.announce(Msg.ARENA_END);
        }
        this.cleanup();
        if (this.settings.getBoolean("soft-restore", false)) {
            this.restoreRegion();
        }
        this.restoreContainerContents();
        this.enabled = en;
        return true;
    }

    @Override
    public void forceStart() {
        if (this.running) {
            return;
        }
        HashSet<Player> tmp = new HashSet<Player>();
        tmp.addAll(this.lobbyPlayers);
        tmp.removeAll(this.readyPlayers);
        for (Player p : tmp) {
            this.playerLeave(p);
            this.messenger.tell((CommandSender)p, Msg.LEAVE_NOT_READY);
        }
        this.startDelayTimer.stop();
        this.startArena();
    }

    @Override
    public void forceEnd() {
        List<Player> players = this.getAllPlayers();
        if (players.isEmpty()) {
            return;
        }
        players.forEach(this::playerLeave);
        this.cleanup();
    }

    @Override
    public boolean hasPermission(Player p) {
        String perm = "mobarena.arenas." + this.name;
        return !p.isPermissionSet(perm) || p.hasPermission(perm);
    }

    @Override
    public boolean playerJoin(Player p, Location loc) {
        ArenaPlayerJoinEvent event = new ArenaPlayerJoinEvent(p, this);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        if (this.movingPlayers.contains(p)) {
            return false;
        }
        this.movingPlayers.add(p);
        this.rollback(p);
        this.specPlayers.remove(p);
        if (!this.entryFee.isEmpty()) {
            if (!this.takeFee(p)) {
                this.messenger.tell((CommandSender)p, Msg.JOIN_FEE_REQUIRED, MAUtils.listToString(this.entryFee, this.plugin));
                return false;
            }
            this.messenger.tell((CommandSender)p, Msg.JOIN_FEE_PAID.format(MAUtils.listToString(this.entryFee, this.plugin)));
        }
        if (this.settings.getBoolean("global-join-announce", false) && this.lobbyPlayers.isEmpty()) {
            for (Player q : Bukkit.getOnlinePlayers()) {
                this.messenger.tell((CommandSender)q, Msg.ARENA_JOIN_GLOBAL, this.configName());
            }
        }
        Step step = this.playerJoinArena.create(p);
        try {
            step.run();
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, () -> "Player " + p.getName() + " couldn't join arena " + this.name);
            return false;
        }
        this.histories.put(p, step);
        this.lobbyPlayers.add(p);
        this.plugin.getArenaMaster().addPlayer(p, this);
        this.arenaPlayerMap.put(p, new ArenaPlayer(p, this, this.plugin));
        if (!this.autoStartTimer.isRunning()) {
            this.startDelayTimer.start();
        }
        this.messenger.tell((CommandSender)p, Msg.JOIN_PLAYER_JOINED);
        if (this.startDelayTimer.isRunning()) {
            this.messenger.tell((CommandSender)p, Msg.ARENA_START_DELAY, "" + this.startDelayTimer.getRemaining() / 20L);
        } else if (this.autoStartTimer.isRunning()) {
            this.messenger.tell((CommandSender)p, Msg.ARENA_AUTO_START, "" + this.autoStartTimer.getRemaining() / 20L);
        }
        if (this.defaultClass != null && !ClassChests.assignClassFromStoredClassChest(this, p, this.defaultClass)) {
            this.assignClass(p, this.defaultClass.getLowercaseName());
            this.messenger.tell((CommandSender)p, Msg.LOBBY_CLASS_PICKED, this.defaultClass.getConfigName());
        }
        this.movingPlayers.remove(p);
        return true;
    }

    @Override
    public void playerReady(Player p) {
        ArenaPlayerReadyEvent event = new ArenaPlayerReadyEvent(p, this);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        this.readyPlayers.add(p);
        int minPlayers = this.getMinPlayers();
        if (minPlayers > 0 && this.lobbyPlayers.size() < minPlayers) {
            this.messenger.tell((CommandSender)p, Msg.LOBBY_NOT_ENOUGH_PLAYERS, "" + minPlayers);
            return;
        }
        this.startArena();
    }

    @Override
    public boolean playerLeave(Player p) {
        ArenaPlayerLeaveEvent event = new ArenaPlayerLeaveEvent(p, this);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        if (this.leavingPlayers.contains(p)) {
            return false;
        }
        this.leavingPlayers.add(p);
        if (this.arenaPlayers.contains(p)) {
            this.unmount(p);
            this.clearInv(p);
        }
        this.removeClassPermissions(p);
        this.removePotionEffects(p);
        boolean refund = this.inLobby(p);
        if (this.inLobby(p)) {
            ArenaPlayer ap = this.arenaPlayerMap.get(p);
            if (ap.getArenaClass() != null) {
                this.limitManager.playerLeftClass(ap.getArenaClass(), ap.getPlayer());
            }
            if (this.lobbyPlayers.size() == 1) {
                this.startDelayTimer.stop();
            }
        }
        this.discardPlayer(p);
        if (refund) {
            this.refund(p);
        }
        this.endArena();
        this.leavingPlayers.remove(p);
        return true;
    }

    @Override
    public boolean isMoving(Player p) {
        return this.movingPlayers.contains(p) || this.leavingPlayers.contains(p);
    }

    @Override
    public boolean isLeaving(Player p) {
        return this.leavingPlayers.contains(p);
    }

    @Override
    public void playerDeath(Player p) {
        boolean last;
        boolean bl = last = this.arenaPlayers.size() == 1;
        if (last) {
            this.lastStanding = p;
        }
        ArenaPlayerDeathEvent event = new ArenaPlayerDeathEvent(p, this, last);
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        if (this.arenaPlayers.remove(p)) {
            this.unmount(p);
            this.clearInv(p);
        }
        if (!this.settings.getBoolean("auto-respawn", true)) {
            this.deadPlayers.add(p);
            this.endArena();
            return;
        }
        p.setHealth(20.0);
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.revivePlayer(p));
        this.endArena();
    }

    private void clearInv(Player p) {
        InventoryView view = p.getOpenInventory();
        if (view != null) {
            view.setCursor(new ItemStack(0));
            view.getBottomInventory().clear();
            view.close();
        }
    }

    private void unmount(Player p) {
        Entity v = p.getVehicle();
        if (v != null) {
            this.monsterManager.removeMount(v);
            v.eject();
            v.remove();
        }
    }

    @Override
    public void playerRespawn(Player p) {
        if (this.settings.getBoolean("auto-respawn", true)) {
            return;
        }
        this.deadPlayers.remove(p);
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.revivePlayer(p));
    }

    @Override
    public void revivePlayer(Player p) {
        this.removeClassPermissions(p);
        this.removePotionEffects(p);
        this.discardPlayer(p);
        if (this.settings.getBoolean("spectate-on-death", true)) {
            this.playerSpec(p, null);
        }
    }

    @Override
    public Location getRespawnLocation(Player p) {
        return this.region.getSpecWarp();
    }

    @Override
    public void playerSpec(Player p, Location loc) {
        if (this.movingPlayers.contains(p)) {
            return;
        }
        this.movingPlayers.add(p);
        this.rollback(p);
        Step step = this.playerSpecArena.create(p);
        try {
            step.run();
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, () -> "Player " + p.getName() + " couldn't spec arena " + this.name);
            return;
        }
        this.histories.put(p, step);
        this.specPlayers.add(p);
        this.plugin.getArenaMaster().addPlayer(p, this);
        this.messenger.tell((CommandSender)p, Msg.SPEC_PLAYER_SPECTATE);
        this.movingPlayers.remove(p);
    }

    private void rollback(Player p) {
        Step step = this.histories.remove(p);
        if (step == null) {
            return;
        }
        try {
            step.undo();
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, () -> "Failed to revert player " + p.getName());
        }
    }

    private void spawnPets() {
        for (Player p : this.arenaPlayers) {
            int bone;
            PlayerInventory inv;
            ArenaClass ac;
            if (p == null || !p.isOnline() || (ac = this.arenaPlayerMap.get(p).getArenaClass()) == null || ac.getConfigName().equals("My Items") || (inv = p.getInventory()) == null || (bone = inv.first(Material.BONE)) == -1) continue;
            int amount = inv.getItem(bone).getAmount();
            for (int i = 0; i < amount; ++i) {
                Wolf wolf = (Wolf)this.world.spawnEntity(p.getLocation(), EntityType.WOLF);
                wolf.setTamed(true);
                wolf.setOwner((AnimalTamer)p);
                wolf.setHealth(wolf.getMaxHealth());
                if (this.settings.getBoolean("hellhounds")) {
                    wolf.setFireTicks(32768);
                }
                this.monsterManager.addPet(wolf);
            }
            inv.setItem(bone, null);
        }
    }

    private void spawnMounts() {
        for (Player p : this.arenaPlayers) {
            Material barding;
            int hay;
            PlayerInventory inv;
            ArenaClass ac;
            if (p == null || !p.isOnline() || (ac = this.arenaPlayerMap.get(p).getArenaClass()) == null || ac.getConfigName().equals("My Items") || (inv = p.getInventory()) == null || (hay = inv.first(Material.HAY_BLOCK)) == -1) continue;
            int amount = inv.getItem(hay).getAmount();
            EntityType type = this.horseTypeFromAmount(amount);
            AbstractHorse mount = (AbstractHorse)this.world.spawnEntity(p.getLocation(), type);
            if (MobArena.random.nextInt(20) == 0) {
                mount.setBaby();
            } else {
                mount.setAdult();
            }
            mount.setTamed(true);
            mount.setOwner((AnimalTamer)p);
            mount.setPassenger((Entity)p);
            mount.setHealth(mount.getMaxHealth());
            mount.getInventory().addItem(new ItemStack[]{new ItemStack(Material.SADDLE)});
            if (type == EntityType.HORSE && (barding = this.bardingFromAmount(amount)) != null) {
                ((Horse)mount).getInventory().setArmor(new ItemStack(barding));
            }
            this.monsterManager.addMount((LivingEntity)mount);
            inv.setItem(hay, null);
        }
    }

    private EntityType horseTypeFromAmount(int amount) {
        switch (amount % 8) {
            case 2: {
                return EntityType.DONKEY;
            }
            case 3: {
                return EntityType.MULE;
            }
            case 4: {
                return EntityType.SKELETON_HORSE;
            }
            case 5: {
                return EntityType.ZOMBIE_HORSE;
            }
        }
        return EntityType.HORSE;
    }

    private Material bardingFromAmount(int amount) {
        switch ((amount >> 3) % 4) {
            case 1: {
                return Material.IRON_BARDING;
            }
            case 2: {
                return Material.GOLD_BARDING;
            }
            case 3: {
                return Material.DIAMOND_BARDING;
            }
        }
        return null;
    }

    private void removePotionEffects(Player p) {
        for (PotionEffect effect : p.getActivePotionEffects()) {
            p.removePotionEffect(effect.getType());
        }
    }

    private void startSpawner() {
        this.world.setSpawnFlags(true, true);
        if (this.spawnThread == null) {
            this.spawnThread = new MASpawnThread(this.plugin, this);
        } else {
            this.spawnThread.reset();
        }
        this.scheduleTask(this.spawnThread, this.settings.getInt("first-wave-delay", 5) * 20);
        this.scheduleTask(new Runnable(){

            @Override
            public void run() {
                ArenaImpl.this.eventListener.pvpActivate();
            }
        }, this.settings.getInt("first-wave-delay", 5) * 20);
    }

    @Override
    public void scheduleTask(Runnable r, int delay) {
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, r, (long)delay);
    }

    private void stopSpawner() {
        this.world.setSpawnFlags(this.allowMonsters, this.allowAnimals);
        this.eventListener.pvpDeactivate();
    }

    private void startBouncingSheep() {
        if (this.sheepBouncer == null) {
            this.sheepBouncer = new SheepBouncer(this);
        }
        this.scheduleTask(this.sheepBouncer, this.settings.getInt("first-wave-delay", 5) * 20);
    }

    @Override
    public void storeContainerContents() {
        for (Location loc : this.region.getContainers()) {
            BlockState state = this.world.getBlockAt(loc).getState();
            if (!(state instanceof InventoryHolder)) continue;
            this.containables.add(new RepairableContainer(state, false));
        }
    }

    @Override
    public void restoreContainerContents() {
        for (Repairable r : this.containables) {
            r.repair();
        }
    }

    @Override
    public void discardPlayer(Player p) {
        this.rollback(p);
        this.plugin.getArenaMaster().removePlayer(p);
        this.clearPlayer(p);
    }

    private void clearPlayer(Player p) {
        this.monsterManager.removePets(p);
        this.readyPlayers.remove(p);
        this.specPlayers.remove(p);
        this.arenaPlayers.remove(p);
        this.lobbyPlayers.remove(p);
        this.arenaPlayerMap.remove(p);
        this.scoreboard.removePlayer(p);
    }

    @Override
    public void repairBlocks() {
        while (!this.repairQueue.isEmpty()) {
            this.repairQueue.poll().repair();
        }
    }

    @Override
    public void queueRepairable(Repairable r) {
        this.repairQueue.add(r);
    }

    @Override
    public void assignClass(Player p, String className) {
        ArenaPlayer arenaPlayer = this.arenaPlayerMap.get(p);
        ArenaClass arenaClass = this.classes.get(className);
        if (arenaPlayer == null || arenaClass == null) {
            return;
        }
        InventoryManager.clearInventory(p);
        arenaPlayer.setArenaClass(arenaClass);
        arenaClass.grantItems(p);
        PermissionAttachment pa = arenaClass.grantLobbyPermissions(this.plugin, p);
        this.replacePermissions(p, pa);
        this.autoReady(p);
    }

    @Override
    public void assignClassGiveInv(Player p, String className, ItemStack[] contents) {
        ArenaPlayer arenaPlayer = this.arenaPlayerMap.get(p);
        ArenaClass arenaClass = this.classes.get(className);
        if (arenaPlayer == null || arenaClass == null) {
            return;
        }
        InventoryManager.clearInventory(p);
        arenaPlayer.setArenaClass(arenaClass);
        PlayerInventory inv = p.getInventory();
        ItemStack helmet = null;
        ItemStack chestplate = null;
        ItemStack leggings = null;
        ItemStack boots = null;
        ItemStack offhand = null;
        int last = contents.length - 1;
        if (contents[last] != null) {
            helmet = contents[last].clone();
            contents[last] = null;
        }
        for (int i = contents.length - 1; i > contents.length - 5; --i) {
            ItemStack[] type;
            if (contents[i] == null || (type = ArenaClass.ArmorType.getType(contents[i])) == null || type == ArenaClass.ArmorType.HELMET) continue;
            switch (2.$SwitchMap$com$garbagemule$MobArena$ArenaClass$ArmorType[type.ordinal()]) {
                case 1: {
                    chestplate = contents[i].clone();
                    break;
                }
                case 2: {
                    leggings = contents[i].clone();
                    break;
                }
                case 3: {
                    boots = contents[i].clone();
                    break;
                }
            }
            contents[i] = null;
        }
        ItemStack fifth = contents[contents.length - 5];
        if (fifth != null) {
            offhand = fifth.clone();
            contents[contents.length - 5] = null;
        }
        if (arenaClass.hasUnbreakableWeapons()) {
            for (ItemStack stack : contents) {
                if (stack == null) continue;
                if (!ArenaClass.isWeapon(stack)) continue;
                stack.setDurability((short)Short.MIN_VALUE);
            }
        }
        inv.setContents(contents);
        inv.setHelmet(helmet);
        inv.setChestplate(chestplate);
        inv.setLeggings(leggings);
        inv.setBoots(boots);
        inv.setItemInOffHand(offhand);
        PermissionAttachment pa = arenaClass.grantLobbyPermissions(this.plugin, p);
        this.replacePermissions(p, pa);
        this.autoReady(p);
    }

    private void replacePermissions(Player p, PermissionAttachment rep) {
        PermissionAttachment old = this.attachments.get(p);
        if (old != null) {
            old.remove();
            p.recalculatePermissions();
        }
        if (rep != null) {
            this.attachments.put(p, rep);
            p.recalculatePermissions();
        }
    }

    private void autoReady(Player p) {
        if (this.settings.getBoolean("auto-ready", false)) {
            if (this.autoStartTimer.getRemaining() <= 0L) {
                this.playerReady(p);
            } else {
                this.readyPlayers.add(p);
            }
        }
    }

    @Override
    public void addRandomPlayer(Player p) {
        this.randoms.add(p);
    }

    @Override
    public void assignRandomClass(Player p) {
        List classes = this.classes.values().stream().filter(c -> c.hasPermission(p)).collect(Collectors.toList());
        if (classes.isEmpty()) {
            this.plugin.getLogger().info("Player '" + p.getName() + "' has no class permissions!");
            this.playerLeave(p);
            return;
        }
        int index = MobArena.random.nextInt(classes.size());
        String className = ((ArenaClass)classes.get(index)).getConfigName();
        this.assignClass(p, className);
        this.messenger.tell((CommandSender)p, Msg.LOBBY_CLASS_PICKED, this.classes.get(className).getConfigName());
    }

    @Override
    public void assignClassPermissions(Player p) {
        PermissionAttachment pa = this.arenaPlayerMap.get(p).getArenaClass().grantPermissions(this.plugin, p);
        this.replacePermissions(p, pa);
    }

    @Override
    public void removeClassPermissions(Player p) {
        PermissionAttachment pa = this.attachments.remove(p);
        if (pa == null) {
            return;
        }
        try {
            p.removeAttachment(pa);
        }
        catch (Exception e) {
            for (Map.Entry entry : pa.getPermissions().entrySet()) {
                String perm = (String)entry.getKey() + ":" + entry.getValue();
                String name = p.getName();
                this.plugin.getLogger().warning("[PERM01] Failed to remove permission attachment '" + perm + "' from player '" + name + "'.\nThis should not be a big issue, but please verify that the player doesn't have any permissions they shouldn't have.");
            }
        }
        p.recalculatePermissions();
    }

    @Override
    public void addPermission(Player p, String perm, boolean value) {
        PermissionAttachment pa = this.attachments.get(p);
        if (pa == null) {
            pa = p.addAttachment((Plugin)this.plugin);
            this.attachments.put(p, pa);
        }
        pa.setPermission(perm, value);
        p.recalculatePermissions();
    }

    private void cleanup() {
        this.removeMonsters();
        this.removeBlocks();
        this.removeEntities();
        this.clearPlayers();
    }

    private void removeMonsters() {
        this.monsterManager.clear();
    }

    private void removeBlocks() {
        for (Block b : this.blocks) {
            b.setType(Material.AIR);
        }
        this.blocks.clear();
    }

    private void removeEntities() {
        List<Chunk> chunks = this.region.getChunks();
        for (Chunk c : chunks) {
            for (Entity e : c.getEntities()) {
                if (e == null) continue;
                switch (e.getType()) {
                    case DROPPED_ITEM: 
                    case EXPERIENCE_ORB: 
                    case ARROW: 
                    case MINECART: 
                    case BOAT: 
                    case SHULKER_BULLET: {
                        e.remove();
                    }
                }
            }
        }
    }

    private void clearPlayers() {
        this.arenaPlayers.clear();
        this.arenaPlayerMap.clear();
        this.lobbyPlayers.clear();
        this.readyPlayers.clear();
    }

    @Override
    public void restoreRegion() {
        Collections.sort(this.repairables, new RepairableComparator());
        for (Repairable r : this.repairables) {
            r.repair();
        }
    }

    @Override
    public boolean inArena(Player p) {
        return this.arenaPlayers.contains(p);
    }

    @Override
    public boolean inLobby(Player p) {
        return this.lobbyPlayers.contains(p);
    }

    @Override
    public boolean inSpec(Player p) {
        return this.specPlayers.contains(p);
    }

    @Override
    public boolean isDead(Player p) {
        return this.deadPlayers.contains(p);
    }

    @Override
    public String configName() {
        return this.name;
    }

    @Override
    public String arenaName() {
        return MAUtils.nameConfigToArena(this.name);
    }

    @Override
    public MobArena getPlugin() {
        return this.plugin;
    }

    @Override
    public Map<String, ArenaClass> getClasses() {
        return this.classes;
    }

    @Override
    public int getPlayerCount() {
        return this.spawnThread.getPlayerCount();
    }

    @Override
    public List<Player> getAllPlayers() {
        LinkedList<Player> result = new LinkedList<Player>();
        result.addAll(this.arenaPlayers);
        result.addAll(this.lobbyPlayers);
        result.addAll(this.specPlayers);
        return result;
    }

    @Override
    public Collection<ArenaPlayer> getArenaPlayerSet() {
        return this.arenaPlayerMap.values();
    }

    @Override
    public AutoStartTimer getAutoStartTimer() {
        return this.autoStartTimer;
    }

    @Override
    public List<Player> getNonreadyPlayers() {
        LinkedList<Player> result = new LinkedList<Player>();
        result.addAll(this.lobbyPlayers);
        result.removeAll(this.readyPlayers);
        return result;
    }

    @Override
    public boolean canAfford(Player p) {
        for (Thing fee : this.entryFee) {
            if (fee.heldBy(p)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean takeFee(Player p) {
        ArrayDeque<Thing> paid = new ArrayDeque<Thing>();
        for (Thing fee : this.entryFee) {
            if (fee.takeFrom(p)) {
                paid.push(fee);
                continue;
            }
            while (!paid.isEmpty()) {
                ((Thing)paid.pop()).giveTo(p);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean refund(Player p) {
        this.entryFee.forEach(fee -> fee.giveTo(p));
        return true;
    }

    @Override
    public boolean canJoin(Player p) {
        if (!this.enabled) {
            this.messenger.tell((CommandSender)p, Msg.JOIN_ARENA_NOT_ENABLED);
        } else if (!this.region.isSetup() || this.waveManager.getRecurrentWaves().isEmpty()) {
            this.messenger.tell((CommandSender)p, Msg.JOIN_ARENA_NOT_SETUP);
        } else if (this.edit) {
            this.messenger.tell((CommandSender)p, Msg.JOIN_ARENA_EDIT_MODE);
        } else if (this.arenaPlayers.contains(p) || this.lobbyPlayers.contains(p)) {
            this.messenger.tell((CommandSender)p, Msg.JOIN_ALREADY_PLAYING);
        } else if (this.running) {
            this.messenger.tell((CommandSender)p, Msg.JOIN_ARENA_IS_RUNNING);
        } else if (!this.hasPermission(p)) {
            this.messenger.tell((CommandSender)p, Msg.JOIN_ARENA_PERMISSION);
        } else if (this.getMaxPlayers() > 0 && this.lobbyPlayers.size() >= this.getMaxPlayers()) {
            this.messenger.tell((CommandSender)p, Msg.JOIN_PLAYER_LIMIT_REACHED);
        } else if (this.getJoinDistance() > 0 && !this.region.contains(p.getLocation(), this.getJoinDistance())) {
            this.messenger.tell((CommandSender)p, Msg.JOIN_TOO_FAR);
        } else if (this.settings.getBoolean("require-empty-inv-join", true) && !InventoryManager.hasEmptyInventory(p)) {
            this.messenger.tell((CommandSender)p, Msg.JOIN_EMPTY_INV);
        } else if (!this.canAfford(p)) {
            this.messenger.tell((CommandSender)p, Msg.JOIN_FEE_REQUIRED, MAUtils.listToString(this.entryFee, this.plugin));
        } else {
            return true;
        }
        return false;
    }

    @Override
    public boolean canSpec(Player p) {
        if (!this.enabled) {
            this.messenger.tell((CommandSender)p, Msg.JOIN_ARENA_NOT_ENABLED);
        } else if (!this.region.isSetup()) {
            this.messenger.tell((CommandSender)p, Msg.JOIN_ARENA_NOT_SETUP);
        } else if (this.edit) {
            this.messenger.tell((CommandSender)p, Msg.JOIN_ARENA_EDIT_MODE);
        } else if (this.arenaPlayers.contains(p) || this.lobbyPlayers.contains(p)) {
            this.messenger.tell((CommandSender)p, Msg.SPEC_ALREADY_PLAYING);
        } else if (this.settings.getBoolean("require-empty-inv-spec", true) && !InventoryManager.hasEmptyInventory(p)) {
            this.messenger.tell((CommandSender)p, Msg.SPEC_EMPTY_INV);
        } else if (this.getJoinDistance() > 0 && !this.region.contains(p.getLocation(), this.getJoinDistance())) {
            this.messenger.tell((CommandSender)p, Msg.JOIN_TOO_FAR);
        } else {
            return true;
        }
        return false;
    }

    @Override
    public boolean hasIsolatedChat() {
        return this.isolatedChat;
    }

    @Override
    public Player getLastPlayerStanding() {
        return this.lastStanding;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        return other instanceof ArenaImpl && ((ArenaImpl)other).name.equals(this.name);
    }

    public String toString() {
        return (this.enabled && this.region.isSetup() ? ChatColor.GREEN : ChatColor.GRAY) + this.configName();
    }
}

