/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena;

import com.garbagemule.MobArena.ArenaClass;
import com.garbagemule.MobArena.ArenaImpl;
import com.garbagemule.MobArena.Messenger;
import com.garbagemule.MobArena.MobArena;
import com.garbagemule.MobArena.framework.Arena;
import com.garbagemule.MobArena.framework.ArenaMaster;
import com.garbagemule.MobArena.things.Thing;
import com.garbagemule.MobArena.util.ItemParser;
import com.garbagemule.MobArena.util.TextUtils;
import com.garbagemule.MobArena.util.config.ConfigUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;

public class ArenaMasterImpl
implements ArenaMaster {
    private MobArena plugin;
    private FileConfiguration config;
    private List<Arena> arenas;
    private Map<Player, Arena> arenaMap;
    private Arena selectedArena;
    private Map<String, ArenaClass> classes;
    private Set<String> allowedCommands;
    private boolean enabled;

    public ArenaMasterImpl(MobArena plugin) {
        this.plugin = plugin;
        this.config = plugin.getConfig();
        this.arenas = new ArrayList<Arena>();
        this.arenaMap = new HashMap<Player, Arena>();
        this.classes = new HashMap<String, ArenaClass>();
        this.allowedCommands = new HashSet<String>();
        this.enabled = this.config.getBoolean("global-settings.enabled", true);
    }

    @Override
    public MobArena getPlugin() {
        return this.plugin;
    }

    @Override
    public Messenger getGlobalMessenger() {
        return this.plugin.getGlobalMessenger();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean value) {
        this.enabled = value;
        this.config.set("global-settings.enabled", (Object)this.enabled);
    }

    @Override
    public boolean notifyOnUpdates() {
        return this.config.getBoolean("global-settings.update-notification", false);
    }

    @Override
    public List<Arena> getArenas() {
        return this.arenas;
    }

    @Override
    public Map<String, ArenaClass> getClasses() {
        return this.classes;
    }

    @Override
    public void addPlayer(Player p, Arena arena) {
        this.arenaMap.put(p, arena);
    }

    @Override
    public Arena removePlayer(Player p) {
        return this.arenaMap.remove(p);
    }

    @Override
    public void resetArenaMap() {
        this.arenaMap.clear();
    }

    @Override
    public boolean isAllowed(String command) {
        return this.allowedCommands.contains(command);
    }

    @Override
    public List<Arena> getEnabledArenas() {
        return this.getEnabledArenas(this.arenas);
    }

    @Override
    public List<Arena> getEnabledArenas(List<Arena> arenas) {
        ArrayList<Arena> result = new ArrayList<Arena>(arenas.size());
        for (Arena arena : arenas) {
            if (!arena.isEnabled()) continue;
            result.add(arena);
        }
        return result;
    }

    @Override
    public List<Arena> getPermittedArenas(Player p) {
        ArrayList<Arena> result = new ArrayList<Arena>(this.arenas.size());
        for (Arena arena : this.arenas) {
            if (!arena.hasPermission(p)) continue;
            result.add(arena);
        }
        return result;
    }

    @Override
    public List<Arena> getEnabledAndPermittedArenas(Player p) {
        ArrayList<Arena> result = new ArrayList<Arena>(this.arenas.size());
        for (Arena arena : this.arenas) {
            if (!arena.isEnabled() || !arena.hasPermission(p)) continue;
            result.add(arena);
        }
        return result;
    }

    @Override
    public Arena getArenaAtLocation(Location loc) {
        for (Arena arena : this.arenas) {
            if (!arena.getRegion().contains(loc)) continue;
            return arena;
        }
        return null;
    }

    @Override
    public List<Arena> getArenasInWorld(World world) {
        ArrayList<Arena> result = new ArrayList<Arena>(this.arenas.size());
        for (Arena arena : this.arenas) {
            if (!arena.getWorld().equals(world)) continue;
            result.add(arena);
        }
        return result;
    }

    @Override
    public List<Player> getAllPlayers() {
        ArrayList<Player> result = new ArrayList<Player>(this.arenas.size());
        for (Arena arena : this.arenas) {
            result.addAll(arena.getAllPlayers());
        }
        return result;
    }

    @Override
    public List<Player> getAllPlayersInArena(String arenaName) {
        Arena arena = this.getArenaWithName(arenaName);
        return arena != null ? new ArrayList<Player>(arena.getPlayersInArena()) : new ArrayList();
    }

    @Override
    public List<Player> getAllLivingPlayers() {
        ArrayList<Player> result = new ArrayList<Player>();
        for (Arena arena : this.arenas) {
            result.addAll(arena.getPlayersInArena());
        }
        return result;
    }

    @Override
    public List<Player> getLivingPlayersInArena(String arenaName) {
        Arena arena = this.getArenaWithName(arenaName);
        return arena != null ? new ArrayList<Player>(arena.getPlayersInArena()) : new ArrayList();
    }

    @Override
    public Arena getArenaWithPlayer(Player p) {
        return this.arenaMap.get(p);
    }

    @Override
    public Arena getArenaWithPlayer(String playerName) {
        return this.arenaMap.get(this.plugin.getServer().getPlayer(playerName));
    }

    @Override
    public Arena getArenaWithSpectator(Player p) {
        for (Arena arena : this.arenas) {
            if (!arena.getSpectators().contains(p)) continue;
            return arena;
        }
        return null;
    }

    @Override
    public Arena getArenaWithMonster(Entity e) {
        for (Arena arena : this.arenas) {
            if (!arena.getMonsterManager().getMonsters().contains(e)) continue;
            return arena;
        }
        return null;
    }

    @Override
    public Arena getArenaWithPet(Entity e) {
        for (Arena arena : this.arenas) {
            if (!arena.hasPet(e)) continue;
            return arena;
        }
        return null;
    }

    @Override
    public Arena getArenaWithName(String configName) {
        return this.getArenaWithName(this.arenas, configName);
    }

    @Override
    public Arena getArenaWithName(Collection<Arena> arenas, String configName) {
        for (Arena arena : arenas) {
            if (!arena.configName().equalsIgnoreCase(configName)) continue;
            return arena;
        }
        return null;
    }

    @Override
    public void initialize() {
        this.loadSettings();
        this.loadClasses();
        this.loadArenas();
    }

    @Override
    public void loadSettings() {
        ConfigurationSection section = this.plugin.getConfig().getConfigurationSection("global-settings");
        ConfigUtils.addMissingRemoveObsolete((Plugin)this.plugin, "global-settings.yml", section);
        String cmds = section.getString("allowed-commands", "");
        String[] parts = cmds.split(",");
        this.allowedCommands.add("/ma");
        for (String part : parts) {
            this.allowedCommands.add(part.trim().toLowerCase());
        }
    }

    @Override
    public void loadClasses() {
        ConfigurationSection section = ConfigUtils.makeSection((ConfigurationSection)this.plugin.getConfig(), "classes");
        ConfigUtils.addIfEmpty((Plugin)this.plugin, "classes.yml", section);
        this.classes = new HashMap<String, ArenaClass>();
        Set classNames = section.getKeys(false);
        for (String className : classNames) {
            this.loadClass(className);
        }
        this.loadClass("My Items");
    }

    private ArenaClass loadClass(String classname) {
        ConfigurationSection section = this.config.getConfigurationSection("classes." + classname);
        String lowercase = classname.toLowerCase().replace(" ", "");
        if (section == null) {
            if (classname.equals("My Items")) {
                ArenaClass.MyItems myItems = new ArenaClass.MyItems(null, false, false, this);
                this.classes.put(lowercase, myItems);
                return myItems;
            }
            this.plugin.getLogger().severe("Failed to load class '" + classname + "'.");
            return null;
        }
        boolean weps = section.getBoolean("unbreakable-weapons", true);
        boolean arms = section.getBoolean("unbreakable-armor", true);
        Thing price = null;
        String priceString = section.getString("price", null);
        if (priceString != null) {
            try {
                price = this.plugin.getThingManager().parse(priceString);
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Exception parsing class price: " + e.getLocalizedMessage());
                price = null;
            }
        }
        ArenaClass arenaClass = classname.equals("My Items") ? new ArenaClass.MyItems(price, weps, arms, this) : new ArenaClass(classname, price, weps, arms);
        this.loadClassItems(section, arenaClass);
        this.loadClassArmor(section, arenaClass);
        this.loadClassPermissions(arenaClass, section);
        this.loadClassLobbyPermissions(arenaClass, section);
        Location cc = ConfigUtils.parseLocation(section, "classchest", null);
        arenaClass.setClassChest(cc);
        this.classes.put(lowercase, arenaClass);
        return arenaClass;
    }

    private void loadClassItems(ConfigurationSection section, ArenaClass arenaClass) {
        List<String> items = section.getStringList("items");
        if (items == null || items.isEmpty()) {
            String value = section.getString("items", "");
            items = Arrays.asList(value.split(","));
        }
        List<Thing> things = items.stream().map(String::trim).map(this.plugin.getThingManager()::parse).filter(Objects::nonNull).collect(Collectors.toList());
        arenaClass.setItems(things);
    }

    private void loadClassArmor(ConfigurationSection section, ArenaClass arenaClass) {
        this.loadClassArmorLegacyNode(section, arenaClass);
        this.loadClassArmorPiece(section, "helmet", arenaClass::setHelmet);
        this.loadClassArmorPiece(section, "chestplate", arenaClass::setChestplate);
        this.loadClassArmorPiece(section, "leggings", arenaClass::setLeggings);
        this.loadClassArmorPiece(section, "boots", arenaClass::setBoots);
        this.loadClassArmorPiece(section, "offhand", arenaClass::setOffHand);
    }

    private void loadClassArmorLegacyNode(ConfigurationSection section, ArenaClass arenaClass) {
        List<String> armor = section.getStringList("armor");
        if (armor == null || armor.isEmpty()) {
            String value = section.getString("armor", "");
            armor = Arrays.asList(value.split(","));
        }
        List<Thing> things = armor.stream().map(String::trim).map(s -> "armor:" + s).map(this.plugin.getThingManager()::parse).filter(Objects::nonNull).collect(Collectors.toList());
        arenaClass.setArmor(things);
    }

    private void loadClassArmorPiece(ConfigurationSection section, String slot, Consumer<Thing> setter) {
        String value = section.getString(slot, null);
        if (value == null) {
            return;
        }
        Thing thing = this.plugin.getThingManager().parse(slot + ":" + value);
        if (thing == null) {
            return;
        }
        setter.accept(thing);
    }

    private void loadClassPermissions(ArenaClass arenaClass, ConfigurationSection section) {
        List perms = section.getStringList("permissions");
        if (perms.isEmpty()) {
            return;
        }
        for (String perm : perms) {
            boolean value = true;
            if (perm.startsWith("-") || perm.startsWith("^")) {
                perm = perm.substring(1).trim();
                value = false;
            }
            arenaClass.addPermission(perm, value);
        }
    }

    private void loadClassLobbyPermissions(ArenaClass arenaClass, ConfigurationSection section) {
        List perms = section.getStringList("lobby-permissions");
        if (perms.isEmpty()) {
            return;
        }
        for (String perm : perms) {
            boolean value = true;
            if (perm.startsWith("-") || perm.startsWith("^")) {
                perm = perm.substring(1).trim();
                value = false;
            }
            arenaClass.addLobbyPermission(perm, value);
        }
    }

    @Override
    public ArenaClass createClassNode(String classname, PlayerInventory inv, boolean safe) {
        ItemStack offhand;
        String path = "classes." + classname;
        if (safe && this.config.getConfigurationSection(path) != null) {
            return null;
        }
        this.config.set(path, (Object)"");
        ConfigurationSection section = this.config.getConfigurationSection(path);
        if (section == null) {
            section = this.config.createSection(path);
        }
        section.set("items", (Object)ItemParser.parseString(inv.getContents()));
        section.set("armor", (Object)ItemParser.parseString(inv.getArmorContents()));
        ItemStack helmet = inv.getHelmet();
        if (helmet != null && ArenaClass.ArmorType.getType(helmet) != ArenaClass.ArmorType.HELMET) {
            section.set("helmet", (Object)ItemParser.parseString(helmet));
        }
        if ((offhand = inv.getItemInOffHand()) != null) {
            section.set("offhand", (Object)ItemParser.parseString(offhand));
        }
        this.plugin.saveConfig();
        return this.loadClass(classname);
    }

    @Override
    public void removeClassNode(String classname) {
        String lowercase = classname.toLowerCase();
        if (!this.classes.containsKey(lowercase)) {
            throw new IllegalArgumentException("Class does not exist!");
        }
        this.config.set("classes." + classname, null);
        this.plugin.saveConfig();
        this.classes.remove(lowercase);
    }

    @Override
    public boolean addClassPermission(String classname, String perm) {
        return this.addRemoveClassPermission(classname, perm, true);
    }

    @Override
    public boolean removeClassPermission(String classname, String perm) {
        return this.addRemoveClassPermission(classname, perm, false);
    }

    private boolean addRemoveClassPermission(String classname, String perm, boolean add) {
        classname = TextUtils.camelCase(classname);
        String path = "classes." + classname;
        if (this.config.getConfigurationSection(path) == null) {
            return false;
        }
        ConfigurationSection section = this.config.getConfigurationSection(path);
        List nodes = section.getStringList("permissions");
        if (nodes.contains(perm) && add) {
            return false;
        }
        if (nodes.contains(perm) && !add) {
            nodes.remove(perm);
        } else if (!nodes.contains(perm) && add) {
            this.removeContradictions(nodes, perm);
            nodes.add(perm);
        } else if (!nodes.contains(perm) && !add) {
            return false;
        }
        section.set("permissions", (Object)nodes);
        this.plugin.saveConfig();
        this.loadClass(classname);
        return true;
    }

    private void removeContradictions(List<String> nodes, String perm) {
        if (perm.startsWith("^") || perm.startsWith("-")) {
            nodes.remove(perm.substring(1).trim());
        } else {
            nodes.remove("^" + perm);
            nodes.remove("-" + perm);
        }
    }

    @Override
    public void loadArenas() {
        ConfigurationSection section = ConfigUtils.makeSection((ConfigurationSection)this.config, "arenas");
        Set arenanames = section.getKeys(false);
        if (arenanames == null || arenanames.isEmpty()) {
            this.createArenaNode(section, "default", (World)this.plugin.getServer().getWorlds().get(0), false);
        }
        this.arenas = new ArrayList<Arena>();
        for (World w : Bukkit.getServer().getWorlds()) {
            this.loadArenasInWorld(w.getName());
        }
    }

    @Override
    public void loadArenasInWorld(String worldName) {
        Set arenaNames = this.config.getConfigurationSection("arenas").getKeys(false);
        if (arenaNames == null || arenaNames.isEmpty()) {
            return;
        }
        for (String arenaName : arenaNames) {
            String arenaWorld;
            Arena arena = this.getArenaWithName(arenaName);
            if (arena != null || !(arenaWorld = this.config.getString("arenas." + arenaName + ".settings.world", "")).equals(worldName)) continue;
            this.loadArena(arenaName);
        }
    }

    @Override
    public void unloadArenasInWorld(String worldName) {
        Set arenaNames = this.config.getConfigurationSection("arenas").getKeys(false);
        if (arenaNames == null || arenaNames.isEmpty()) {
            return;
        }
        for (String arenaName : arenaNames) {
            String arenaWorld;
            Arena arena = this.getArenaWithName(arenaName);
            if (arena == null || !(arenaWorld = arena.getWorld().getName()).equals(worldName)) continue;
            arena.forceEnd();
            this.arenas.remove(arena);
        }
    }

    private Arena loadArena(String arenaname) {
        World world;
        ConfigurationSection section = ConfigUtils.makeSection((ConfigurationSection)this.config, "arenas." + arenaname);
        ConfigurationSection settings = ConfigUtils.makeSection(section, "settings");
        String worldName = settings.getString("world", "");
        if (!worldName.equals("")) {
            world = this.plugin.getServer().getWorld(worldName);
            if (world == null) {
                this.plugin.getLogger().warning("World '" + worldName + "' for arena '" + arenaname + "' was not found...");
                return null;
            }
        } else {
            world = (World)this.plugin.getServer().getWorlds().get(0);
            this.plugin.getLogger().warning("Could not find the world for arena '" + arenaname + "'. Using default world ('" + world.getName() + "')! Check the config-file!");
        }
        ConfigUtils.addMissingRemoveObsolete((Plugin)this.plugin, "settings.yml", settings);
        ConfigUtils.addIfEmpty((Plugin)this.plugin, "waves.yml", ConfigUtils.makeSection(section, "waves"));
        ArenaImpl arena = new ArenaImpl(this.plugin, section, arenaname, world);
        this.arenas.add(arena);
        this.plugin.getLogger().info("Loaded arena '" + arenaname + "'");
        return arena;
    }

    @Override
    public boolean reloadArena(String name) {
        Arena arena = this.getArenaWithName(name);
        if (arena == null) {
            return false;
        }
        arena.forceEnd();
        this.arenas.remove(arena);
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
        this.loadArena(name);
        return true;
    }

    @Override
    public Arena createArenaNode(String arenaName, World world) {
        ConfigurationSection section = ConfigUtils.makeSection((ConfigurationSection)this.config, "arenas");
        return this.createArenaNode(section, arenaName, world, true);
    }

    private Arena createArenaNode(ConfigurationSection arenas, String arenaName, World world, boolean load) {
        if (arenas.contains(arenaName)) {
            throw new IllegalArgumentException("Arena already exists!");
        }
        ConfigurationSection section = ConfigUtils.makeSection(arenas, arenaName);
        ConfigUtils.addMissingRemoveObsolete((Plugin)this.plugin, "settings.yml", ConfigUtils.makeSection(section, "settings"));
        section.set("settings.world", (Object)world.getName());
        ConfigUtils.addIfEmpty((Plugin)this.plugin, "waves.yml", ConfigUtils.makeSection(section, "waves"));
        ConfigUtils.addIfEmpty((Plugin)this.plugin, "rewards.yml", ConfigUtils.makeSection(section, "rewards"));
        this.plugin.saveConfig();
        return load ? this.loadArena(arenaName) : null;
    }

    @Override
    public void removeArenaNode(Arena arena) {
        this.arenas.remove(arena);
        this.config.set("arenas." + arena.configName(), null);
        this.plugin.saveConfig();
    }

    @Override
    public void reloadConfig() {
        boolean wasEnabled = this.isEnabled();
        if (wasEnabled) {
            this.setEnabled(false);
        }
        for (Arena a : this.arenas) {
            a.forceEnd();
        }
        this.plugin.reloadConfig();
        this.config = this.plugin.getConfig();
        this.initialize();
        if (wasEnabled) {
            this.setEnabled(true);
        }
    }

    @Override
    public void saveConfig() {
        this.plugin.saveConfig();
    }
}

