/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena;

import com.garbagemule.MobArena.ArenaPlayer;
import com.garbagemule.MobArena.MobArena;
import com.garbagemule.MobArena.framework.Arena;
import com.garbagemule.MobArena.util.MutableInt;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.Player;

public class ArenaPlayerStatistics {
    private ArenaPlayer player;
    private String playerName;
    private String className;
    private Map<String, MutableInt> ints;

    public ArenaPlayerStatistics(ArenaPlayer player) {
        this.player = player;
        this.playerName = player.getPlayer().getName();
        this.className = player.getArenaClass().getLowercaseName();
        this.reset();
    }

    public void reset() {
        if (this.ints == null) {
            this.ints = new HashMap<String, MutableInt>();
        }
        this.ints.clear();
        this.ints.put("kills", new MutableInt());
        this.ints.put("dmgDone", new MutableInt());
        this.ints.put("dmgTaken", new MutableInt());
        this.ints.put("swings", new MutableInt());
        this.ints.put("hits", new MutableInt());
        this.ints.put("lastWave", new MutableInt());
    }

    public ArenaPlayerStatistics(Player p, Arena arena, MobArena plugin) {
        this(new ArenaPlayer(p, arena, plugin));
    }

    public ArenaPlayer getArenaPlayer() {
        return this.player;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public String getClassName() {
        return this.className;
    }

    public int getInt(String s) {
        return this.ints.get(s).value();
    }

    public void inc(String s) {
        this.ints.get(s).inc();
    }

    public void add(String s, double amount) {
        this.ints.get(s).add(amount);
    }

    public static Comparator<ArenaPlayerStatistics> killComparator() {
        return new Comparator<ArenaPlayerStatistics>(){

            @Override
            public int compare(ArenaPlayerStatistics s1, ArenaPlayerStatistics s2) {
                int s2kills;
                int s1kills = s1.getInt("kills");
                if (s1kills == (s2kills = s2.getInt("kills"))) {
                    return 0;
                }
                return s1kills > s2kills ? -1 : 1;
            }
        };
    }

    public static Comparator<ArenaPlayerStatistics> waveComparator() {
        return new Comparator<ArenaPlayerStatistics>(){

            @Override
            public int compare(ArenaPlayerStatistics s1, ArenaPlayerStatistics s2) {
                int result = ArenaPlayerStatistics.compareWaves(s1, s2);
                if (result != 0) {
                    return result;
                }
                return ArenaPlayerStatistics.compareKills(s1, s2);
            }
        };
    }

    public static Comparator<ArenaPlayerStatistics> dmgDoneComparator() {
        return new Comparator<ArenaPlayerStatistics>(){

            @Override
            public int compare(ArenaPlayerStatistics s1, ArenaPlayerStatistics s2) {
                int s2dmgDone;
                int s1dmgDone = s1.getInt("dmgDone");
                if (s1dmgDone == (s2dmgDone = s2.getInt("dmgDone"))) {
                    return 0;
                }
                return s1dmgDone > s2dmgDone ? -1 : 1;
            }
        };
    }

    private static int compareKills(ArenaPlayerStatistics s1, ArenaPlayerStatistics s2) {
        int s2kills;
        int s1kills = s1.getInt("kills");
        if (s1kills == (s2kills = s2.getInt("kills"))) {
            return 0;
        }
        return s1kills > s2kills ? -1 : 1;
    }

    private static int compareWaves(ArenaPlayerStatistics s1, ArenaPlayerStatistics s2) {
        int s2wave;
        int s1wave = s1.getInt("lastWave");
        if (s1wave == (s2wave = s2.getInt("lastWave"))) {
            return 0;
        }
        return s1wave > s2wave ? -1 : 1;
    }
}

