/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena;

import com.garbagemule.MobArena.MobArena;
import com.garbagemule.MobArena.Msg;
import com.garbagemule.MobArena.framework.Arena;
import com.garbagemule.MobArena.framework.ArenaMaster;
import com.garbagemule.MobArena.region.ArenaRegion;
import com.garbagemule.MobArena.things.Thing;
import com.garbagemule.MobArena.util.EntityPosition;
import com.garbagemule.MobArena.util.TextUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Sign;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Player;
import org.bukkit.entity.Wolf;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;

public class MAUtils {
    public static final String sep = File.separator;

    public static Map<Integer, List<Thing>> getArenaRewardMap(MobArena plugin, ConfigurationSection config, String arena, String type) {
        HashMap<Integer, List<Thing>> result = new HashMap<Integer, List<Thing>>();
        String typePath = "rewards.waves." + type;
        if (!config.contains(typePath)) {
            return result;
        }
        Set waves = config.getConfigurationSection(typePath).getKeys(false);
        if (waves == null) {
            return result;
        }
        for (String n : waves) {
            if (!n.matches("[0-9]+")) continue;
            int wave = Integer.parseInt(n);
            String path = typePath + "." + wave;
            String rewards = config.getString(path);
            ArrayList<Thing> things = new ArrayList<Thing>();
            for (String reward : rewards.split(",")) {
                try {
                    Thing thing = plugin.getThingManager().parse(reward.trim());
                    if (thing == null) {
                        plugin.getLogger().warning("Failed to parse reward: " + reward.trim());
                        continue;
                    }
                    things.add(thing);
                }
                catch (Exception e) {
                    plugin.getLogger().severe("Exception parsing reward '" + reward.trim() + "': " + e.getLocalizedMessage());
                }
            }
            result.put(wave, things);
        }
        return result;
    }

    public static void sitPets(Player p) {
        if (p == null) {
            return;
        }
        List entities = p.getNearbyEntities(80.0, 40.0, 80.0);
        for (Entity e : entities) {
            Ocelot o;
            if (e instanceof Wolf) {
                Wolf w = (Wolf)e;
                if (!w.isTamed() || w.getOwner() == null || !w.getOwner().equals(p)) continue;
                w.setSitting(true);
                continue;
            }
            if (!(e instanceof Ocelot) || !(o = (Ocelot)e).isTamed() || o.getOwner() == null || !o.getOwner().equals(p)) continue;
            o.setSitting(true);
        }
    }

    public static Player getClosestPlayer(MobArena plugin, Entity e, Arena arena) {
        double current = Double.POSITIVE_INFINITY;
        Player result = null;
        ArrayList<Player> players = new ArrayList<Player>(arena.getPlayersInArena());
        for (Player p : players) {
            if (!arena.getWorld().equals(p.getWorld())) {
                plugin.getLogger().info("Player '" + p.getName() + "' is not in the right world. Kicking...");
                p.kickPlayer("[MobArena] Cheater! (Warped out of the arena world.)");
                arena.getMessenger().tell((CommandSender)p, "You warped out of the arena world.");
                continue;
            }
            double dist = MAUtils.distanceSquared(plugin, p, e.getLocation());
            if (!(dist < current) || !(dist < 256.0)) continue;
            current = dist;
            result = p;
        }
        return result;
    }

    public static double distanceSquared(MobArena plugin, Player p, Location l) {
        try {
            return p.getLocation().distanceSquared(l);
        }
        catch (Exception e) {
            p.kickPlayer("Banned for life! No, but stop trying to cheat in MobArena!");
            if (plugin != null) {
                plugin.getLogger().warning(p.getName() + " tried to cheat in MobArena and has been kicked.");
            }
            return Double.MAX_VALUE;
        }
    }

    public static String nameConfigToArena(String name) {
        String[] parts = name.split("_");
        if (parts.length == 1) {
            return MAUtils.toCamelCase(parts[0]);
        }
        String separator = " ";
        StringBuffer buffy = new StringBuffer(name.length());
        for (String part : parts) {
            buffy.append(MAUtils.toCamelCase(part));
            buffy.append(separator);
        }
        buffy.replace(buffy.length() - 1, buffy.length(), "");
        return buffy.toString();
    }

    public static String toCamelCase(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1).toLowerCase();
    }

    public static <E> String listToString(Collection<E> list, boolean none, MobArena plugin) {
        if (list == null || list.isEmpty()) {
            return none ? Msg.MISC_NONE.toString() : "";
        }
        StringBuffer buffy = new StringBuffer();
        int trimLength = 0;
        E type = list.iterator().next();
        if (type instanceof Player) {
            for (E e : list) {
                buffy.append(((Player)e).getName());
                buffy.append(" ");
            }
        } else if (type instanceof ItemStack) {
            trimLength = 2;
            for (E e : list) {
                ItemStack stack = (ItemStack)e;
                buffy.append(stack.getType().toString().toLowerCase());
                buffy.append(":");
                buffy.append(stack.getAmount());
                buffy.append(", ");
            }
        } else {
            for (E e : list) {
                buffy.append(e.toString());
                buffy.append(" ");
            }
        }
        return buffy.toString().substring(0, buffy.length() - trimLength);
    }

    public static <E> String listToString(Collection<E> list, JavaPlugin plugin) {
        return MAUtils.listToString(list, true, (MobArena)plugin);
    }

    public static List<String> stringToList(String list) {
        String[] parts;
        LinkedList<String> result = new LinkedList<String>();
        if (list == null) {
            return result;
        }
        for (String part : parts = list.trim().split(",")) {
            result.add(part.trim());
        }
        return result;
    }

    public static boolean doooooItHippieMonster(Location loc, int radius, String name, MobArena plugin) {
        int k;
        int i;
        int k2;
        MAUtils.undoItHippieMonster(name, plugin, false);
        ArenaMaster am = plugin.getArenaMaster();
        World world = loc.getWorld();
        Arena arena = am.createArenaNode(name, world);
        int x1 = (int)loc.getX() - radius;
        int x2 = (int)loc.getX() + radius;
        int y1 = (int)loc.getY() - 9;
        int y2 = (int)loc.getY() - 1;
        int z1 = (int)loc.getZ() - radius;
        int z2 = (int)loc.getZ() + radius;
        int lx1 = x1;
        int lx2 = x1 + am.getClasses().size() + 3;
        int ly1 = y1 - 6;
        int ly2 = y1 - 2;
        int lz1 = z1;
        int lz2 = z1 + 6;
        HashMap<EntityPosition, Integer> preciousPatch = new HashMap<EntityPosition, Integer>();
        for (int i2 = x1; i2 <= x2; ++i2) {
            for (int j = ly1; j <= y2; ++j) {
                for (k2 = z1; k2 <= z2; ++k2) {
                    Location lo = world.getBlockAt(i2, j, k2).getLocation();
                    int id = world.getBlockAt(i2, j, k2).getTypeId();
                    preciousPatch.put(new EntityPosition(lo), id);
                }
            }
        }
        try {
            new File("plugins" + sep + "MobArena" + sep + "agbackup").mkdir();
            FileOutputStream fos = new FileOutputStream("plugins" + sep + "MobArena" + sep + "agbackup" + sep + name + ".tmp");
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(preciousPatch);
            oos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            plugin.getLogger().warning("Couldn't create backup file. Aborting auto-generate...");
            return false;
        }
        for (i = x1; i <= x2; ++i) {
            for (int j = y1; j <= y2; ++j) {
                world.getBlockAt(i, j, z1).setType(Material.SANDSTONE);
                world.getBlockAt(i, j, z2).setType(Material.SANDSTONE);
            }
        }
        for (k = z1; k <= z2; ++k) {
            for (int j = y1; j <= y2; ++j) {
                world.getBlockAt(x1, j, k).setType(Material.SANDSTONE);
                world.getBlockAt(x2, j, k).setType(Material.SANDSTONE);
            }
        }
        for (i = x1; i <= x2; ++i) {
            world.getBlockAt(i, y1 + 2, z1).setType(Material.GLOWSTONE);
            world.getBlockAt(i, y1 + 2, z2).setType(Material.GLOWSTONE);
        }
        for (k = z1; k <= z2; ++k) {
            world.getBlockAt(x1, y1 + 2, k).setType(Material.GLOWSTONE);
            world.getBlockAt(x2, y1 + 2, k).setType(Material.GLOWSTONE);
        }
        for (i = x1; i <= x2; ++i) {
            for (int k3 = z1; k3 <= z2; ++k3) {
                world.getBlockAt(i, y1, k3).setType(Material.SANDSTONE);
                world.getBlockAt(i, y1 - 1, k3).setType(Material.OBSIDIAN);
            }
        }
        for (i = x1; i <= x2; ++i) {
            for (int k4 = z1; k4 <= z2; ++k4) {
                world.getBlockAt(i, y2, k4).setType(Material.GLASS);
            }
        }
        for (i = x1 + 1; i < x2; ++i) {
            for (int j = y1 + 1; j < y2; ++j) {
                for (k2 = z1 + 1; k2 < z2; ++k2) {
                    world.getBlockAt(i, j, k2).setType(Material.AIR);
                }
            }
        }
        for (i = lx1; i <= lx2; ++i) {
            for (int j = ly1; j <= ly2; ++j) {
                world.getBlockAt(i, j, lz1).setType(Material.SANDSTONE);
                world.getBlockAt(i, j, lz2).setType(Material.SANDSTONE);
            }
        }
        for (k = lz1; k <= lz2; ++k) {
            for (int j = ly1; j <= ly2; ++j) {
                world.getBlockAt(lx1, j, k).setType(Material.SANDSTONE);
                world.getBlockAt(lx2, j, k).setType(Material.SANDSTONE);
            }
        }
        for (k = lz1; k <= lz2; ++k) {
            world.getBlockAt(lx1, ly1 + 2, k).setType(Material.GLOWSTONE);
            world.getBlockAt(lx2, ly1 + 2, k).setType(Material.GLOWSTONE);
            world.getBlockAt(lx1, ly1 + 3, k).setType(Material.GLOWSTONE);
            world.getBlockAt(lx2, ly1 + 3, k).setType(Material.GLOWSTONE);
        }
        for (i = lx1; i <= lx2; ++i) {
            for (int k5 = lz1; k5 <= lz2; ++k5) {
                world.getBlockAt(i, ly1, k5).setType(Material.SANDSTONE);
            }
        }
        for (i = x1 + 1; i < lx2; ++i) {
            for (int j = ly1 + 1; j <= ly2; ++j) {
                for (k2 = lz1 + 1; k2 < lz2; ++k2) {
                    world.getBlockAt(i, j, k2).setType(Material.AIR);
                }
            }
        }
        Iterator<String> iterator = am.getClasses().keySet().iterator();
        for (int i3 = lx1 + 2; i3 <= lx2 - 2; ++i3) {
            world.getBlockAt(i3, ly1 + 1, lz2 - 1).setTypeIdAndData(63, (byte)8, false);
            Sign sign = (Sign)world.getBlockAt(i3, ly1 + 1, lz2 - 1).getState();
            sign.setLine(0, TextUtils.camelCase(iterator.next()));
            sign.update();
        }
        world.getBlockAt(lx2 - 2, ly1 + 1, lz1 + 2).setType(Material.IRON_BLOCK);
        ArenaRegion region = arena.getRegion();
        region.set("p1", new Location(world, (double)x1, (double)ly1, (double)z1));
        region.set("p2", new Location(world, (double)x2, (double)(y2 + 1), (double)z2));
        region.set("arena", new Location(world, loc.getX(), (double)(y1 + 1), loc.getZ()));
        region.set("lobby", new Location(world, (double)(x1 + 2), (double)(ly1 + 1), (double)(z1 + 2)));
        region.set("spectator", new Location(world, loc.getX(), (double)(y2 + 1), loc.getZ()));
        region.addSpawn("s1", new Location(world, (double)(x1 + 3), (double)(y1 + 2), (double)(z1 + 3)));
        region.addSpawn("s2", new Location(world, (double)(x1 + 3), (double)(y1 + 2), (double)(z2 - 3)));
        region.addSpawn("s3", new Location(world, (double)(x2 - 3), (double)(y1 + 2), (double)(z1 + 3)));
        region.addSpawn("s4", new Location(world, (double)(x2 - 3), (double)(y1 + 2), (double)(z2 - 3)));
        region.save();
        am.reloadConfig();
        return true;
    }

    public static boolean undoItHippieMonster(String name, MobArena plugin, boolean error) {
        HashMap preciousPatch;
        File file = new File("plugins" + sep + "MobArena" + sep + "agbackup" + sep + name + ".tmp");
        try {
            FileInputStream fis = new FileInputStream(file);
            ObjectInputStream ois = new ObjectInputStream(fis);
            preciousPatch = (HashMap)ois.readObject();
            ois.close();
        }
        catch (Exception e) {
            if (error) {
                plugin.getLogger().warning("Couldn't find backup file for arena '" + name + "'");
            }
            return false;
        }
        World world = plugin.getServer().getWorld(((EntityPosition)preciousPatch.keySet().iterator().next()).getWorld());
        for (Map.Entry entry : preciousPatch.entrySet()) {
            world.getBlockAt(((EntityPosition)entry.getKey()).getLocation(world)).setTypeId(((Integer)entry.getValue()).intValue());
        }
        plugin.getConfig().set("arenas." + name, null);
        plugin.saveConfig();
        file.delete();
        plugin.getArenaMaster().reloadConfig();
        return true;
    }
}

