/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena;

import com.garbagemule.MobArena.ArenaMasterImpl;
import com.garbagemule.MobArena.Messenger;
import com.garbagemule.MobArena.Msg;
import com.garbagemule.MobArena.commands.CommandHandler;
import com.garbagemule.MobArena.framework.Arena;
import com.garbagemule.MobArena.framework.ArenaMaster;
import com.garbagemule.MobArena.listeners.MAGlobalListener;
import com.garbagemule.MobArena.listeners.MagicSpellsListener;
import com.garbagemule.MobArena.metrics.ArenaCountChart;
import com.garbagemule.MobArena.metrics.ClassCountChart;
import com.garbagemule.MobArena.metrics.VaultChart;
import com.garbagemule.MobArena.metrics.bukkit.Metrics;
import com.garbagemule.MobArena.things.ThingManager;
import com.garbagemule.MobArena.util.VersionChecker;
import com.garbagemule.MobArena.util.config.ConfigUtils;
import com.garbagemule.MobArena.waves.ability.AbilityManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Random;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.ServicesManager;
import org.bukkit.plugin.java.JavaPlugin;

public class MobArena
extends JavaPlugin {
    private ArenaMaster arenaMaster;
    private CommandHandler commandHandler;
    private Economy economy;
    private File configFile;
    private FileConfiguration config;
    public static final double MIN_PLAYER_DISTANCE_SQUARED = 225.0;
    public static Random random = new Random();
    private Messenger messenger;
    private ThingManager thingman;

    public void onLoad() {
        this.thingman = new ThingManager(this);
    }

    public void onEnable() {
        this.configFile = new File(this.getDataFolder(), "config.yml");
        this.config = new YamlConfiguration();
        this.reloadConfig();
        String prefix = this.config.getString("global-settings.prefix", "");
        if (prefix.isEmpty()) {
            prefix = ChatColor.GREEN + "[MobArena] ";
        }
        this.messenger = new Messenger(prefix);
        this.getConfig().options().header(this.getHeader());
        this.saveConfig();
        this.loadAnnouncementsFile();
        this.loadAbilities();
        this.setupVault();
        this.setupMagicSpells();
        this.arenaMaster = new ArenaMasterImpl(this);
        this.arenaMaster.initialize();
        this.registerListeners();
        this.setupMetrics();
        this.getLogger().info("v" + this.getDescription().getVersion() + " enabled.");
        if (this.getConfig().getBoolean("global-settings.update-notification", false)) {
            VersionChecker.checkForUpdates(this, null);
        }
    }

    public void onDisable() {
        if (this.arenaMaster == null) {
            return;
        }
        for (Arena arena : this.arenaMaster.getArenas()) {
            arena.forceEnd();
        }
        this.arenaMaster.resetArenaMap();
        VersionChecker.shutdown();
        this.getLogger().info("disabled.");
    }

    public File getPluginFile() {
        return this.getFile();
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public void reloadConfig() {
        if (!this.configFile.exists()) {
            this.getLogger().info("No config-file found, creating default...");
            this.saveDefaultConfig();
        }
        try {
            Path path = this.getDataFolder().toPath().resolve("config.yml");
            List<String> lines = Files.readAllLines(path);
            for (int i = 0; i < lines.size(); ++i) {
                String line = lines.get(i);
                int index = line.indexOf(9);
                if (index == -1) continue;
                String indent = new String(new char[index]).replace('\u0000', ' ');
                throw new IllegalArgumentException("Found tab in config-file on line " + (i + 1) + "! NEVER use tabs! ALWAYS use spaces!\n\n" + line + "\n" + indent + "^");
            }
        }
        catch (IOException e) {
            throw new RuntimeException("There was an error reading the config-file:\n" + e.getMessage());
        }
        try {
            this.config.load(this.configFile);
        }
        catch (IOException e) {
            throw new RuntimeException("There was an error reading the config-file:\n" + e.getMessage());
        }
        catch (InvalidConfigurationException e) {
            throw new RuntimeException("\n\n>>>\n>>> There is an error in your config-file! Handle it!\n>>> Here is what snakeyaml says:\n>>>\n\n" + e.getMessage());
        }
    }

    public void saveConfig() {
        try {
            this.config.save(this.configFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadAnnouncementsFile() {
        File file = new File(this.getDataFolder(), "announcements.yml");
        try {
            if (file.createNewFile()) {
                this.getLogger().info("announcements.yml created.");
                YamlConfiguration yaml = Msg.toYaml();
                yaml.save(file);
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            YamlConfiguration yaml = new YamlConfiguration();
            yaml.load(file);
            ConfigUtils.addMissingRemoveObsolete(file, Msg.toYaml(), (FileConfiguration)yaml);
            Msg.load((ConfigurationSection)yaml);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void registerListeners() {
        this.commandHandler = new CommandHandler(this);
        this.getCommand("ma").setExecutor((CommandExecutor)this.commandHandler);
        this.getCommand("mobarena").setExecutor((CommandExecutor)this.commandHandler);
        PluginManager pm = this.getServer().getPluginManager();
        pm.registerEvents((Listener)new MAGlobalListener(this, this.arenaMaster), (Plugin)this);
    }

    private void setupVault() {
        Plugin vaultPlugin = this.getServer().getPluginManager().getPlugin("Vault");
        if (vaultPlugin == null) {
            this.getLogger().info("Vault was not found. Economy rewards will not work.");
            return;
        }
        ServicesManager manager = this.getServer().getServicesManager();
        RegisteredServiceProvider e = manager.getRegistration(Economy.class);
        if (e != null) {
            this.economy = (Economy)e.getProvider();
            this.getLogger().info("Vault found; economy rewards enabled.");
        } else {
            this.getLogger().warning("Vault found, but no economy plugin detected. Economy rewards will not work!");
        }
    }

    private void setupMagicSpells() {
        Plugin spells = this.getServer().getPluginManager().getPlugin("MagicSpells");
        if (spells == null) {
            return;
        }
        this.getLogger().info("MagicSpells found, loading config-file.");
        this.getServer().getPluginManager().registerEvents((Listener)new MagicSpellsListener(this), (Plugin)this);
    }

    private void setupMetrics() {
        Metrics metrics = new Metrics(this);
        metrics.addCustomChart(new VaultChart(this));
        metrics.addCustomChart(new ArenaCountChart(this));
        metrics.addCustomChart(new ClassCountChart(this));
    }

    private void loadAbilities() {
        File dir = new File(this.getDataFolder(), "abilities");
        if (!dir.exists()) {
            dir.mkdir();
        }
        AbilityManager.loadCoreAbilities();
        AbilityManager.loadCustomAbilities(dir);
    }

    public ArenaMaster getArenaMaster() {
        return this.arenaMaster;
    }

    public CommandHandler getCommandHandler() {
        return this.commandHandler;
    }

    private String getHeader() {
        String sep = System.getProperty("line.separator");
        return "MobArena v" + this.getDescription().getVersion() + " - Config-file" + sep + "Read the Wiki for details on how to set up this file: http://goo.gl/F5TTc" + sep + "Note: You -must- use spaces instead of tabs!";
    }

    public Economy getEconomy() {
        return this.economy;
    }

    public Messenger getGlobalMessenger() {
        return this.messenger;
    }

    public ThingManager getThingManager() {
        return this.thingman;
    }
}

