/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena;

import com.garbagemule.MobArena.framework.Arena;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Score;
import org.bukkit.scoreboard.Scoreboard;

public class ScoreboardManager {
    private static final String DISPLAY_NAME = ChatColor.GREEN + "Kills       " + ChatColor.AQUA + "Wave ";
    private Arena arena;
    private Scoreboard scoreboard;
    private Objective kills;

    ScoreboardManager(Arena arena) {
        this.arena = arena;
        this.scoreboard = Bukkit.getScoreboardManager().getNewScoreboard();
    }

    void addPlayer(Player player) {
        player.setScoreboard(this.scoreboard);
        this.kills.getScore((OfflinePlayer)player).setScore(8);
    }

    void removePlayer(Player player) {
        try {
            player.setScoreboard(Bukkit.getScoreboardManager().getMainScoreboard());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    void addKill(Player player) {
        Score score = this.kills.getScore((OfflinePlayer)player);
        score.setScore(score.getScore() + 1);
    }

    void death(Player player) {
        Score score;
        if (this.kills == null) {
            return;
        }
        String name = ChatColor.GRAY + player.getName();
        if (name.length() > 16) {
            name = name.substring(0, 15);
        }
        if ((score = this.kills.getScore((OfflinePlayer)player)) == null) {
            return;
        }
        int value = score.getScore();
        this.scoreboard.resetScores((OfflinePlayer)player);
        final Score fake = this.kills.getScore(Bukkit.getOfflinePlayer((String)name));
        if (value == 0) {
            fake.setScore(8);
            this.arena.scheduleTask(new Runnable(){

                @Override
                public void run() {
                    fake.setScore(0);
                }
            }, 1);
        } else {
            fake.setScore(value);
        }
    }

    void updateWave(int wave) {
        this.kills.setDisplayName(DISPLAY_NAME + wave);
    }

    void initialize() {
        this.resetKills();
        this.arena.scheduleTask(new Runnable(){

            @Override
            public void run() {
                for (Player p : ScoreboardManager.this.arena.getPlayersInArena()) {
                    ScoreboardManager.this.kills.getScore((OfflinePlayer)p).setScore(0);
                }
            }
        }, 1);
    }

    private void resetKills() {
        if (this.kills != null) {
            this.kills.unregister();
        }
        this.kills = this.scoreboard.registerNewObjective("kills", "ma-kills");
        this.kills.setDisplaySlot(DisplaySlot.SIDEBAR);
        this.updateWave(0);
    }

    static class NullScoreboardManager
    extends ScoreboardManager {
        NullScoreboardManager(Arena arena) {
            super(arena);
        }

        @Override
        void addPlayer(Player player) {
        }

        @Override
        void removePlayer(Player player) {
        }

        @Override
        void addKill(Player player) {
        }

        @Override
        void death(Player player) {
        }

        @Override
        void updateWave(int wave) {
        }

        @Override
        void initialize() {
        }
    }
}

