/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.commands.user;

import com.garbagemule.MobArena.Msg;
import com.garbagemule.MobArena.commands.Command;
import com.garbagemule.MobArena.commands.CommandInfo;
import com.garbagemule.MobArena.commands.Commands;
import com.garbagemule.MobArena.framework.Arena;
import com.garbagemule.MobArena.framework.ArenaMaster;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@CommandInfo(name="join", pattern="j|jo.*|j.*n", usage="/ma join (<arena>)", desc="join an arena", permission="mobarena.use.join")
public class JoinCommand
implements Command {
    @Override
    public boolean execute(ArenaMaster am, CommandSender sender, String ... args) {
        String arg1;
        if (!Commands.isPlayer(sender)) {
            am.getGlobalMessenger().tell(sender, Msg.MISC_NOT_FROM_CONSOLE);
            return true;
        }
        Player p = Commands.unwrap(sender);
        Arena toArena = Commands.getArenaToJoinOrSpec(am, p, arg1 = args.length > 0 ? args[0] : null);
        if (toArena == null) {
            return true;
        }
        Arena fromArena = am.getArenaWithPlayer(p);
        if (fromArena != null && (fromArena.inArena(p) || fromArena.inLobby(p))) {
            fromArena.getMessenger().tell((CommandSender)p, Msg.JOIN_ALREADY_PLAYING);
            return true;
        }
        if (!toArena.canJoin(p)) {
            return true;
        }
        if (fromArena != null) {
            fromArena.playerLeave(p);
        }
        return toArena.playerJoin(p, p.getLocation());
    }
}

