/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.region;

import com.garbagemule.MobArena.framework.Arena;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;

public class RegionSerializer {
    private int x1;
    private int y1;
    private int z1;
    private int x2;
    private int y2;
    private int z2;
    private long width;
    private long height;
    private long length;
    private int[][][] blocks;
    private byte[][][] data;

    public RegionSerializer(World world, Location p1, Location p2) {
        this.x1 = p1.getBlockX();
        this.y1 = p1.getBlockY();
        this.z1 = p1.getBlockZ();
        this.x2 = p2.getBlockX();
        this.y2 = p2.getBlockY();
        this.z2 = p2.getBlockZ();
        this.width = this.x2 - this.x1 + 1;
        this.height = this.y2 - this.y1 + 1;
        this.length = this.z2 - this.z1 + 1;
        int w = (int)this.width;
        int h = (int)this.height;
        int l = (int)this.length;
        this.blocks = new int[w][h][l];
        this.data = new byte[w][h][l];
    }

    public void serialize(Arena arena) {
        Serializer s = new Serializer(arena);
        s.start();
    }

    public void deserialize(Arena arena) {
        Deserializer d = new Deserializer(arena);
        d.start();
    }

    private class Deserializer
    implements Runnable {
        private Arena arena;
        private long total;

        public Deserializer(Arena arena) {
            this.arena = arena;
        }

        public void start() {
            this.arena.setEnabled(false);
            this.total = 0L;
            this.arena.scheduleTask(this, 1);
        }

        @Override
        public void run() {
            int y = (int)(this.total / (RegionSerializer.this.width * RegionSerializer.this.length));
            int z = (int)(this.total % (RegionSerializer.this.width * RegionSerializer.this.length) / RegionSerializer.this.width);
            int x = (int)(this.total % (RegionSerializer.this.width * RegionSerializer.this.length) % RegionSerializer.this.width);
            long max = RegionSerializer.this.width * RegionSerializer.this.height * RegionSerializer.this.length;
            int amount = (int)Math.min(20L, max - this.total);
            for (int i = 0; i < 20; ++i) {
                Block b = this.arena.getWorld().getBlockAt(x, y, z);
                b.setTypeIdAndData(RegionSerializer.this.blocks[x][y][z], RegionSerializer.this.data[x][y][z], false);
            }
            this.total += (long)amount;
            if (this.total == max) {
                this.arena.setEnabled(true);
                return;
            }
            this.arena.scheduleTask(this, 1);
        }
    }

    private class Serializer
    implements Runnable {
        private Arena arena;
        private long total;

        public Serializer(Arena arena) {
            this.arena = arena;
        }

        public void start() {
            this.arena.setEnabled(false);
            this.total = 0L;
            this.arena.scheduleTask(this, 1);
        }

        @Override
        public void run() {
            int y = (int)(this.total / (RegionSerializer.this.width * RegionSerializer.this.length));
            int z = (int)(this.total % (RegionSerializer.this.width * RegionSerializer.this.length) / RegionSerializer.this.width);
            int x = (int)(this.total % (RegionSerializer.this.width * RegionSerializer.this.length) % RegionSerializer.this.width);
            long max = RegionSerializer.this.width * RegionSerializer.this.height * RegionSerializer.this.length;
            int amount = (int)Math.min(20L, max - this.total);
            for (int i = 0; i < amount; ++i) {
                Block b = this.arena.getWorld().getBlockAt(x, y, z);
                ((RegionSerializer)RegionSerializer.this).blocks[x][y][z] = b.getTypeId();
                ((RegionSerializer)RegionSerializer.this).data[x][y][z] = b.getData();
                x = (int)((long)(x + 1) % RegionSerializer.this.width);
                y = (int)((long)(y + 1) % RegionSerializer.this.height);
                z = (int)((long)(z + 1) % RegionSerializer.this.length);
            }
            this.total += (long)amount;
            if (this.total == max) {
                this.arena.setEnabled(true);
                return;
            }
            this.arena.scheduleTask(this, 1);
        }
    }
}

