/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.steps;

import com.garbagemule.MobArena.steps.PlayerStep;
import com.garbagemule.MobArena.steps.Step;
import com.garbagemule.MobArena.steps.StepFactory;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.entity.Player;

class PlayerMultiStep
extends PlayerStep {
    private final List<StepFactory> factories;
    private final Logger logger;
    private Deque<Step> history;

    private PlayerMultiStep(Player player, List<StepFactory> factories, Logger logger) {
        super(player);
        this.factories = factories;
        this.logger = logger;
        this.history = new ArrayDeque<Step>();
    }

    @Override
    public void run() {
        this.history.clear();
        this.factories.forEach(factory -> {
            Step step = factory.create(this.player);
            try {
                step.run();
                this.history.push(step);
            }
            catch (RuntimeException up) {
                this.logger.log(Level.SEVERE, up, () -> "Failed to run step " + step);
                this.undo();
                throw up;
            }
        });
    }

    @Override
    public void undo() {
        while (!this.history.isEmpty()) {
            Step step = this.history.pop();
            try {
                step.undo();
            }
            catch (RuntimeException e) {
                this.logger.log(Level.SEVERE, e, () -> "Failed to undo step " + step);
            }
        }
    }

    static StepFactory create(List<StepFactory> factories, Logger logger) {
        return player -> new PlayerMultiStep(player, factories, logger);
    }
}

