/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.steps;

import com.garbagemule.MobArena.steps.PlayerStep;
import com.garbagemule.MobArena.steps.StepFactory;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Player;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Wolf;

class SitPets
extends PlayerStep {
    private List<Entity> pets = Collections.emptyList();

    private SitPets(Player player) {
        super(player);
    }

    @Override
    public void run() {
        this.pets = SitPets.findNearbyPets(this.player);
        this.pets.forEach(SitPets.setSitting(true));
    }

    @Override
    public void undo() {
        this.pets.forEach(SitPets.setSitting(false));
    }

    static StepFactory create() {
        return SitPets::new;
    }

    private static List<Entity> findNearbyPets(Player player) {
        return player.getNearbyEntities(80.0, 40.0, 80.0).stream().filter(SitPets.isPetOwnedBy(player)).filter(SitPets::isFollowing).collect(Collectors.toList());
    }

    private static Predicate<Entity> isPetOwnedBy(Player player) {
        return entity -> {
            switch (entity.getType()) {
                case WOLF: 
                case OCELOT: {
                    return player.equals(((Tameable)entity).getOwner());
                }
            }
            return false;
        };
    }

    private static boolean isFollowing(Entity entity) {
        switch (entity.getType()) {
            case WOLF: {
                return !((Wolf)entity).isSitting();
            }
            case OCELOT: {
                return !((Ocelot)entity).isSitting();
            }
        }
        return false;
    }

    private static Consumer<Entity> setSitting(boolean sitting) {
        return entity -> {
            switch (entity.getType()) {
                case WOLF: {
                    ((Wolf)entity).setSitting(sitting);
                    break;
                }
                case OCELOT: {
                    ((Ocelot)entity).setSitting(sitting);
                }
            }
        };
    }
}

