/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.things;

import com.garbagemule.MobArena.things.Thing;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandThing
implements Thing {
    private final String command;
    private final String title;

    public CommandThing(String command) {
        this(command, null);
    }

    public CommandThing(String command, String title) {
        this.command = this.trimSlash(command);
        this.title = title;
    }

    @Override
    public boolean giveTo(Player player) {
        return Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), this.command.replace("<player>", player.getName()));
    }

    @Override
    public boolean takeFrom(Player player) {
        return false;
    }

    @Override
    public boolean heldBy(Player player) {
        return false;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommandThing)) {
            return false;
        }
        CommandThing other = (CommandThing)o;
        return Objects.equals(this.command, other.command) && Objects.equals(this.title, other.title);
    }

    public int hashCode() {
        return Objects.hash(this.command, this.title);
    }

    public String toString() {
        if (this.title != null) {
            return this.title;
        }
        return "/" + this.command;
    }

    private String trimSlash(String command) {
        if (command.startsWith("/")) {
            return command.substring(1);
        }
        return command;
    }
}

