/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.things;

import com.garbagemule.MobArena.things.Equippable;
import com.garbagemule.MobArena.things.ItemStackParser;
import com.garbagemule.MobArena.things.ItemStackThing;
import com.garbagemule.MobArena.things.ThingParser;
import com.garbagemule.MobArena.util.ItemParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.bukkit.inventory.ItemStack;

class ItemStackThingParser
implements ThingParser {
    private List<ItemStackParser> parsers = new ArrayList<ItemStackParser>();

    ItemStackThingParser() {
    }

    public void register(ItemStackParser parser) {
        this.parsers.add(parser);
    }

    @Override
    public ItemStackThing parse(String s) {
        String[] parts = s.split(":", 2);
        if (parts.length == 1) {
            return this.genericItem(s);
        }
        String prefix = parts[0];
        String rest = parts[1];
        if (prefix.equals("armor")) {
            return this.genericArmor(rest);
        }
        return this.specificSlot(s, prefix, rest);
    }

    private ItemStackThing genericItem(String s) {
        ItemStack stack = this.parseItemStack(s);
        if (stack == null) {
            return null;
        }
        return new ItemStackThing(stack);
    }

    private ItemStackThing genericArmor(String s) {
        ItemStack stack = this.parseItemStack(s);
        if (stack == null) {
            return null;
        }
        Equippable.Wrapper wrapper = Equippable.guessWrapperFromItemStack(stack);
        if (wrapper == null) {
            return new ItemStackThing(stack);
        }
        return wrapper.wrap(stack);
    }

    private ItemStackThing specificSlot(String s, String prefix, String rest) {
        Equippable.Wrapper wrapper = Equippable.getWrapperByPrefix(prefix);
        if (wrapper == null) {
            return this.genericItem(s);
        }
        ItemStack stack = this.parseItemStack(rest);
        if (stack == null) {
            return null;
        }
        return wrapper.wrap(stack);
    }

    private ItemStack parseItemStack(String s) {
        return this.parsers.stream().map(p -> p.parse(s)).filter(Objects::nonNull).findFirst().orElseGet(() -> ItemParser.parseItem(s, false));
    }
}

