/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.things;

import com.garbagemule.MobArena.MobArena;
import com.garbagemule.MobArena.things.CommandThingParser;
import com.garbagemule.MobArena.things.ItemStackParser;
import com.garbagemule.MobArena.things.ItemStackThingParser;
import com.garbagemule.MobArena.things.MoneyThingParser;
import com.garbagemule.MobArena.things.Thing;
import com.garbagemule.MobArena.things.ThingParser;
import java.util.ArrayList;
import java.util.List;

public class ThingManager
implements ThingParser {
    private List<ThingParser> parsers = new ArrayList<ThingParser>();
    private ItemStackThingParser items;

    public ThingManager(MobArena plugin, ItemStackThingParser parser) {
        this.parsers.add(new CommandThingParser());
        this.parsers.add(new MoneyThingParser(plugin));
        this.items = parser;
    }

    public ThingManager(MobArena plugin) {
        this(plugin, new ItemStackThingParser());
    }

    public void register(ThingParser parser, boolean beforeCoreParsers) {
        if (beforeCoreParsers) {
            this.parsers.add(0, parser);
        } else {
            this.parsers.add(parser);
        }
    }

    public void register(ThingParser parser) {
        this.register(parser, false);
    }

    public void register(ItemStackParser parser) {
        this.items.register(parser);
    }

    @Override
    public Thing parse(String s) {
        for (ThingParser parser : this.parsers) {
            Thing thing = parser.parse(s);
            if (thing == null) continue;
            return thing;
        }
        return this.items.parse(s);
    }
}

