/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.util;

import com.garbagemule.MobArena.util.Enums;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.material.MaterialData;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionType;

public class ItemParser {
    private static final int WOOL_ID = Material.WOOL.getId();
    private static final int DYE_ID = Material.INK_SACK.getId();
    private static final Map<Short, PotionType> POTION_TYPE_MAP = new HashMap<Short, PotionType>();

    public static String parseString(ItemStack ... stacks) {
        String result = "";
        for (ItemStack stack : stacks) {
            if (stack == null || stack.getTypeId() == 0) continue;
            result = result + ", " + ItemParser.parseString(stack);
        }
        if (!result.equals("")) {
            result = result.substring(2);
        }
        return result;
    }

    public static String parseString(ItemStack stack) {
        if (stack.getTypeId() == 0) {
            return null;
        }
        String type = stack.getType().toString().toLowerCase();
        MaterialData md = stack.getData();
        short data = md != null ? md.getData() : (byte)0;
        if (stack.getType() == Material.WOOL) {
            data = (byte)(15 - data);
        } else if (stack.getType() == Material.POTION) {
            data = stack.getDurability();
        }
        int amount = stack.getAmount();
        Map enchants = null;
        if (stack.getType() == Material.ENCHANTED_BOOK) {
            EnchantmentStorageMeta esm = (EnchantmentStorageMeta)stack.getItemMeta();
            enchants = esm.getStoredEnchants();
        } else {
            enchants = stack.getEnchantments();
        }
        String enchantments = "";
        for (Map.Entry entry : enchants.entrySet()) {
            int id = ((Enchantment)entry.getKey()).getId();
            int lvl = (Integer)entry.getValue();
            enchantments = enchantments + ";" + id + ":" + lvl;
        }
        if (!enchantments.equals("")) {
            enchantments = enchantments.substring(1);
        }
        String result = type;
        if (data != 0) {
            result = result + ":" + data;
        }
        if (amount > 1 || data != 0) {
            result = result + ":" + amount;
        }
        if (!enchantments.equals("")) {
            result = result + " " + enchantments;
        }
        return result;
    }

    public static List<ItemStack> parseItems(String s) {
        if (s == null) {
            return new ArrayList<ItemStack>(1);
        }
        String[] items = s.split(",");
        ArrayList<ItemStack> result = new ArrayList<ItemStack>(items.length);
        for (String item : items) {
            ItemStack stack = ItemParser.parseItem(item.trim());
            if (stack == null) continue;
            result.add(stack);
        }
        return result;
    }

    public static ItemStack parseItem(String item) {
        return ItemParser.parseItem(item, true);
    }

    public static ItemStack parseItem(String item, boolean logFailure) {
        if (item == null || item.equals("")) {
            return null;
        }
        String[] space = item.split(" ");
        String[] parts = space.length == 2 ? space[0].split(":") : item.split(":");
        ItemStack result = null;
        switch (parts.length) {
            case 1: {
                result = ItemParser.singleItem(parts[0]);
                break;
            }
            case 2: {
                result = ItemParser.withAmount(parts[0], parts[1]);
                break;
            }
            case 3: {
                result = ItemParser.withDataAndAmount(parts[0], parts[1], parts[2]);
            }
        }
        if (result == null || result.getTypeId() == 0) {
            if (logFailure) {
                Bukkit.getLogger().warning("[MobArena] Failed to parse item: " + item);
            }
            return null;
        }
        if (space.length == 2) {
            ItemParser.addEnchantments(result, space[1]);
        }
        return result;
    }

    private static ItemStack singleItem(String item) {
        int id = ItemParser.getTypeId(item);
        return new ItemStack(id);
    }

    private static ItemStack withAmount(String item, String amount) {
        int id = ItemParser.getTypeId(item);
        int a = ItemParser.getAmount(amount);
        return new ItemStack(id, a);
    }

    private static ItemStack withDataAndAmount(String item, String data, String amount) {
        int id = ItemParser.getTypeId(item);
        short d = ItemParser.getData(data, id);
        int a = ItemParser.getAmount(amount);
        if (id == Material.LINGERING_POTION.getId() || id == Material.TIPPED_ARROW.getId() || id == Material.SPLASH_POTION.getId()) {
            return ItemParser.withPotionMeta(id, d, a);
        }
        return new ItemStack(id, a, d);
    }

    private static ItemStack withPotionMeta(int id, short d, int a) {
        PotionType type;
        boolean upgraded;
        ItemStack result = new ItemStack(id, a);
        PotionMeta meta = (PotionMeta)result.getItemMeta();
        boolean extended = (d & 0x40) > 0;
        boolean bl = upgraded = (d & 0x20) > 0;
        if (extended) {
            d = (short)(d - 64);
        }
        if (upgraded) {
            d = (short)(d - 32);
        }
        if ((type = POTION_TYPE_MAP.get(d)) != null) {
            PotionData pData = new PotionData(type, extended, upgraded);
            meta.setBasePotionData(pData);
            result.setItemMeta((ItemMeta)meta);
            return result;
        }
        return null;
    }

    private static int getTypeId(String item) {
        if (item.matches("(-)?[0-9]*")) {
            return Integer.parseInt(item);
        }
        Material m = Enums.getEnumFromString(Material.class, item);
        return m != null ? m.getId() : 0;
    }

    private static short getData(String data, int id) {
        if (id == WOOL_ID) {
            DyeColor dye = Enums.getEnumFromString(DyeColor.class, data);
            if (dye == null) {
                dye = DyeColor.getByWoolData((byte)Byte.parseByte(data));
            }
            return dye.getWoolData();
        }
        if (id == DYE_ID) {
            DyeColor dye = Enums.getEnumFromString(DyeColor.class, data);
            if (dye == null) {
                dye = DyeColor.getByDyeData((byte)Byte.parseByte(data));
            }
            return dye.getDyeData();
        }
        return data.matches("(-)?[0-9]+") ? Short.parseShort(data) : (short)0;
    }

    private static int getAmount(String amount) {
        if (amount.matches("(-)?[1-9][0-9]*")) {
            return Integer.parseInt(amount);
        }
        return 1;
    }

    private static void addEnchantments(ItemStack stack, String list) {
        String[] parts;
        for (String ench : parts = list.split(";")) {
            ItemParser.addEnchantment(stack, ench.trim());
        }
    }

    private static void addEnchantment(ItemStack stack, String ench) {
        String[] parts = ench.split(":");
        if (parts.length != 2 || !parts[0].matches("[0-9]*") || !parts[1].matches("[0-9]*")) {
            return;
        }
        int id = Integer.parseInt(parts[0]);
        int lvl = Integer.parseInt(parts[1]);
        Enchantment e = Enchantment.getById((int)id);
        if (e == null) {
            return;
        }
        if (stack.getType() == Material.ENCHANTED_BOOK) {
            EnchantmentStorageMeta esm = (EnchantmentStorageMeta)stack.getItemMeta();
            esm.addStoredEnchant(e, lvl, true);
            stack.setItemMeta((ItemMeta)esm);
        } else {
            stack.addUnsafeEnchantment(e, lvl);
        }
    }

    static {
        POTION_TYPE_MAP.put((short)8193, PotionType.REGEN);
        POTION_TYPE_MAP.put((short)8194, PotionType.SPEED);
        POTION_TYPE_MAP.put((short)8195, PotionType.FIRE_RESISTANCE);
        POTION_TYPE_MAP.put((short)8196, PotionType.POISON);
        POTION_TYPE_MAP.put((short)8197, PotionType.INSTANT_HEAL);
        POTION_TYPE_MAP.put((short)8198, PotionType.NIGHT_VISION);
        POTION_TYPE_MAP.put((short)8200, PotionType.WEAKNESS);
        POTION_TYPE_MAP.put((short)8201, PotionType.STRENGTH);
        POTION_TYPE_MAP.put((short)8202, PotionType.SLOWNESS);
        POTION_TYPE_MAP.put((short)8203, PotionType.JUMP);
        POTION_TYPE_MAP.put((short)8204, PotionType.INSTANT_DAMAGE);
        POTION_TYPE_MAP.put((short)8205, PotionType.WATER_BREATHING);
        POTION_TYPE_MAP.put((short)8206, PotionType.INVISIBILITY);
    }
}

