/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.util.timer;

import com.garbagemule.MobArena.Msg;
import com.garbagemule.MobArena.framework.Arena;
import com.garbagemule.MobArena.util.timer.ChatCallback;
import com.garbagemule.MobArena.util.timer.CountdownTimer;
import com.garbagemule.MobArena.util.timer.LevelCallback;
import com.garbagemule.MobArena.util.timer.TimerCallback;
import org.bukkit.plugin.Plugin;

public class AutoStartTimer
extends CountdownTimer
implements TimerCallback {
    private Arena arena;
    private TimerCallback internalCallback;

    public AutoStartTimer(Arena arena) {
        super((Plugin)arena.getPlugin());
        super.setCallback(this);
        this.arena = arena;
        long duration = (long)arena.getSettings().getInt("auto-start-timer", 0) * 20L;
        this.setDuration(Math.max(0L, duration));
        boolean level = arena.getSettings().getBoolean("display-timer-as-level", false);
        if (level) {
            this.internalCallback = new LevelCallback(arena, this);
        } else {
            int[] triggers = new int[]{30, 10, 5, 4, 3, 2, 1};
            this.internalCallback = new ChatCallback(arena, Msg.ARENA_AUTO_START, this, triggers);
        }
    }

    @Override
    public synchronized void start() {
        if (super.getDuration() > 0L) {
            super.start();
        }
    }

    @Override
    public void onStart() {
        this.internalCallback.onStart();
    }

    @Override
    public void onStop() {
        this.internalCallback.onStop();
    }

    @Override
    public void onTick() {
        if (this.arena.isRunning() || this.arena.getPlayersInLobby().isEmpty()) {
            this.stop();
            return;
        }
        this.internalCallback.onTick();
    }

    @Override
    public void onFinish() {
        this.arena.forceStart();
    }
}

