/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.util.timer;

import com.garbagemule.MobArena.Msg;
import com.garbagemule.MobArena.framework.Arena;
import com.garbagemule.MobArena.util.timer.ChatCallback;
import com.garbagemule.MobArena.util.timer.CountdownTimer;
import com.garbagemule.MobArena.util.timer.LevelCallback;
import com.garbagemule.MobArena.util.timer.TimerCallback;
import org.bukkit.plugin.Plugin;

public class StartDelayTimer
extends CountdownTimer
implements TimerCallback {
    private Arena arena;
    private CountdownTimer autoStartTimer;
    private TimerCallback internalCallback;

    public StartDelayTimer(Arena arena, CountdownTimer autoStartTimer) {
        super((Plugin)arena.getPlugin());
        super.setCallback(this);
        this.arena = arena;
        this.autoStartTimer = autoStartTimer;
        long duration = (long)arena.getSettings().getInt("start-delay-timer", 0) * 20L;
        this.setDuration(Math.max(0L, duration));
        boolean level = arena.getSettings().getBoolean("display-timer-as-level", false);
        if (level) {
            this.internalCallback = new LevelCallback(arena, this);
        } else {
            int[] triggers = new int[]{30, 10, 5, 4, 3, 2, 1};
            this.internalCallback = new ChatCallback(arena, Msg.ARENA_START_DELAY, this, triggers);
        }
    }

    @Override
    public synchronized void start() {
        if (super.getDuration() > 0L) {
            super.start();
        } else {
            this.autoStartTimer.start();
        }
    }

    @Override
    public synchronized void stop() {
        if (super.getDuration() > 0L) {
            super.stop();
        } else {
            this.autoStartTimer.stop();
        }
    }

    @Override
    public void onStart() {
        this.internalCallback.onStart();
    }

    @Override
    public void onStop() {
        this.internalCallback.onStop();
    }

    @Override
    public void onTick() {
        if (this.arena.isRunning() || this.arena.getPlayersInLobby().isEmpty()) {
            this.stop();
            return;
        }
        this.internalCallback.onTick();
    }

    @Override
    public void onFinish() {
        if (!this.arena.startArena()) {
            this.autoStartTimer.start();
            if (this.autoStartTimer.isRunning()) {
                this.arena.announce(Msg.ARENA_AUTO_START, "" + this.autoStartTimer.getRemaining() / 20L);
            }
        }
    }
}

