/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.waves;

import com.garbagemule.MobArena.ArenaClass;
import com.garbagemule.MobArena.framework.Arena;
import com.garbagemule.MobArena.region.ArenaRegion;
import com.garbagemule.MobArena.things.Thing;
import com.garbagemule.MobArena.util.ItemParser;
import com.garbagemule.MobArena.util.PotionEffectParser;
import com.garbagemule.MobArena.waves.MACreature;
import com.garbagemule.MobArena.waves.Wave;
import com.garbagemule.MobArena.waves.WaveUtils;
import com.garbagemule.MobArena.waves.ability.Ability;
import com.garbagemule.MobArena.waves.ability.AbilityManager;
import com.garbagemule.MobArena.waves.enums.BossHealth;
import com.garbagemule.MobArena.waves.enums.SwarmAmount;
import com.garbagemule.MobArena.waves.enums.WaveBranch;
import com.garbagemule.MobArena.waves.enums.WaveError;
import com.garbagemule.MobArena.waves.enums.WaveGrowth;
import com.garbagemule.MobArena.waves.enums.WaveType;
import com.garbagemule.MobArena.waves.types.BossWave;
import com.garbagemule.MobArena.waves.types.DefaultWave;
import com.garbagemule.MobArena.waves.types.SpecialWave;
import com.garbagemule.MobArena.waves.types.SupplyWave;
import com.garbagemule.MobArena.waves.types.SwarmWave;
import com.garbagemule.MobArena.waves.types.UpgradeWave;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;

public class WaveParser {
    public static TreeSet<Wave> parseWaves(Arena arena, ConfigurationSection config, WaveBranch branch) {
        TreeSet<Wave> result = new TreeSet<Wave>(WaveUtils.getComparator(branch));
        if (config == null) {
            arena.getPlugin().getLogger().warning(WaveError.BRANCH_MISSING.format(branch.toString().toLowerCase(), arena.configName()));
            return result;
        }
        Set waves = config.getKeys(false);
        if (waves == null) {
            arena.getPlugin().getLogger().warning(WaveError.BRANCH_MISSING.format(branch.toString().toLowerCase(), arena.configName()));
            return result;
        }
        for (String wave : waves) {
            ConfigurationSection waveSection;
            Wave w = WaveParser.parseWave(arena, wave, waveSection = config.getConfigurationSection(wave), branch);
            if (w == null) continue;
            result.add(w);
        }
        return result;
    }

    public static Wave parseWave(Arena arena, String name, ConfigurationSection config, WaveBranch branch) {
        double amountMultiplier;
        String t = config.getString("type", null);
        WaveType type = WaveType.fromString(t);
        if (type == null) {
            arena.getPlugin().getLogger().warning(WaveError.INVALID_TYPE.format(t, name, arena.configName()));
            return null;
        }
        Wave result = null;
        switch (type) {
            case DEFAULT: {
                result = WaveParser.parseDefaultWave(arena, name, config);
                break;
            }
            case SPECIAL: {
                result = WaveParser.parseSpecialWave(arena, name, config);
                break;
            }
            case SWARM: {
                result = WaveParser.parseSwarmWave(arena, name, config);
                break;
            }
            case SUPPLY: {
                result = WaveParser.parseSupplyWave(arena, name, config);
                break;
            }
            case UPGRADE: {
                result = WaveParser.parseUpgradeWave(arena, name, config);
                break;
            }
            case BOSS: {
                result = WaveParser.parseBossWave(arena, name, config);
            }
        }
        if (result == null) {
            arena.getPlugin().getLogger().warning(WaveError.INVALID_WAVE.format(name, arena.configName()));
            return null;
        }
        int priority = config.getInt("priority", -1);
        int frequency = config.getInt("frequency", -1);
        int firstWave = config.getInt("wave", frequency);
        double healthMultiplier = config.getDouble("health-multiplier", -1.0);
        if (healthMultiplier == -1.0) {
            healthMultiplier = config.getInt("health-multiplier", 1);
        }
        if ((amountMultiplier = config.getDouble("amount-multiplier", -1.0)) == -1.0) {
            amountMultiplier = config.getInt("amount-multiplier", 1);
        }
        List<Location> spawnpoints = WaveParser.getSpawnpoints(arena, name, config);
        if (branch == WaveBranch.RECURRENT && (priority == -1 || frequency <= 0)) {
            arena.getPlugin().getLogger().warning(WaveError.RECURRENT_NODES.format(name, arena.configName()));
            return null;
        }
        if (branch == WaveBranch.SINGLE && firstWave <= 0) {
            arena.getPlugin().getLogger().warning(WaveError.SINGLE_NODES.format(name, arena.configName()));
            return null;
        }
        result.setName(name);
        result.setBranch(branch);
        result.setFirstWave(firstWave);
        result.setPriority(priority);
        result.setFrequency(frequency);
        result.setHealthMultiplier(healthMultiplier);
        result.setAmountMultiplier(amountMultiplier);
        result.setSpawnpoints(spawnpoints);
        return result;
    }

    private static Wave parseDefaultWave(Arena arena, String name, ConfigurationSection config) {
        SortedMap<Integer, MACreature> monsters = WaveParser.getMonsterMap(config);
        if (monsters == null || monsters.isEmpty()) {
            arena.getPlugin().getLogger().warning(WaveError.MONSTER_MAP_MISSING.format(name, arena.configName()));
            return null;
        }
        DefaultWave result = new DefaultWave(monsters);
        boolean fixed = config.getBoolean("fixed", false);
        if (fixed) {
            result.setFixed(true);
            return result;
        }
        String grw = config.getString("growth");
        WaveGrowth growth = WaveGrowth.fromString(grw);
        result.setGrowth(growth);
        return result;
    }

    private static Wave parseSpecialWave(Arena arena, String name, ConfigurationSection config) {
        SortedMap<Integer, MACreature> monsters = WaveParser.getMonsterMap(config);
        if (monsters == null || monsters.isEmpty()) {
            arena.getPlugin().getLogger().warning(WaveError.MONSTER_MAP_MISSING.format(name, arena.configName()));
            return null;
        }
        SpecialWave result = new SpecialWave(monsters);
        return result;
    }

    private static Wave parseSwarmWave(Arena arena, String name, ConfigurationSection config) {
        MACreature monster = WaveParser.getSingleMonster(config);
        if (monster == null) {
            arena.getPlugin().getLogger().warning(WaveError.SINGLE_MONSTER_MISSING.format(name, arena.configName()));
            return null;
        }
        SwarmWave result = new SwarmWave(monster);
        String amnt = config.getString("amount");
        SwarmAmount amount = SwarmAmount.fromString(amnt);
        result.setAmount(amount);
        return result;
    }

    private static Wave parseSupplyWave(Arena arena, String name, ConfigurationSection config) {
        SortedMap<Integer, MACreature> monsters = WaveParser.getMonsterMap(config);
        if (monsters == null || monsters.isEmpty()) {
            arena.getPlugin().getLogger().warning(WaveError.MONSTER_MAP_MISSING.format(name, arena.configName()));
            return null;
        }
        SupplyWave result = new SupplyWave(monsters);
        String loot = config.getString("drops");
        List<ItemStack> stacks = ItemParser.parseItems(loot);
        result.setDropList(stacks);
        return result;
    }

    private static Wave parseUpgradeWave(Arena arena, String name, ConfigurationSection config) {
        Map<String, List<UpgradeWave.Upgrade>> upgrades = WaveParser.getUpgradeMap(config);
        if (upgrades == null || upgrades.isEmpty()) {
            arena.getPlugin().getLogger().warning(WaveError.UPGRADE_MAP_MISSING.format(name, arena.configName()));
            return null;
        }
        UpgradeWave result = new UpgradeWave(upgrades);
        boolean giveAll = config.getBoolean("give-all-items", false);
        result.setGiveAll(giveAll);
        return result;
    }

    private static Wave parseBossWave(Arena arena, String name, ConfigurationSection config) {
        List<PotionEffect> potions;
        String healthString;
        MACreature monster = WaveParser.getSingleMonster(config);
        if (monster == null) {
            arena.getPlugin().getLogger().warning(WaveError.SINGLE_MONSTER_MISSING.format(name, arena.configName()));
            return null;
        }
        BossWave result = new BossWave(monster);
        String bossName = config.getString("name");
        if (bossName != null && !bossName.equals("")) {
            result.setBossName(bossName);
        }
        if ((healthString = config.getString("health")) == null) {
            String warning = "No health value found for boss '%s' in arena '%s'. Defaulting to medium.";
            arena.getPlugin().getLogger().warning(String.format(warning, name, arena.configName()));
            result.setHealth(BossHealth.MEDIUM);
        } else {
            BossHealth health = BossHealth.fromString(healthString);
            if (health != null) {
                result.setHealth(health);
            } else {
                int flatHealth = config.getInt("health", 0);
                if (flatHealth <= 0) {
                    String[] warning = "Unable to parse health of boss '%s' in arena '%s'. Defaulting to medium. Value was '%s'";
                    arena.getPlugin().getLogger().warning(String.format((String)warning, name, arena.configName(), healthString));
                    result.setHealth(BossHealth.MEDIUM);
                } else {
                    result.setFlatHealth(flatHealth);
                }
            }
        }
        String ablts = config.getString("abilities");
        if (ablts != null) {
            String[] parts;
            for (String ability : parts = ablts.split(",")) {
                Ability a = AbilityManager.getAbility(ability.trim());
                if (a == null) {
                    arena.getPlugin().getLogger().warning(WaveError.BOSS_ABILITY.format(ability.trim(), name, arena.configName()));
                    continue;
                }
                result.addBossAbility(a);
            }
        }
        result.setAbilityInterval(config.getInt("ability-interval", 3) * 20);
        result.setAbilityAnnounce(config.getBoolean("ability-announce", true));
        String rew = config.getString("reward");
        if (rew != null) {
            try {
                Thing thing = arena.getPlugin().getThingManager().parse(rew.trim());
                if (thing == null) {
                    arena.getPlugin().getLogger().warning("Failed to parse boss reward: " + rew.trim());
                } else {
                    result.setReward(thing);
                }
            }
            catch (Exception e) {
                arena.getPlugin().getLogger().severe("Exception parsing boss reward '" + rew.trim() + "': " + e.getLocalizedMessage());
            }
        }
        String drp = config.getString("drops");
        List<ItemStack> drops = ItemParser.parseItems(drp);
        result.setDrops(drops);
        String pots = config.getString("potions");
        if (pots != null && (potions = PotionEffectParser.parsePotionEffects(pots)) != null) {
            result.setPotions(potions);
        }
        return result;
    }

    private static MACreature getSingleMonster(ConfigurationSection config) {
        String monster = config.getString("monster");
        if (monster == null) {
            return null;
        }
        MACreature result = MACreature.fromString(monster);
        return result;
    }

    private static SortedMap<Integer, MACreature> getMonsterMap(ConfigurationSection config) {
        ConfigurationSection section = config.getConfigurationSection("monsters");
        if (section == null) {
            return null;
        }
        Set monsters = section.getKeys(false);
        if (monsters == null || monsters.isEmpty()) {
            return null;
        }
        TreeMap<Integer, MACreature> monsterMap = new TreeMap<Integer, MACreature>();
        int sum = 0;
        String path = "monsters.";
        for (String monster : monsters) {
            int prob;
            MACreature creature = MACreature.fromString(monster);
            if (creature == null || (prob = config.getInt(path + monster, 0)) == 0) continue;
            monsterMap.put(sum += prob, creature);
        }
        return monsterMap;
    }

    private static List<Location> getSpawnpoints(Arena arena, String name, ConfigurationSection config) {
        ArrayList<Location> result = new ArrayList<Location>();
        String spawnString = config.getString("spawnpoints");
        if (spawnString == null) {
            return result;
        }
        String[] spawns = spawnString.split(";");
        ArenaRegion region = arena.getRegion();
        for (String spawn : spawns) {
            Location spawnpoint = region.getSpawnpoint(spawn.trim());
            if (spawnpoint == null) {
                arena.getPlugin().getLogger().warning("Spawnpoint '" + spawn + "' in wave '" + name + "' for arena '" + arena.configName() + "' could not be parsed!");
                continue;
            }
            result.add(spawnpoint);
        }
        return result;
    }

    private static Map<String, List<UpgradeWave.Upgrade>> getUpgradeMap(ConfigurationSection config) {
        ConfigurationSection section = config.getConfigurationSection("upgrades");
        if (section == null) {
            return null;
        }
        Set classes = section.getKeys(false);
        if (classes == null || classes.isEmpty()) {
            return null;
        }
        HashMap<String, List<UpgradeWave.Upgrade>> upgrades = new HashMap<String, List<UpgradeWave.Upgrade>>();
        String path = "upgrades.";
        for (String className : classes) {
            List perms;
            ArrayList<UpgradeWave.Upgrade> list;
            String itemList;
            Object val = config.get(path + className, null);
            if (val instanceof String) {
                itemList = (String)val;
                List<ItemStack> stacks = ItemParser.parseItems(itemList);
                list = new ArrayList<UpgradeWave.Upgrade>();
                for (ItemStack stack : stacks) {
                    list.add(new UpgradeWave.GenericUpgrade(stack));
                }
                upgrades.put(className.toLowerCase(), list);
                continue;
            }
            if (!(val instanceof ConfigurationSection)) continue;
            ConfigurationSection classSection = (ConfigurationSection)val;
            list = new ArrayList();
            itemList = classSection.getString("items", null);
            if (itemList != null) {
                for (ItemStack stack : ItemParser.parseItems(itemList)) {
                    list.add(ArenaClass.isWeapon(stack) ? new UpgradeWave.WeaponUpgrade(stack) : new UpgradeWave.GenericUpgrade(stack));
                }
            }
            if ((itemList = classSection.getString("armor", null)) != null) {
                for (ItemStack stack : ItemParser.parseItems(itemList)) {
                    list.add(new UpgradeWave.ArmorUpgrade(stack));
                }
            }
            if (!(perms = classSection.getStringList("permissions")).isEmpty()) {
                for (String perm : perms) {
                    list.add(new UpgradeWave.PermissionUpgrade(perm));
                }
            }
            upgrades.put(className.toLowerCase(), list);
        }
        return upgrades;
    }

    public static Wave createDefaultWave() {
        TreeMap<Integer, MACreature> monsters = new TreeMap<Integer, MACreature>();
        monsters.put(10, MACreature.ZOMBIE);
        monsters.put(20, MACreature.SKELETON);
        monsters.put(30, MACreature.SPIDER);
        monsters.put(40, MACreature.SLIMESMALL);
        DefaultWave result = new DefaultWave(monsters);
        result.setName("MA_DEFAULT_WAVE");
        result.setBranch(WaveBranch.RECURRENT);
        result.setFirstWave(1);
        result.setPriority(1);
        result.setFrequency(1);
        result.setGrowth(WaveGrowth.OLD);
        result.setHealthMultiplier(1.0);
        result.setAmountMultiplier(1.0);
        return result;
    }
}

