/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.waves.ability.core;

import com.garbagemule.MobArena.framework.Arena;
import com.garbagemule.MobArena.waves.MABoss;
import com.garbagemule.MobArena.waves.ability.Ability;
import com.garbagemule.MobArena.waves.ability.AbilityInfo;
import com.garbagemule.MobArena.waves.ability.AbilityUtils;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

@AbilityInfo(name="Chain Lightning", aliases={"chainlightning"})
public class ChainLightning
implements Ability {
    private final int RADIUS = 4;
    private final int TICKS = 10;

    @Override
    public void execute(Arena arena, MABoss boss) {
        LivingEntity target = AbilityUtils.getTarget(arena, boss.getEntity(), true);
        if (target == null || !(target instanceof Player)) {
            return;
        }
        this.strikeLightning(arena, (Player)target, new ArrayList<Player>());
    }

    private void strikeLightning(final Arena arena, final Player p, final List<Player> done) {
        arena.scheduleTask(new Runnable(){

            @Override
            public void run() {
                if (!arena.isRunning() || !arena.inArena(p)) {
                    return;
                }
                arena.getWorld().strikeLightning(p.getLocation());
                done.add(p);
                List<Player> nearby = AbilityUtils.getNearbyPlayers(arena, (Entity)p, 4);
                nearby.removeAll(done);
                if (nearby.isEmpty()) {
                    return;
                }
                ChainLightning.this.strikeLightning(arena, nearby.get(0), done);
            }
        }, 10);
    }
}

