/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.waves.types;

import com.garbagemule.MobArena.framework.Arena;
import com.garbagemule.MobArena.waves.AbstractWave;
import com.garbagemule.MobArena.waves.MACreature;
import com.garbagemule.MobArena.waves.Wave;
import com.garbagemule.MobArena.waves.enums.WaveGrowth;
import com.garbagemule.MobArena.waves.enums.WaveType;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.SortedMap;

public class DefaultWave
extends AbstractWave {
    private SortedMap<Integer, MACreature> monsterMap;
    private WaveGrowth growth;
    private boolean fixed;

    public DefaultWave(SortedMap<Integer, MACreature> monsterMap) {
        this.monsterMap = monsterMap;
        this.growth = WaveGrowth.OLD;
        this.setType(WaveType.DEFAULT);
    }

    @Override
    public Map<MACreature, Integer> getMonstersToSpawn(int wave, int playerCount, Arena arena) {
        if (this.fixed) {
            return this.getFixed();
        }
        int toSpawn = (int)Math.max(1.0, (double)this.growth.getAmount(wave, playerCount) * super.getAmountMultiplier());
        int total = this.monsterMap.lastKey();
        Random random = new Random();
        HashMap<MACreature, Integer> monsters = new HashMap<MACreature, Integer>();
        block0: for (int i = 0; i < toSpawn; ++i) {
            int value = random.nextInt(total) + 1;
            for (Map.Entry<Integer, MACreature> entry : this.monsterMap.entrySet()) {
                if (value > entry.getKey()) continue;
                Integer current = (Integer)monsters.get(entry.getValue());
                monsters.put(entry.getValue(), current == null ? 1 : current + 1);
                continue block0;
            }
        }
        return monsters;
    }

    private Map<MACreature, Integer> getFixed() {
        HashMap<MACreature, Integer> result = new HashMap<MACreature, Integer>();
        int last = 0;
        for (Map.Entry<Integer, MACreature> entry : this.monsterMap.entrySet()) {
            int prob = entry.getKey();
            result.put(entry.getValue(), prob - last);
            last = prob;
        }
        return result;
    }

    public WaveGrowth getGrowth() {
        return this.growth;
    }

    public void setGrowth(WaveGrowth growth) {
        this.growth = growth;
        this.fixed = false;
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public void setFixed(boolean fixed) {
        this.fixed = fixed;
    }

    @Override
    public Wave copy() {
        DefaultWave result = new DefaultWave(this.monsterMap);
        result.growth = this.growth;
        result.fixed = this.fixed;
        result.setAmountMultiplier(this.getAmountMultiplier());
        result.setHealthMultiplier(this.getHealthMultiplier());
        result.setName(this.getName());
        result.setSpawnpoints(this.getSpawnpoints());
        return result;
    }
}

