/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena;

import com.garbagemule.MobArena.ArenaClass;
import com.garbagemule.MobArena.framework.Arena;
import com.garbagemule.MobArena.util.MutableInt;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ClassLimitManager {
    private HashMap<ArenaClass, MutableInt> classLimits;
    private HashMap<ArenaClass, HashSet<String>> classesInUse;
    private ConfigurationSection limits;
    private Map<String, ArenaClass> classes;

    public ClassLimitManager(Arena arena, Map<String, ArenaClass> classes, ConfigurationSection limits) {
        this.limits = limits;
        this.classes = classes;
        this.classLimits = new HashMap();
        this.classesInUse = new HashMap();
        this.loadLimitMap((Plugin)arena.getPlugin());
        this.initInUseMap();
    }

    private void loadLimitMap(Plugin plugin) {
        if (this.limits.getKeys(false).isEmpty()) {
            for (ArenaClass ac : this.classes.values()) {
                this.limits.set(ac.getConfigName(), (Object)-1);
            }
            plugin.saveConfig();
        }
        for (ArenaClass ac : this.classes.values()) {
            this.classLimits.put(ac, new MutableInt(this.limits.getInt(ac.getConfigName(), -1)));
        }
    }

    private void initInUseMap() {
        for (ArenaClass ac : this.classes.values()) {
            this.classesInUse.put(ac, new HashSet());
        }
    }

    public void playerPickedClass(ArenaClass ac, Player p) {
        this.classesInUse.get(ac).add(p.getName());
    }

    public void playerLeftClass(ArenaClass ac, Player p) {
        if (ac != null) {
            this.classesInUse.get(ac).remove(p.getName());
        }
    }

    public boolean canPlayerJoinClass(ArenaClass ac) {
        if (this.classLimits.get(ac) == null) {
            this.limits.set(ac.getConfigName(), (Object)-1);
            this.classLimits.put(ac, new MutableInt(-1));
            this.classesInUse.put(ac, new HashSet());
        }
        if (this.classLimits.get(ac).value() <= -1) {
            return true;
        }
        return this.classesInUse.get(ac).size() < this.classLimits.get(ac).value();
    }

    public HashSet<String> getPlayersWithClass(ArenaClass ac) {
        return this.classesInUse.get(ac);
    }

    public void clearClassesInUse() {
        this.classesInUse.clear();
        this.initInUseMap();
    }
}

