/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena;

import com.garbagemule.MobArena.ArenaMasterImpl;
import com.garbagemule.MobArena.Messenger;
import com.garbagemule.MobArena.Msg;
import com.garbagemule.MobArena.commands.CommandHandler;
import com.garbagemule.MobArena.framework.Arena;
import com.garbagemule.MobArena.framework.ArenaMaster;
import com.garbagemule.MobArena.listeners.MAGlobalListener;
import com.garbagemule.MobArena.listeners.MagicSpellsListener;
import com.garbagemule.MobArena.util.VersionChecker;
import com.garbagemule.MobArena.util.config.ConfigUtils;
import com.garbagemule.MobArena.util.inventory.InventoryManager;
import com.garbagemule.MobArena.waves.ability.AbilityManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.ServicesManager;
import org.bukkit.plugin.java.JavaPlugin;

public class MobArena
extends JavaPlugin {
    private ArenaMaster arenaMaster;
    private CommandHandler commandHandler;
    private Set<String> inventoriesToRestore;
    private Economy economy;
    private File configFile;
    private FileConfiguration config;
    public static final double MIN_PLAYER_DISTANCE_SQUARED = 225.0;
    public static final int ECONOMY_MONEY_ID = -29;
    public static Random random = new Random();
    private Messenger messenger;

    public void onEnable() {
        this.configFile = new File(this.getDataFolder(), "config.yml");
        this.config = new YamlConfiguration();
        this.reloadConfig();
        String prefix = this.config.getString("global-settings.prefix", "");
        if (prefix.isEmpty()) {
            prefix = ChatColor.GREEN + "[MobArena] ";
        }
        this.messenger = new Messenger(prefix);
        this.getConfig().options().header(this.getHeader());
        this.saveConfig();
        this.loadAnnouncementsFile();
        this.loadAbilities();
        this.setupVault();
        this.setupMagicSpells();
        this.arenaMaster = new ArenaMasterImpl(this);
        this.arenaMaster.initialize();
        this.registerInventories();
        this.registerListeners();
        this.getLogger().info("v" + this.getDescription().getVersion() + " enabled.");
        if (this.getConfig().getBoolean("global-settings.update-notification", false)) {
            VersionChecker.checkForUpdates(this, null);
        }
    }

    public void onDisable() {
        if (this.arenaMaster == null) {
            return;
        }
        for (Arena arena : this.arenaMaster.getArenas()) {
            arena.forceEnd();
        }
        this.arenaMaster.resetArenaMap();
        VersionChecker.shutdown();
        this.getLogger().info("disabled.");
    }

    public File getPluginFile() {
        return this.getFile();
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadConfig() {
        if (!this.configFile.exists()) {
            this.getLogger().info("No config-file found, creating default...");
            this.saveDefaultConfig();
        }
        BufferedReader in = null;
        try {
            String line;
            in = new BufferedReader(new FileReader(new File(this.getDataFolder(), "config.yml")));
            int row = 0;
            while ((line = in.readLine()) != null) {
                ++row;
                if (line.indexOf(9) == -1) continue;
                StringBuilder buffy = new StringBuilder();
                buffy.append("Found tab in config-file on line ").append(row).append(".");
                buffy.append('\n').append("NEVER use tabs! ALWAYS use spaces!");
                buffy.append('\n').append(line);
                buffy.append('\n');
                for (int i = 0; i < line.indexOf(9); ++i) {
                    buffy.append(' ');
                }
                buffy.append('^');
                throw new IllegalArgumentException(buffy.toString());
            }
            this.config.load(this.configFile);
        }
        catch (InvalidConfigurationException e) {
            throw new RuntimeException("\n\n>>>\n>>> There is an error in your config-file! Handle it!\n>>> Here is what snakeyaml says:\n>>>\n\n" + e.getMessage());
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException("Config-file could not be created for some reason! <o>");
        }
        catch (IOException e) {
            this.getLogger().severe("There was an error reading the config-file:\n" + e.getMessage());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void saveConfig() {
        try {
            this.config.save(this.configFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadAnnouncementsFile() {
        File file = new File(this.getDataFolder(), "announcements.yml");
        try {
            if (file.createNewFile()) {
                this.getLogger().info("announcements.yml created.");
                YamlConfiguration yaml = Msg.toYaml();
                yaml.save(file);
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            YamlConfiguration yaml = new YamlConfiguration();
            yaml.load(file);
            ConfigUtils.addMissingRemoveObsolete(file, Msg.toYaml(), (FileConfiguration)yaml);
            Msg.load((ConfigurationSection)yaml);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void registerListeners() {
        this.commandHandler = new CommandHandler(this);
        this.getCommand("ma").setExecutor((CommandExecutor)this.commandHandler);
        this.getCommand("mobarena").setExecutor((CommandExecutor)this.commandHandler);
        PluginManager pm = this.getServer().getPluginManager();
        pm.registerEvents((Listener)new MAGlobalListener(this, this.arenaMaster), (Plugin)this);
    }

    public boolean has(Player p, String s) {
        return p.hasPermission(s);
    }

    public boolean has(CommandSender sender, String s) {
        if (sender instanceof ConsoleCommandSender) {
            return true;
        }
        return this.has((Player)sender, s);
    }

    private void setupVault() {
        Plugin vaultPlugin = this.getServer().getPluginManager().getPlugin("Vault");
        if (vaultPlugin == null) {
            this.getLogger().warning("Vault was not found. Economy rewards will not work!");
            return;
        }
        ServicesManager manager = this.getServer().getServicesManager();
        RegisteredServiceProvider e = manager.getRegistration(Economy.class);
        if (e != null) {
            this.economy = (Economy)e.getProvider();
            this.getLogger().info("Vault found; economy rewards enabled.");
        } else {
            this.getLogger().warning("Vault found, but no economy plugin detected. Economy rewards will not work!");
        }
    }

    private void setupMagicSpells() {
        Plugin spells = this.getServer().getPluginManager().getPlugin("MagicSpells");
        if (spells == null) {
            return;
        }
        this.getLogger().info("MagicSpells found, loading config-file.");
        this.getServer().getPluginManager().registerEvents((Listener)new MagicSpellsListener(this), (Plugin)this);
    }

    private void loadAbilities() {
        File dir = new File(this.getDataFolder(), "abilities");
        if (!dir.exists()) {
            dir.mkdir();
        }
        AbilityManager.loadCoreAbilities();
        AbilityManager.loadCustomAbilities(dir);
    }

    public ArenaMaster getArenaMaster() {
        return this.arenaMaster;
    }

    public CommandHandler getCommandHandler() {
        return this.commandHandler;
    }

    private String getHeader() {
        String sep = System.getProperty("line.separator");
        return "MobArena v" + this.getDescription().getVersion() + " - Config-file" + sep + "Read the Wiki for details on how to set up this file: http://goo.gl/F5TTc" + sep + "Note: You -must- use spaces instead of tabs!";
    }

    private void registerInventories() {
        this.inventoriesToRestore = new HashSet<String>();
        File dir = new File(this.getDataFolder(), "inventories");
        if (!dir.exists()) {
            dir.mkdir();
            return;
        }
        for (File f : dir.listFiles()) {
            if (!f.getName().endsWith(".inv")) continue;
            this.inventoriesToRestore.add(f.getName().substring(0, f.getName().indexOf(".")));
        }
    }

    public void restoreInventory(Player p) {
        if (!this.inventoriesToRestore.contains(p.getName())) {
            return;
        }
        if (InventoryManager.restoreFromFile(this, p)) {
            this.inventoriesToRestore.remove(p.getName());
        }
    }

    public boolean giveMoney(Player p, ItemStack item) {
        if (this.economy != null) {
            EconomyResponse result = this.economy.depositPlayer((OfflinePlayer)p, this.getAmount(item));
            return result.type == EconomyResponse.ResponseType.SUCCESS;
        }
        return false;
    }

    public boolean takeMoney(Player p, ItemStack item) {
        return this.takeMoney(p, this.getAmount(item));
    }

    public boolean takeMoney(Player p, double amount) {
        if (this.economy != null) {
            EconomyResponse result = this.economy.withdrawPlayer((OfflinePlayer)p, amount);
            return result.type == EconomyResponse.ResponseType.SUCCESS;
        }
        return false;
    }

    public boolean hasEnough(Player p, ItemStack item) {
        return this.hasEnough(p, this.getAmount(item));
    }

    public boolean hasEnough(Player p, double amount) {
        return this.economy == null || this.economy.getBalance((OfflinePlayer)p) >= amount;
    }

    public String economyFormat(ItemStack item) {
        return this.economyFormat(this.getAmount(item));
    }

    public String economyFormat(double amount) {
        return this.economy == null ? null : this.economy.format(amount);
    }

    private double getAmount(ItemStack item) {
        double major = item.getAmount();
        double minor = (double)item.getDurability() / 100.0;
        return major + minor;
    }

    public Messenger getGlobalMessenger() {
        return this.messenger;
    }
}

