/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.commands.setup;

import com.garbagemule.MobArena.ArenaClass;
import com.garbagemule.MobArena.commands.Command;
import com.garbagemule.MobArena.commands.CommandInfo;
import com.garbagemule.MobArena.framework.ArenaMaster;
import org.bukkit.command.CommandSender;

@CommandInfo(name="setclassprice", pattern="set(class)?price|fee", usage="/ma setclassprice <classname> $<price>", desc="set the price of a class", permission="mobarena.setup.classes")
public class SetClassPriceCommand
implements Command {
    @Override
    public boolean execute(ArenaMaster am, CommandSender sender, String ... args) {
        String msg;
        String value;
        if (args.length < 1) {
            return false;
        }
        String arg1 = args[0];
        String arg2 = args.length > 1 ? args[1] : "";
        ArenaClass ac = am.getClasses().get(arg1);
        if (ac == null) {
            am.getGlobalMessenger().tell(sender, "No class named '" + arg1 + "'.");
            return true;
        }
        if (!arg2.equals("")) {
            if (arg2.startsWith("$")) {
                arg2 = arg2.substring(1);
            }
            if (!arg2.matches("([1-9]\\d*)|(\\d*.\\d\\d?)")) {
                am.getGlobalMessenger().tell(sender, "Could not parse price '" + arg2 + "'. Expected e.g. $10 or $2.50 or $.25");
                return true;
            }
            double price = Double.parseDouble(arg2);
            value = "$" + arg2;
            msg = "Price for class '" + ac.getConfigName() + "' was set to " + am.getPlugin().economyFormat(price);
        } else {
            value = null;
            msg = "Price for class '" + ac.getConfigName() + "' was removed. The class is now free!";
        }
        am.getPlugin().getConfig().set("classes." + ac.getConfigName() + ".price", (Object)value);
        am.getPlugin().saveConfig();
        am.loadClasses();
        am.getGlobalMessenger().tell(sender, msg);
        return true;
    }
}

