/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.region;

import com.garbagemule.MobArena.MAUtils;
import com.garbagemule.MobArena.MobArena;
import com.garbagemule.MobArena.framework.Arena;
import com.garbagemule.MobArena.region.RegionPoint;
import com.garbagemule.MobArena.util.Enums;
import com.garbagemule.MobArena.util.config.ConfigUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class ArenaRegion {
    private Arena arena;
    private World world;
    private Location lastP1;
    private Location lastP2;
    private Location lastL1;
    private Location lastL2;
    private Location p1;
    private Location p2;
    private Location l1;
    private Location l2;
    private Location arenaWarp;
    private Location lobbyWarp;
    private Location specWarp;
    private Location exitWarp;
    private Location leaderboard;
    private Map<String, Location> spawnpoints;
    private Map<String, Location> containers;
    private boolean setup;
    private boolean lobbySetup;
    private ConfigurationSection coords;
    private ConfigurationSection spawns;
    private ConfigurationSection chests;

    public ArenaRegion(ConfigurationSection section, Arena arena) {
        this.arena = arena;
        this.refreshWorld();
        this.coords = ConfigUtils.makeSection(section, "coords");
        this.spawns = ConfigUtils.makeSection(this.coords, "spawnpoints");
        this.chests = ConfigUtils.makeSection(this.coords, "containers");
        this.reloadAll();
    }

    public void refreshWorld() {
        this.world = this.arena.getWorld();
    }

    public void reloadAll() {
        this.reloadRegion();
        this.reloadWarps();
        this.reloadLeaderboards();
        this.reloadSpawnpoints();
        this.reloadChests();
        this.verifyData();
    }

    public void reloadRegion() {
        this.p1 = ConfigUtils.parseLocation(this.coords, "p1", this.world);
        this.p2 = ConfigUtils.parseLocation(this.coords, "p2", this.world);
        this.l1 = ConfigUtils.parseLocation(this.coords, "l1", this.world);
        this.l2 = ConfigUtils.parseLocation(this.coords, "l2", this.world);
    }

    public void reloadWarps() {
        this.arenaWarp = ConfigUtils.parseLocation(this.coords, "arena", this.world);
        this.lobbyWarp = ConfigUtils.parseLocation(this.coords, "lobby", this.world);
        this.specWarp = ConfigUtils.parseLocation(this.coords, "spectator", this.world);
        this.exitWarp = ConfigUtils.parseLocation(this.coords, "exit", null);
    }

    public void reloadLeaderboards() {
        try {
            this.leaderboard = ConfigUtils.parseLocation(this.coords, "leaderboard", null);
        }
        catch (IllegalArgumentException e) {
            this.leaderboard = ConfigUtils.parseLocation(this.coords, "leaderboard", this.world);
        }
        if (this.leaderboard != null && this.leaderboard.getWorld() == null) {
            this.leaderboard.setWorld(this.world);
        }
    }

    public void reloadSpawnpoints() {
        this.spawnpoints = new HashMap<String, Location>();
        Set keys = this.spawns.getKeys(false);
        if (keys != null) {
            for (String spwn : keys) {
                this.spawnpoints.put(spwn, ConfigUtils.parseLocation(this.spawns, spwn, this.world));
            }
        }
    }

    public void reloadChests() {
        this.containers = new HashMap<String, Location>();
        Set keys = this.chests.getKeys(false);
        if (keys != null) {
            for (String chst : keys) {
                this.containers.put(chst, ConfigUtils.parseLocation(this.chests, chst, this.world));
            }
        }
    }

    public void verifyData() {
        this.setup = this.p1 != null && this.p2 != null && this.arenaWarp != null && this.lobbyWarp != null && this.specWarp != null && !this.spawnpoints.isEmpty();
        this.lobbySetup = this.l1 != null && this.l2 != null;
    }

    public void checkData(MobArena plugin, CommandSender s, boolean ready, boolean region, boolean warps, boolean spawns) {
        this.verifyData();
        ArrayList<String> list = new ArrayList<String>();
        if (region) {
            if (this.p1 == null) {
                list.add("p1");
            }
            if (this.p2 == null) {
                list.add("p2");
            }
            if (!list.isEmpty()) {
                this.arena.getGlobalMessenger().tell(s, "Missing region points: " + MAUtils.listToString(list, plugin));
                list.clear();
            }
        }
        if (warps) {
            if (this.arenaWarp == null) {
                list.add("arena");
            }
            if (this.lobbyWarp == null) {
                list.add("lobby");
            }
            if (this.specWarp == null) {
                list.add("spectator");
            }
            if (!list.isEmpty()) {
                this.arena.getGlobalMessenger().tell(s, "Missing warps: " + MAUtils.listToString(list, plugin));
                list.clear();
            }
        }
        if (spawns && this.spawnpoints.isEmpty()) {
            this.arena.getGlobalMessenger().tell(s, "Missing spawnpoints");
        }
        if (ready && this.setup) {
            this.arena.getGlobalMessenger().tell(s, "Arena is ready to be used!");
        }
    }

    public boolean isDefined() {
        return this.p1 != null && this.p2 != null;
    }

    public boolean isLobbyDefined() {
        return this.l1 != null && this.l2 != null;
    }

    public boolean isSetup() {
        return this.setup;
    }

    public boolean isLobbySetup() {
        return this.lobbySetup;
    }

    public boolean isWarp(Location l) {
        return l.equals((Object)this.arenaWarp) || l.equals((Object)this.lobbyWarp) || l.equals((Object)this.specWarp) || l.equals((Object)this.exitWarp);
    }

    public boolean contains(Location l) {
        if (!l.getWorld().getName().equals(this.world.getName()) || !this.isDefined()) {
            return false;
        }
        int x = l.getBlockX();
        int y = l.getBlockY();
        int z = l.getBlockZ();
        if (this.lobbySetup && x >= this.l1.getBlockX() && x <= this.l2.getBlockX() && z >= this.l1.getBlockZ() && z <= this.l2.getBlockZ() && y >= this.l1.getBlockY() && y <= this.l2.getBlockY()) {
            return true;
        }
        return x >= this.p1.getBlockX() && x <= this.p2.getBlockX() && z >= this.p1.getBlockZ() && z <= this.p2.getBlockZ() && y >= this.p1.getBlockY() && y <= this.p2.getBlockY();
    }

    public boolean contains(Location l, int radius) {
        if (!l.getWorld().getName().equals(this.world.getName()) || !this.isDefined()) {
            return false;
        }
        int x = l.getBlockX();
        int y = l.getBlockY();
        int z = l.getBlockZ();
        if (this.lobbySetup && x + radius >= this.l1.getBlockX() && x - radius <= this.l2.getBlockX() && z + radius >= this.l1.getBlockZ() && z - radius <= this.l2.getBlockZ() && y + radius >= this.l1.getBlockY() && y - radius <= this.l2.getBlockY()) {
            return true;
        }
        return x + radius >= this.p1.getBlockX() && x - radius <= this.p2.getBlockX() && z + radius >= this.p1.getBlockZ() && z - radius <= this.p2.getBlockZ() && y + radius >= this.p1.getBlockY() && y - radius <= this.p2.getBlockY();
    }

    public void expandUp(int amount) {
        int x = this.p2.getBlockX();
        int y = Math.min(this.p2.getWorld().getMaxHeight(), this.p2.getBlockY() + amount);
        int z = this.p2.getBlockZ();
        this.setSaveReload(this.coords, "p2", this.p2.getWorld(), x, y, z);
    }

    public void expandDown(int amount) {
        int x = this.p1.getBlockX();
        int y = Math.max(0, this.p1.getBlockY() - amount);
        int z = this.p1.getBlockZ();
        this.setSaveReload(this.coords, "p1", this.p1.getWorld(), x, y, z);
    }

    public void expandP1(int dx, int dz) {
        int x = this.p1.getBlockX() - dx;
        int y = this.p1.getBlockY();
        int z = this.p1.getBlockZ() - dz;
        this.setSaveReload(this.coords, "p1", this.p1.getWorld(), x, y, z);
    }

    public void expandP2(int dx, int dz) {
        int x = this.p2.getBlockX() + dx;
        int y = this.p2.getBlockY();
        int z = this.p2.getBlockZ() + dz;
        this.setSaveReload(this.coords, "p2", this.p2.getWorld(), x, y, z);
    }

    public void expandOut(int amount) {
        this.expandP1(amount, amount);
        this.expandP2(amount, amount);
    }

    public void expandLobbyUp(int amount) {
        int x = this.l2.getBlockX();
        int y = Math.min(this.l2.getWorld().getMaxHeight(), this.l2.getBlockY() + amount);
        int z = this.l2.getBlockZ();
        this.setSaveReload(this.coords, "l2", this.l2.getWorld(), x, y, z);
    }

    public void expandLobbyDown(int amount) {
        int x = this.l1.getBlockX();
        int y = Math.max(0, this.l1.getBlockY() - amount);
        int z = this.l1.getBlockZ();
        this.setSaveReload(this.coords, "l1", this.l1.getWorld(), x, y, z);
    }

    public void expandL1(int dx, int dz) {
        int x = this.l1.getBlockX() - dx;
        int y = this.l1.getBlockY();
        int z = this.l1.getBlockZ() - dz;
        this.setSaveReload(this.coords, "l1", this.l1.getWorld(), x, y, z);
    }

    public void expandL2(int dx, int dz) {
        int x = this.l2.getBlockX() + dx;
        int y = this.l2.getBlockY();
        int z = this.l2.getBlockZ() + dz;
        this.setSaveReload(this.coords, "l2", this.l2.getWorld(), x, y, z);
    }

    public void expandLobbyOut(int amount) {
        this.expandL1(amount, amount);
        this.expandL2(amount, amount);
    }

    private void setSaveReload(ConfigurationSection section, String key, World w, double x, double y, double z) {
        Location loc = new Location(w, x, y, z);
        ConfigUtils.setLocation(section, key, loc);
        this.save();
        this.reloadRegion();
    }

    public void fixRegion() {
        this.fix("p1", "p2");
    }

    public void fixLobbyRegion() {
        this.fix("l1", "l2");
    }

    private void fix(String location1, String location2) {
        double tmp;
        Location loc1 = ConfigUtils.parseLocation(this.coords, location1, this.world);
        Location loc2 = ConfigUtils.parseLocation(this.coords, location2, this.world);
        if (loc1 == null || loc2 == null) {
            return;
        }
        boolean modified = false;
        if (loc1.getX() > loc2.getX()) {
            tmp = loc1.getX();
            loc1.setX(loc2.getX());
            loc2.setX(tmp);
            modified = true;
        }
        if (loc1.getZ() > loc2.getZ()) {
            tmp = loc1.getZ();
            loc1.setZ(loc2.getZ());
            loc2.setZ(tmp);
            modified = true;
        }
        if (loc1.getY() > loc2.getY()) {
            tmp = loc1.getY();
            loc1.setY(loc2.getY());
            loc2.setY(tmp);
            modified = true;
        }
        if (!this.arena.getWorld().getName().equals(this.world.getName())) {
            this.arena.setWorld(this.world);
            modified = true;
        }
        if (!modified) {
            return;
        }
        ConfigUtils.setLocation(this.coords, location1, loc1);
        ConfigUtils.setLocation(this.coords, location2, loc2);
        this.save();
    }

    public List<Chunk> getChunks() {
        ArrayList<Chunk> result = new ArrayList<Chunk>();
        if (this.p1 == null || this.p2 == null) {
            return result;
        }
        Chunk c1 = this.world.getChunkAt(this.p1);
        Chunk c2 = this.world.getChunkAt(this.p2);
        for (int i = c1.getX(); i <= c2.getX(); ++i) {
            for (int j = c1.getZ(); j <= c2.getZ(); ++j) {
                result.add(this.world.getChunkAt(i, j));
            }
        }
        return result;
    }

    public Location getArenaWarp() {
        return this.arenaWarp;
    }

    public Location getLobbyWarp() {
        return this.lobbyWarp;
    }

    public Location getSpecWarp() {
        return this.specWarp;
    }

    public Location getExitWarp() {
        return this.exitWarp;
    }

    public Location getSpawnpoint(String name) {
        return this.spawnpoints.get(name);
    }

    public Collection<Location> getSpawnpoints() {
        return this.spawnpoints.values();
    }

    public List<Location> getSpawnpointList() {
        return new ArrayList<Location>(this.spawnpoints.values());
    }

    public Collection<Location> getContainers() {
        return this.containers.values();
    }

    public Location getLeaderboard() {
        return this.leaderboard;
    }

    public void set(RegionPoint point, Location loc) {
        switch (point) {
            case P1: 
            case P2: 
            case L1: 
            case L2: {
                this.setPoint(point, loc);
                return;
            }
            case ARENA: 
            case LOBBY: 
            case EXIT: 
            case SPECTATOR: {
                this.setWarp(point, loc);
                return;
            }
            case LEADERBOARD: {
                this.setLeaderboard(loc);
                return;
            }
        }
        throw new IllegalArgumentException("Invalid region point!");
    }

    private void setPoint(RegionPoint point, Location l) {
        RegionPoint r2;
        RegionPoint r1;
        Location upper;
        Location lower;
        switch (point) {
            case P1: {
                this.lastP1 = l.clone();
                lower = this.lastP1.clone();
                upper = this.lastP2 != null ? this.lastP2.clone() : this.p2;
                r1 = RegionPoint.P1;
                r2 = RegionPoint.P2;
                break;
            }
            case P2: {
                this.lastP2 = l.clone();
                lower = this.lastP1 != null ? this.lastP1.clone() : this.p1;
                upper = this.lastP2.clone();
                r1 = RegionPoint.P1;
                r2 = RegionPoint.P2;
                break;
            }
            case L1: {
                this.lastL1 = l.clone();
                lower = this.lastL1.clone();
                upper = this.lastL2 != null ? this.lastL2.clone() : this.l2;
                r1 = RegionPoint.L1;
                r2 = RegionPoint.L2;
                break;
            }
            case L2: {
                this.lastL2 = l.clone();
                lower = this.lastL1 != null ? this.lastL1.clone() : this.l1;
                upper = this.lastL2.clone();
                r1 = RegionPoint.L1;
                r2 = RegionPoint.L2;
                break;
            }
            default: {
                upper = null;
                lower = null;
                r2 = null;
                r1 = null;
            }
        }
        if (lower != null && upper != null) {
            double tmp;
            if (lower.getX() > upper.getX()) {
                tmp = lower.getX();
                lower.setX(upper.getX());
                upper.setX(tmp);
            }
            if (lower.getY() > upper.getY()) {
                tmp = lower.getY();
                lower.setY(upper.getY());
                upper.setY(tmp);
            }
            if (lower.getZ() > upper.getZ()) {
                tmp = lower.getZ();
                lower.setZ(upper.getZ());
                upper.setZ(tmp);
            }
        }
        if (lower != null) {
            ConfigUtils.setLocation(this.coords, r1.name().toLowerCase(), lower);
        }
        if (upper != null) {
            ConfigUtils.setLocation(this.coords, r2.name().toLowerCase(), upper);
        }
        this.save();
        this.reloadRegion();
        this.verifyData();
    }

    public void set(String point, Location loc) {
        RegionPoint rp = Enums.getEnumFromString(RegionPoint.class, point);
        if (rp == null) {
            throw new IllegalArgumentException("Invalid region point '" + point + "'");
        }
        this.set(rp, loc);
    }

    public void setWarp(RegionPoint point, Location l) {
        ConfigUtils.setLocation(this.coords, point.toString(), l);
        this.save();
        this.reloadWarps();
    }

    public void setLeaderboard(Location l) {
        ConfigUtils.setLocation(this.coords, "leaderboard", l);
        this.save();
        this.reloadLeaderboards();
    }

    public void addSpawn(String name, Location loc) {
        ConfigUtils.setLocation(this.spawns, name, loc);
        this.save();
        this.reloadSpawnpoints();
        this.verifyData();
    }

    public boolean removeSpawn(String name) {
        if (this.spawns.getString(name) == null) {
            return false;
        }
        ConfigUtils.setLocation(this.spawns, name, null);
        this.save();
        this.reloadSpawnpoints();
        this.verifyData();
        return true;
    }

    public void addChest(String name, Location loc) {
        ConfigUtils.setLocation(this.chests, name, loc);
        this.save();
        this.reloadChests();
    }

    public boolean removeChest(String name) {
        if (this.chests.getString(name) == null) {
            return false;
        }
        ConfigUtils.setLocation(this.chests, name, null);
        this.save();
        this.reloadChests();
        return true;
    }

    public void save() {
        this.arena.getPlugin().saveConfig();
    }

    public void showRegion(Player p) {
        if (!this.isDefined()) {
            return;
        }
        this.showBlocks(p, this.getFramePoints(this.p1, this.p2));
    }

    public void showLobbyRegion(Player p) {
        if (!this.isLobbyDefined()) {
            return;
        }
        this.showBlocks(p, this.getFramePoints(this.l1, this.l2));
    }

    public void showSpawns(Player p) {
        if (this.spawnpoints.isEmpty()) {
            return;
        }
        this.showBlocks(p, this.spawnpoints.values());
    }

    public void showChests(Player p) {
        if (this.containers.isEmpty()) {
            return;
        }
        this.showBlocks(p, this.containers.values());
    }

    public void checkSpawns(Player p) {
        if (this.spawnpoints.isEmpty()) {
            return;
        }
        HashMap<String, Location> map = new HashMap<String, Location>();
        for (Map.Entry<String, Location> entry : this.spawnpoints.entrySet()) {
            if (!(p.getLocation().distanceSquared(entry.getValue()) < 225.0)) continue;
            map.put(entry.getKey(), entry.getValue());
        }
        if (map.isEmpty()) {
            this.arena.getGlobalMessenger().tell((CommandSender)p, "No spawnpoints cover your location!");
            return;
        }
        this.arena.getGlobalMessenger().tell((CommandSender)p, "The following points cover your location:");
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Location l = (Location)entry.getValue();
            String coords = l.getBlockX() + "," + l.getBlockY() + "," + l.getBlockZ();
            p.sendMessage(ChatColor.AQUA + entry.getKey() + ChatColor.WHITE + " :  " + coords);
        }
        this.showBlocks(p, map.values());
    }

    public void showBlock(final Player p, final Location loc, final int id, final byte data) {
        this.arena.scheduleTask(new Runnable(){

            @Override
            public void run() {
                p.sendBlockChange(loc, id, data);
                ArenaRegion.this.arena.scheduleTask(new Runnable(){

                    @Override
                    public void run() {
                        if (!p.isOnline()) {
                            return;
                        }
                        Block b = loc.getBlock();
                        p.sendBlockChange(loc, b.getTypeId(), b.getData());
                    }
                }, 100);
            }
        }, 0);
    }

    private void showBlocks(final Player p, final Collection<Location> points) {
        this.arena.scheduleTask(new Runnable(){

            @Override
            public void run() {
                final HashMap<Location, BlockState> blocks = new HashMap<Location, BlockState>();
                for (Location l : points) {
                    Block b = l.getBlock();
                    blocks.put(l, b.getState());
                    p.sendBlockChange(l, 35, (byte)14);
                }
                ArenaRegion.this.arena.scheduleTask(new Runnable(){

                    @Override
                    public void run() {
                        if (!p.isOnline()) {
                            return;
                        }
                        for (Map.Entry entry : blocks.entrySet()) {
                            Location l = (Location)entry.getKey();
                            BlockState b = (BlockState)entry.getValue();
                            int id = b.getTypeId();
                            byte data = b.getRawData();
                            p.sendBlockChange(l, id, data);
                        }
                    }
                }, 100);
            }
        }, 0);
    }

    private List<Location> getFramePoints(Location loc1, Location loc2) {
        ArrayList<Location> result = new ArrayList<Location>();
        int x1 = loc1.getBlockX();
        int y1 = loc1.getBlockY();
        int z1 = loc1.getBlockZ();
        int x2 = loc2.getBlockX();
        int y2 = loc2.getBlockY();
        int z2 = loc2.getBlockZ();
        for (int i = x1; i <= x2; ++i) {
            result.add(this.world.getBlockAt(i, y1, z1).getLocation());
            result.add(this.world.getBlockAt(i, y1, z2).getLocation());
            result.add(this.world.getBlockAt(i, y2, z1).getLocation());
            result.add(this.world.getBlockAt(i, y2, z2).getLocation());
        }
        for (int j = y1; j <= y2; ++j) {
            result.add(this.world.getBlockAt(x1, j, z1).getLocation());
            result.add(this.world.getBlockAt(x1, j, z2).getLocation());
            result.add(this.world.getBlockAt(x2, j, z1).getLocation());
            result.add(this.world.getBlockAt(x2, j, z2).getLocation());
        }
        for (int k = z1; k <= z2; ++k) {
            result.add(this.world.getBlockAt(x1, y1, k).getLocation());
            result.add(this.world.getBlockAt(x1, y2, k).getLocation());
            result.add(this.world.getBlockAt(x2, y1, k).getLocation());
            result.add(this.world.getBlockAt(x2, y2, k).getLocation());
        }
        return result;
    }
}

