/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.util;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class PotionEffectParser {
    private static final int TICKS_PER_SECOND = 20;
    private static final int DEFAULT_POTION_AMPLIFIER = 0;
    private static final int DEFAULT_POTION_DURATION = Integer.MAX_VALUE;

    public static List<PotionEffect> parsePotionEffects(String s) {
        if (s == null || s.isEmpty()) {
            return null;
        }
        ArrayList<PotionEffect> potions = new ArrayList<PotionEffect>();
        for (String potion : s.split(",")) {
            PotionEffect eff = PotionEffectParser.parsePotionEffect(potion.trim());
            if (eff == null) continue;
            potions.add(eff);
        }
        return potions;
    }

    public static PotionEffect parsePotionEffect(String p) {
        if (p == null || p.isEmpty()) {
            return null;
        }
        String[] parts = p.split(":");
        PotionEffect result = null;
        switch (parts.length) {
            case 1: {
                result = PotionEffectParser.parseSingle(parts[0]);
                break;
            }
            case 2: {
                result = PotionEffectParser.withAmplifier(parts[0], parts[1]);
                break;
            }
            case 3: {
                result = PotionEffectParser.withAmplifierAndDuration(parts[0], parts[1], parts[2]);
            }
        }
        if (result == null) {
            Bukkit.getLogger().warning("[MobArena] Failed to parse potion effect: " + p);
            return null;
        }
        return result;
    }

    private static PotionEffect parseSingle(String type) {
        PotionEffectType effect = PotionEffectParser.getType(type);
        if (effect == null) {
            return null;
        }
        return new PotionEffect(effect, Integer.MAX_VALUE, 0);
    }

    private static PotionEffect withAmplifier(String type, String amplifier) {
        PotionEffectType effect = PotionEffectParser.getType(type);
        int amp = PotionEffectParser.getAmplification(amplifier);
        if (effect == null || amp == -1) {
            return null;
        }
        return new PotionEffect(effect, Integer.MAX_VALUE, amp);
    }

    private static PotionEffect withAmplifierAndDuration(String type, String amplifier, String duration) {
        PotionEffectType effect = PotionEffectParser.getType(type);
        int amp = PotionEffectParser.getAmplification(amplifier);
        int dur = PotionEffectParser.getDuration(duration);
        if (effect == null || dur == -1 || amp == -1) {
            return null;
        }
        return new PotionEffect(effect, dur * 20, amp);
    }

    private static PotionEffectType getType(String type) {
        PotionEffectType effect = null;
        effect = type.matches("[0-9]+") ? PotionEffectType.getById((int)Integer.parseInt(type)) : PotionEffectType.getByName((String)type.toUpperCase());
        return effect;
    }

    private static int getDuration(String duration) {
        int dur = -1;
        if (duration.matches("[0-9]+")) {
            dur = Integer.parseInt(duration);
        }
        return dur;
    }

    private static int getAmplification(String amplifier) {
        int amp = -1;
        if (amplifier.matches("[0-9]+")) {
            amp = Integer.parseInt(amplifier);
        }
        return amp;
    }
}

