/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.util.timer;

import com.garbagemule.MobArena.util.timer.Timer;
import com.garbagemule.MobArena.util.timer.TimerCallback;
import org.bukkit.plugin.Plugin;

public abstract class AbstractTimer
implements Timer {
    protected Plugin plugin;
    protected TimerCallback callback;
    protected long interval;

    public AbstractTimer(Plugin plugin, long interval, TimerCallback callback) {
        this.plugin = plugin;
        this.callback = callback;
        this.setInterval(interval);
    }

    @Override
    public void setCallback(TimerCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("Callback may not be null.");
        }
        if (this.callback != null) {
            throw new IllegalStateException("Timer already has a callback.");
        }
        this.callback = callback;
    }

    @Override
    public long getInterval() {
        return this.interval;
    }

    @Override
    public void setInterval(long interval) {
        if (interval <= 0L) {
            throw new IllegalArgumentException("Tick interval must be positive: " + interval);
        }
        this.interval = interval;
    }
}

