/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.util.timer;

import com.garbagemule.MobArena.util.timer.AbstractTimer;
import com.garbagemule.MobArena.util.timer.TimerCallback;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class CountdownTimer
extends AbstractTimer {
    private long duration;
    private long remaining;
    private Timer timer;

    public CountdownTimer(Plugin plugin, long duration, long interval, TimerCallback callback) {
        super(plugin, interval, callback);
        this.setDuration(duration);
        this.remaining = 0L;
        this.timer = null;
    }

    public CountdownTimer(Plugin plugin, long duration, long interval) {
        this(plugin, duration, interval, null);
    }

    public CountdownTimer(Plugin plugin, long duration, TimerCallback callback) {
        this(plugin, duration, duration, callback);
    }

    public CountdownTimer(Plugin plugin, long duration) {
        this(plugin, duration, duration, null);
    }

    public CountdownTimer(Plugin plugin) {
        this(plugin, 0L, 1L, null);
    }

    @Override
    public synchronized void start() {
        if (this.timer != null) {
            return;
        }
        this.remaining = this.duration;
        this.callback.onStart();
        this.timer = new Timer();
    }

    @Override
    public synchronized void stop() {
        if (this.timer == null) {
            return;
        }
        this.timer.stop();
        this.timer = null;
        this.remaining = 0L;
        this.callback.onStop();
    }

    @Override
    public synchronized boolean isRunning() {
        return this.timer != null;
    }

    public synchronized long getDuration() {
        return this.duration;
    }

    public synchronized void setDuration(long duration) {
        if (duration < 0L) {
            throw new IllegalArgumentException("Duration must be non-negative: " + duration);
        }
        this.duration = duration;
    }

    public synchronized long getRemaining() {
        return this.remaining;
    }

    private class Timer
    implements Runnable {
        private BukkitTask task;

        public Timer() {
            this.reschedule();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            CountdownTimer countdownTimer = CountdownTimer.this;
            synchronized (countdownTimer) {
                CountdownTimer.this.remaining = CountdownTimer.this.remaining - CountdownTimer.this.interval;
                if (CountdownTimer.this.remaining <= 0L) {
                    CountdownTimer.this.timer = null;
                    CountdownTimer.this.callback.onFinish();
                    return;
                }
                CountdownTimer.this.callback.onTick();
                if (this.task != null) {
                    this.reschedule();
                }
            }
        }

        public synchronized void stop() {
            this.task.cancel();
            this.task = null;
        }

        private synchronized void reschedule() {
            long nextInterval = CountdownTimer.this.remaining < CountdownTimer.this.interval ? CountdownTimer.this.remaining : CountdownTimer.this.interval;
            this.task = Bukkit.getScheduler().runTaskLater(CountdownTimer.this.plugin, (Runnable)this, nextInterval);
        }
    }
}

