/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.waves;

import com.garbagemule.MobArena.framework.Arena;
import com.garbagemule.MobArena.waves.Wave;
import com.garbagemule.MobArena.waves.WaveParser;
import com.garbagemule.MobArena.waves.WaveUtils;
import com.garbagemule.MobArena.waves.enums.WaveBranch;
import com.garbagemule.MobArena.waves.enums.WaveError;
import java.util.SortedSet;
import java.util.TreeSet;
import org.bukkit.configuration.ConfigurationSection;

public class WaveManager {
    private Arena arena;
    private ConfigurationSection section;
    private Wave defaultWave;
    private Wave currentWave;
    private TreeSet<Wave> recurrentWaves;
    private TreeSet<Wave> singleWaves;
    private TreeSet<Wave> singleWavesInstance;
    private int wave;
    private int finalWave;

    public WaveManager(Arena arena, ConfigurationSection section) {
        this.arena = arena;
        this.section = section;
        this.wave = 0;
        this.finalWave = 0;
        this.reloadWaves();
    }

    public TreeSet<Wave> getRecurrentWaves() {
        return this.recurrentWaves;
    }

    public void reset() {
        this.reloadWaves();
        this.wave = 0;
        this.singleWavesInstance = new TreeSet<Wave>((SortedSet<Wave>)this.singleWaves);
    }

    public void reloadWaves() {
        ConfigurationSection rConfig = this.section.getConfigurationSection("recurrent");
        ConfigurationSection sConfig = this.section.getConfigurationSection("single");
        this.recurrentWaves = WaveParser.parseWaves(this.arena, rConfig, WaveBranch.RECURRENT);
        this.singleWaves = WaveParser.parseWaves(this.arena, sConfig, WaveBranch.SINGLE);
        this.finalWave = this.section.getParent().getInt("settings.final-wave", 0);
        if (this.recurrentWaves.isEmpty()) {
            this.arena.getPlugin().getLogger().warning(WaveError.NO_RECURRENT_WAVES.format(this.arena.configName()));
            Wave def = WaveParser.createDefaultWave();
            this.recurrentWaves.add(def);
        }
        this.defaultWave = this.recurrentWaves.first();
    }

    public Wave next() {
        SortedSet<Wave> matches;
        ++this.wave;
        this.currentWave = !this.singleWavesInstance.isEmpty() && this.singleWavesInstance.first().matches(this.wave) ? this.singleWavesInstance.pollFirst().copy() : ((matches = this.getMatchingRecurrentWaves(this.wave)).isEmpty() ? this.defaultWave : matches.last()).copy();
        return this.currentWave;
    }

    public Wave getNext() {
        int next = this.wave + 1;
        if (!this.singleWavesInstance.isEmpty() && this.singleWavesInstance.first().matches(next)) {
            return this.singleWavesInstance.first();
        }
        SortedSet<Wave> matches = this.getMatchingRecurrentWaves(this.wave);
        return matches.isEmpty() ? this.defaultWave : matches.last();
    }

    public Wave getCurrent() {
        return this.currentWave;
    }

    public int getWaveNumber() {
        return this.wave;
    }

    public int getFinalWave() {
        return this.finalWave;
    }

    private SortedSet<Wave> getMatchingRecurrentWaves(int wave) {
        TreeSet<Wave> result = new TreeSet<Wave>(WaveUtils.getRecurrentComparator());
        for (Wave w : this.recurrentWaves) {
            if (!w.matches(wave)) continue;
            result.add(w);
        }
        return result;
    }
}

