/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.waves.ability;

import com.garbagemule.MobArena.MAUtils;
import com.garbagemule.MobArena.framework.Arena;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class AbilityUtils {
    public static Random random = new Random();

    public static LivingEntity getTarget(Arena arena, LivingEntity entity, boolean random) {
        LivingEntity target;
        if (entity instanceof Creature && (target = ((Creature)entity).getTarget()) instanceof Player && arena.inArena((Player)target)) {
            return target;
        }
        if (random) {
            return AbilityUtils.getRandomPlayer(arena);
        }
        return null;
    }

    public static Player getRandomPlayer(Arena arena) {
        ArrayList<Player> list = new ArrayList<Player>(arena.getPlayersInArena());
        if (list.isEmpty()) {
            return null;
        }
        return (Player)list.get(random.nextInt(list.size()));
    }

    public static List<Player> getNearbyPlayers(Arena arena, Entity boss, int x) {
        ArrayList<Player> result = new ArrayList<Player>();
        for (Entity e : boss.getNearbyEntities((double)x, (double)x, (double)x)) {
            if (!arena.getPlayersInArena().contains(e)) continue;
            result.add((Player)e);
        }
        return result;
    }

    public static List<Player> getDistantPlayers(Arena arena, Entity boss, int x) {
        ArrayList<Player> result = new ArrayList<Player>();
        for (Player p : arena.getPlayersInArena()) {
            if (!(MAUtils.distanceSquared(arena.getPlugin(), p, boss.getLocation()) > (double)(x * x))) continue;
            result.add(p);
        }
        return result;
    }
}

