/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.waves.types;

import com.garbagemule.MobArena.Msg;
import com.garbagemule.MobArena.framework.Arena;
import com.garbagemule.MobArena.waves.AbstractWave;
import com.garbagemule.MobArena.waves.BossAbilityThread;
import com.garbagemule.MobArena.waves.MABoss;
import com.garbagemule.MobArena.waves.MACreature;
import com.garbagemule.MobArena.waves.Wave;
import com.garbagemule.MobArena.waves.ability.Ability;
import com.garbagemule.MobArena.waves.ability.AbilityInfo;
import com.garbagemule.MobArena.waves.enums.BossHealth;
import com.garbagemule.MobArena.waves.enums.WaveType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;

public class BossWave
extends AbstractWave {
    private String bossName;
    private MACreature monster;
    private Set<MABoss> bosses;
    private boolean useHealthMultiplier;
    private int healthMultiplier;
    private int flatHealth;
    private List<Ability> abilities;
    private boolean activated;
    private boolean abilityAnnounce;
    private int abilityInterval;
    private ItemStack reward;
    private List<ItemStack> drops;
    private List<PotionEffect> potions;

    public BossWave(MACreature monster) {
        this.monster = monster;
        this.bosses = new HashSet<MABoss>();
        this.abilities = new ArrayList<Ability>();
        this.potions = new ArrayList<PotionEffect>();
        this.activated = false;
        this.abilityAnnounce = false;
        this.setType(WaveType.BOSS);
        this.useHealthMultiplier = true;
        this.healthMultiplier = 0;
        this.flatHealth = 0;
    }

    @Override
    public Map<MACreature, Integer> getMonstersToSpawn(int wave, int playerCount, Arena arena) {
        HashMap<MACreature, Integer> result = new HashMap<MACreature, Integer>();
        result.put(this.monster, 1);
        return result;
    }

    public String getBossName() {
        return this.bossName;
    }

    public void setBossName(String bossName) {
        this.bossName = bossName;
    }

    public int getMaxHealth(int playerCount) {
        if (this.useHealthMultiplier) {
            return (playerCount + 1) * 20 * this.healthMultiplier;
        }
        return this.flatHealth;
    }

    public void setHealth(BossHealth health) {
        this.healthMultiplier = health.getMultiplier();
        this.useHealthMultiplier = true;
    }

    public void setFlatHealth(int flatHealth) {
        this.flatHealth = flatHealth;
        this.useHealthMultiplier = false;
    }

    public void addMABoss(MABoss boss) {
        this.bosses.add(boss);
    }

    public Set<MABoss> getMABosses() {
        HashSet<MABoss> result = new HashSet<MABoss>();
        for (MABoss b : this.bosses) {
            if (b.isDead()) continue;
            result.add(b);
        }
        return result;
    }

    public void addBossAbility(Ability ability) {
        this.abilities.add(ability);
    }

    public int getAbilityInterval() {
        return this.abilityInterval;
    }

    public void setAbilityInterval(int abilityInterval) {
        this.abilityInterval = abilityInterval;
    }

    public boolean getAbilityAnnounce() {
        return this.abilityAnnounce;
    }

    public void setAbilityAnnounce(boolean abilityAnnounce) {
        this.abilityAnnounce = abilityAnnounce;
    }

    public ItemStack getReward() {
        return this.reward;
    }

    public void setReward(ItemStack reward) {
        this.reward = reward;
    }

    public List<ItemStack> getDrops() {
        return this.drops;
    }

    public void setDrops(List<ItemStack> drops) {
        this.drops = drops;
    }

    public List<PotionEffect> getPotions() {
        return this.potions;
    }

    public void setPotions(List<PotionEffect> potions) {
        this.potions = potions;
    }

    public void activateAbilities(Arena arena) {
        if (this.activated) {
            return;
        }
        BossAbilityThread bat = new BossAbilityThread(this, this.abilities, arena);
        arena.scheduleTask(bat, 100);
        this.activated = true;
    }

    public void announceAbility(Ability ability, MABoss boss, Arena arena) {
        if (this.getAbilityAnnounce()) {
            AbilityInfo info = ability.getClass().getAnnotation(AbilityInfo.class);
            arena.announce(Msg.WAVE_BOSS_ABILITY, info.name());
        }
    }

    @Override
    public Wave copy() {
        BossWave result = new BossWave(this.monster);
        for (Ability ability : this.abilities) {
            result.addBossAbility(ability);
        }
        result.abilityInterval = this.abilityInterval;
        result.abilityAnnounce = this.abilityAnnounce;
        result.useHealthMultiplier = this.useHealthMultiplier;
        result.healthMultiplier = this.healthMultiplier;
        result.flatHealth = this.flatHealth;
        result.reward = this.reward;
        result.drops = this.drops;
        result.potions = this.potions;
        result.bossName = this.bossName;
        result.setAmountMultiplier(this.getAmountMultiplier());
        result.setHealthMultiplier(this.getHealthMultiplier());
        result.setName(this.getName());
        result.setSpawnpoints(this.getSpawnpoints());
        return result;
    }
}

