/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.waves.types;

import com.garbagemule.MobArena.ArenaClass;
import com.garbagemule.MobArena.framework.Arena;
import com.garbagemule.MobArena.waves.AbstractWave;
import com.garbagemule.MobArena.waves.MACreature;
import com.garbagemule.MobArena.waves.Wave;
import com.garbagemule.MobArena.waves.enums.WaveType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class UpgradeWave
extends AbstractWave {
    private Map<String, List<Upgrade>> upgrades;
    private boolean giveAll;

    public UpgradeWave(Map<String, List<Upgrade>> upgrades) {
        this.upgrades = upgrades;
        this.setType(WaveType.UPGRADE);
    }

    @Override
    public Map<MACreature, Integer> getMonstersToSpawn(int wave, int playerCount, Arena arena) {
        return new HashMap<MACreature, Integer>();
    }

    public void grantItems(Arena arena, Player p, String className) {
        List<Upgrade> list = this.upgrades.get(className);
        if (list == null) {
            return;
        }
        if (this.giveAll) {
            for (Upgrade upgrade : list) {
                upgrade.upgrade(arena, p);
            }
        } else {
            int index = new Random().nextInt(list.size());
            list.get(index).upgrade(arena, p);
        }
    }

    public void setGiveAll(boolean giveAll) {
        this.giveAll = giveAll;
    }

    @Override
    public Wave copy() {
        HashMap<String, List<Upgrade>> upgrades = new HashMap<String, List<Upgrade>>();
        for (Map.Entry<String, List<Upgrade>> entry : this.upgrades.entrySet()) {
            upgrades.put(entry.getKey(), new ArrayList(entry.getValue()));
        }
        UpgradeWave result = new UpgradeWave(upgrades);
        result.giveAll = this.giveAll;
        result.setAmountMultiplier(this.getAmountMultiplier());
        result.setHealthMultiplier(this.getHealthMultiplier());
        result.setName(this.getName());
        result.setSpawnpoints(this.getSpawnpoints());
        return result;
    }

    public static class PermissionUpgrade
    implements Upgrade {
        private String perm;
        private boolean value;

        public PermissionUpgrade(String perm) {
            if (perm.startsWith("-") || perm.startsWith("^")) {
                perm = perm.substring(1).trim();
                this.value = false;
            } else {
                this.value = true;
            }
            this.perm = perm;
        }

        @Override
        public void upgrade(Arena arena, Player p) {
            if (this.perm == null) {
                return;
            }
            arena.addPermission(p, this.perm, this.value);
        }
    }

    public static class GenericUpgrade
    implements Upgrade {
        private ItemStack item;

        public GenericUpgrade(ItemStack item) {
            this.item = item;
        }

        @Override
        public void upgrade(Arena arena, Player p) {
            if (this.item == null) {
                return;
            }
            p.getInventory().addItem(new ItemStack[]{this.item});
        }
    }

    public static class WeaponUpgrade
    implements Upgrade {
        private ItemStack item;

        public WeaponUpgrade(ItemStack item) {
            this.item = item;
        }

        @Override
        public void upgrade(Arena arena, Player p) {
            if (this.item == null) {
                return;
            }
            ItemStack[] items = p.getInventory().getContents();
            int firstEmpty = -1;
            for (int i = 0; i < 9; ++i) {
                if (items[i] == null) {
                    if (firstEmpty >= 0) continue;
                    firstEmpty = i;
                    continue;
                }
                if (items[i].getTypeId() != this.item.getTypeId()) continue;
                items[i] = this.item;
                p.getInventory().setContents(items);
                return;
            }
            if (firstEmpty > 0) {
                items[firstEmpty] = this.item;
                p.getInventory().setContents(items);
            } else {
                p.getInventory().addItem(new ItemStack[]{this.item});
            }
        }
    }

    public static class ArmorUpgrade
    implements Upgrade {
        private ItemStack item;
        private ArenaClass.ArmorType type;

        public ArmorUpgrade(ItemStack item) {
            this.item = item;
            this.type = ArenaClass.ArmorType.getType(item);
        }

        @Override
        public void upgrade(Arena arena, Player p) {
            if (this.item == null || this.type == null) {
                return;
            }
            switch (this.type) {
                case HELMET: {
                    p.getInventory().setHelmet(this.item);
                    break;
                }
                case CHESTPLATE: {
                    p.getInventory().setChestplate(this.item);
                    break;
                }
                case LEGGINGS: {
                    p.getInventory().setLeggings(this.item);
                    break;
                }
                case BOOTS: {
                    p.getInventory().setBoots(this.item);
                }
            }
        }
    }

    public static interface Upgrade {
        public void upgrade(Arena var1, Player var2);
    }
}

