/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena;

import com.garbagemule.MobArena.MobArena;
import com.garbagemule.MobArena.framework.Arena;
import com.garbagemule.MobArena.framework.ArenaMaster;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.plugin.Plugin;

public class ArenaClass {
    private String configName;
    private String lowercaseName;
    private ItemStack helmet;
    private ItemStack chestplate;
    private ItemStack leggings;
    private ItemStack boots;
    private ItemStack offhand;
    private List<ItemStack> items;
    private List<ItemStack> armor;
    private Map<String, Boolean> perms;
    private Map<String, Boolean> lobbyperms;
    private boolean unbreakableWeapons;
    private boolean unbreakableArmor;
    private double price;
    private Location classchest;
    private static EnumSet<Material> weaponTypes = EnumSet.of(Material.WOOD_SWORD, new Material[]{Material.GOLD_SWORD, Material.STONE_SWORD, Material.IRON_SWORD, Material.DIAMOND_SWORD, Material.WOOD_AXE, Material.GOLD_AXE, Material.STONE_AXE, Material.IRON_AXE, Material.DIAMOND_AXE, Material.WOOD_PICKAXE, Material.GOLD_PICKAXE, Material.STONE_PICKAXE, Material.IRON_PICKAXE, Material.DIAMOND_PICKAXE, Material.WOOD_SPADE, Material.GOLD_SPADE, Material.STONE_SPADE, Material.IRON_SPADE, Material.DIAMOND_SPADE, Material.WOOD_HOE, Material.GOLD_HOE, Material.STONE_HOE, Material.IRON_HOE, Material.DIAMOND_HOE, Material.BOW, Material.FISHING_ROD, Material.FLINT_AND_STEEL, Material.SHEARS, Material.CARROT_STICK, Material.SHIELD});

    public ArenaClass(String name, double price, boolean unbreakableWeapons, boolean unbreakableArmor) {
        this.configName = name;
        this.lowercaseName = name.toLowerCase().replace(" ", "");
        this.items = new ArrayList<ItemStack>();
        this.armor = new ArrayList<ItemStack>(4);
        this.perms = new HashMap<String, Boolean>();
        this.lobbyperms = new HashMap<String, Boolean>();
        this.unbreakableWeapons = unbreakableWeapons;
        this.unbreakableArmor = unbreakableArmor;
        this.price = price;
    }

    public String getConfigName() {
        return this.configName;
    }

    public String getLowercaseName() {
        return this.lowercaseName;
    }

    public Material getLogo() {
        if (this.items.isEmpty()) {
            return Material.STONE;
        }
        return this.items.get(0).getType();
    }

    public void setHelmet(ItemStack helmet) {
        this.helmet = helmet;
    }

    public void setChestplate(ItemStack chestplate) {
        this.chestplate = chestplate;
    }

    public void setLeggings(ItemStack leggings) {
        this.leggings = leggings;
    }

    public void setBoots(ItemStack boots) {
        this.boots = boots;
    }

    public void setOffHand(ItemStack offHand) {
        this.offhand = offHand;
    }

    public void addItem(ItemStack stack) {
        if (stack == null) {
            return;
        }
        if (stack.getAmount() > 64) {
            while (stack.getAmount() > 64) {
                this.items.add(new ItemStack(stack.getType(), 64));
                stack.setAmount(stack.getAmount() - 64);
            }
        }
        this.items.add(stack);
    }

    public void setItems(List<ItemStack> stacks) {
        this.items = new ArrayList<ItemStack>(stacks.size());
        for (ItemStack stack : stacks) {
            this.addItem(stack);
        }
    }

    public void setArmor(List<ItemStack> armor) {
        this.armor = armor;
    }

    public void grantItems(Player p) {
        PlayerInventory inv = p.getInventory();
        for (ItemStack stack : this.items) {
            inv.addItem(new ItemStack[]{stack});
        }
        if (!this.armor.isEmpty()) {
            for (ItemStack piece : this.armor) {
                ArmorType type = ArmorType.getType(piece);
                if (type == null) continue;
                switch (type) {
                    case HELMET: {
                        inv.setHelmet(piece);
                        break;
                    }
                    case CHESTPLATE: {
                        inv.setChestplate(piece);
                        break;
                    }
                    case LEGGINGS: {
                        inv.setLeggings(piece);
                        break;
                    }
                    case BOOTS: {
                        inv.setBoots(piece);
                        break;
                    }
                }
            }
        }
        if (this.helmet != null) {
            inv.setHelmet(this.helmet);
        }
        if (this.chestplate != null) {
            inv.setChestplate(this.chestplate);
        }
        if (this.leggings != null) {
            inv.setLeggings(this.leggings);
        }
        if (this.boots != null) {
            inv.setBoots(this.boots);
        }
        if (this.offhand != null) {
            inv.setItemInOffHand(this.offhand);
        }
    }

    public void addPermission(String perm, boolean value) {
        this.perms.put(perm, value);
    }

    public Map<String, Boolean> getPermissions() {
        return Collections.unmodifiableMap(this.perms);
    }

    public void addLobbyPermission(String perm, boolean value) {
        this.lobbyperms.put(perm, value);
    }

    public Map<String, Boolean> getLobbyPermissions() {
        return Collections.unmodifiableMap(this.lobbyperms);
    }

    public PermissionAttachment grantPermissions(MobArena plugin, Player p) {
        if (this.perms.isEmpty()) {
            return null;
        }
        PermissionAttachment pa = p.addAttachment((Plugin)plugin);
        this.grantPerms(pa, this.perms, p);
        return pa;
    }

    public PermissionAttachment grantLobbyPermissions(MobArena plugin, Player p) {
        if (this.lobbyperms.isEmpty()) {
            return null;
        }
        PermissionAttachment pa = p.addAttachment((Plugin)plugin);
        this.grantPerms(pa, this.lobbyperms, p);
        return pa;
    }

    private void grantPerms(PermissionAttachment pa, Map<String, Boolean> map, Player p) {
        for (Map.Entry<String, Boolean> entry : map.entrySet()) {
            try {
                pa.setPermission(entry.getKey(), entry.getValue().booleanValue());
            }
            catch (Exception e) {
                String perm = entry.getKey() + ":" + entry.getValue();
                String player = p.getName();
                pa.getPlugin().getLogger().warning("[PERM00] Failed to attach permission '" + perm + "' to player '" + player + " with class " + this.configName + "'.\nPlease verify that your class permissions are well-formed.");
            }
        }
    }

    public Location getClassChest() {
        return this.classchest;
    }

    public void setClassChest(Location loc) {
        this.classchest = loc;
    }

    public boolean hasUnbreakableWeapons() {
        return this.unbreakableWeapons;
    }

    public boolean hasUnbreakableArmor() {
        return this.unbreakableArmor;
    }

    public double getPrice() {
        return this.price;
    }

    public static boolean isWeapon(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        return weaponTypes.contains(stack.getType());
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!this.getClass().equals(o.getClass())) {
            return false;
        }
        ArenaClass other = (ArenaClass)o;
        return other.lowercaseName.equals(this.lowercaseName);
    }

    public int hashCode() {
        return this.lowercaseName.hashCode();
    }

    public static class MyItems
    extends ArenaClass {
        private ArenaMaster am;

        public MyItems(double price, boolean unbreakableWeapons, boolean unbreakableArmor, ArenaMaster am) {
            super("My Items", price, unbreakableWeapons, unbreakableArmor);
            this.am = am;
        }

        @Override
        public void grantItems(Player p) {
            Arena arena = this.am.getArenaWithPlayer(p);
            if (arena != null) {
                try {
                    arena.getInventoryManager().restoreInv(p);
                }
                catch (Exception e) {
                    this.am.getPlugin().getLogger().severe("Failed to give " + p.getName() + " their own items: " + e.getMessage());
                }
            }
        }

        @Override
        public Location getClassChest() {
            return null;
        }
    }

    public static enum ArmorType {
        HELMET,
        CHESTPLATE,
        LEGGINGS,
        BOOTS;


        public static ArmorType getType(ItemStack stack) {
            switch (stack.getType()) {
                case LEATHER_HELMET: 
                case CHAINMAIL_HELMET: 
                case IRON_HELMET: 
                case DIAMOND_HELMET: 
                case GOLD_HELMET: {
                    return HELMET;
                }
                case LEATHER_CHESTPLATE: 
                case CHAINMAIL_CHESTPLATE: 
                case IRON_CHESTPLATE: 
                case DIAMOND_CHESTPLATE: 
                case GOLD_CHESTPLATE: {
                    return CHESTPLATE;
                }
                case LEATHER_LEGGINGS: 
                case CHAINMAIL_LEGGINGS: 
                case IRON_LEGGINGS: 
                case DIAMOND_LEGGINGS: 
                case GOLD_LEGGINGS: {
                    return LEGGINGS;
                }
                case LEATHER_BOOTS: 
                case CHAINMAIL_BOOTS: 
                case IRON_BOOTS: 
                case DIAMOND_BOOTS: 
                case GOLD_BOOTS: {
                    return BOOTS;
                }
            }
            return null;
        }
    }
}

