/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.commands;

import com.garbagemule.MobArena.Msg;
import com.garbagemule.MobArena.framework.Arena;
import com.garbagemule.MobArena.framework.ArenaMaster;
import com.garbagemule.MobArena.util.TextUtils;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Commands {
    public static Player unwrap(CommandSender sender) {
        Player proxy = (Player)sender;
        UUID id = proxy.getUniqueId();
        return Bukkit.getPlayer((UUID)id);
    }

    public static boolean isPlayer(CommandSender sender) {
        return sender instanceof Player;
    }

    public static Arena getArenaToJoinOrSpec(ArenaMaster am, Player p, String arg1) {
        if (!am.isEnabled()) {
            am.getGlobalMessenger().tell((CommandSender)p, Msg.JOIN_NOT_ENABLED);
            return null;
        }
        List<Arena> arenas = am.getPermittedArenas(p);
        if (arenas.isEmpty()) {
            am.getGlobalMessenger().tell((CommandSender)p, Msg.JOIN_NO_PERMISSION);
            return null;
        }
        if ((arenas = am.getEnabledArenas(arenas)).isEmpty()) {
            am.getGlobalMessenger().tell((CommandSender)p, Msg.JOIN_NOT_ENABLED);
            return null;
        }
        Arena arena = null;
        if (arg1 != null) {
            arena = am.getArenaWithName(arg1);
            if (arena == null) {
                am.getGlobalMessenger().tell((CommandSender)p, Msg.ARENA_DOES_NOT_EXIST);
                return null;
            }
            if (!arenas.contains(arena)) {
                am.getGlobalMessenger().tell((CommandSender)p, Msg.JOIN_ARENA_NOT_ENABLED);
                return null;
            }
        } else {
            if (arenas.size() > 1) {
                am.getGlobalMessenger().tell((CommandSender)p, Msg.JOIN_ARG_NEEDED);
                am.getGlobalMessenger().tell((CommandSender)p, Msg.MISC_LIST_ARENAS.format(TextUtils.listToString(arenas)));
                return null;
            }
            arena = arenas.get(0);
        }
        if (p.isInsideVehicle()) {
            p.leaveVehicle();
        }
        if (p.isSleeping()) {
            p.kickPlayer("Banned for life... Nah, just don't join from a bed ;)");
            return null;
        }
        return arena;
    }
}

