/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.util;

import com.garbagemule.MobArena.MobArena;
import com.garbagemule.MobArena.util.Updater;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class VersionChecker {
    static Updater updater;

    public static void checkForUpdates(final MobArena plugin, final Player player) {
        if (updater == null) {
            updater = new Updater((Plugin)plugin, 31265, plugin.getPluginFile(), Updater.UpdateType.NO_DOWNLOAD, false);
        }
        final Updater cache = updater;
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, new Runnable(){

            @Override
            public void run() {
                if (cache.getResult() == Updater.UpdateResult.UPDATE_AVAILABLE) {
                    String latest = VersionChecker.getLatestVersionString();
                    String current = plugin.getDescription().getVersion();
                    if (latest == null || current == null) {
                        String msg = "Update checker failed. Please check manually!";
                        VersionChecker.message(plugin, player, new String[]{msg});
                    } else if (VersionChecker.isUpdateAvailable(latest, current)) {
                        String msg1 = "MobArena v" + latest + " is now available!";
                        String msg2 = "Your version: v" + current;
                        VersionChecker.message(plugin, player, new String[]{msg1, msg2});
                    }
                }
            }
        });
    }

    private static String getLatestVersionString() {
        String latestName = updater.getLatestName();
        if (!latestName.matches("MobArena v.*")) {
            return null;
        }
        return latestName.substring("MobArena v".length());
    }

    private static boolean isUpdateAvailable(String latestVersion, String currentVersion) {
        String[] latestParts = latestVersion.split("\\.");
        String[] currentParts = currentVersion.split("\\.");
        int parts = Math.max(latestParts.length, currentParts.length);
        for (int i = 0; i < parts; ++i) {
            int latest = VersionChecker.getPart(latestParts, i);
            int current = VersionChecker.getPart(currentParts, i);
            if (current > latest) {
                return false;
            }
            if (latest <= current) continue;
            return true;
        }
        return false;
    }

    private static int getPart(String[] parts, int i) {
        if (i >= parts.length || !parts[i].matches("[0-9]+")) {
            return 0;
        }
        return Integer.parseInt(parts[i]);
    }

    private static void message(final MobArena plugin, final Player player, final String ... messages) {
        Bukkit.getScheduler().runTaskLater((Plugin)plugin, new Runnable(){

            @Override
            public void run() {
                for (String message : messages) {
                    if (player == null) {
                        plugin.getLogger().info(message);
                        continue;
                    }
                    if (!player.isOnline()) continue;
                    plugin.getGlobalMessenger().tell((CommandSender)player, message);
                }
            }
        }, player == null ? 0L : 60L);
    }

    public static void shutdown() {
        updater = null;
    }
}

