/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.util.inventory;

import com.garbagemule.MobArena.MobArena;
import com.garbagemule.MobArena.framework.Arena;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class InventoryManager {
    private File dir;
    private Map<Player, ItemStack[]> items;
    private Map<Player, ItemStack[]> armor;

    public InventoryManager(Arena arena) {
        this.dir = new File(arena.getPlugin().getDataFolder(), "inventories");
        this.dir.mkdir();
        this.items = new HashMap<Player, ItemStack[]>();
        this.armor = new HashMap<Player, ItemStack[]>();
    }

    public void storeInv(Player p) throws IOException {
        if (this.items.containsKey(p)) {
            return;
        }
        ItemStack[] items = p.getInventory().getContents();
        ItemStack[] armor = p.getInventory().getArmorContents();
        this.items.put(p, items);
        this.armor.put(p, armor);
        File file = new File(this.dir, p.getName());
        YamlConfiguration config = new YamlConfiguration();
        config.set("items", (Object)items);
        config.set("armor", (Object)armor);
        config.save(file);
        p.updateInventory();
    }

    public void restoreInv(Player p) throws IOException, InvalidConfigurationException {
        ItemStack[] items = this.items.get(p);
        ItemStack[] armor = this.armor.get(p);
        if (items == null || armor == null) {
            File file = new File(this.dir, p.getName());
            YamlConfiguration config = new YamlConfiguration();
            config.load(file);
            List itemsList = config.getList("items");
            List armorList = config.getList("armor");
            items = itemsList.toArray(new ItemStack[itemsList.size()]);
            armor = armorList.toArray(new ItemStack[armorList.size()]);
        }
        p.getInventory().setContents(items);
        p.getInventory().setArmorContents(armor);
    }

    public void clearCache(Player p) {
        this.items.remove(p);
        this.armor.remove(p);
        File file = new File(this.dir, p.getName());
        if (file.exists()) {
            file.delete();
        }
    }

    public void clearInventory(Player p) {
        PlayerInventory inv = p.getInventory();
        inv.clear();
        inv.setHelmet(null);
        inv.setChestplate(null);
        inv.setLeggings(null);
        inv.setBoots(null);
        inv.setItemInOffHand(null);
        InventoryView view = p.getOpenInventory();
        if (view != null) {
            view.setCursor(null);
            Inventory i = view.getTopInventory();
            if (i != null) {
                i.clear();
            }
        }
    }

    public static boolean hasEmptyInventory(Player p) {
        ItemStack[] inventory = p.getInventory().getContents();
        ItemStack[] armor = p.getInventory().getArmorContents();
        for (ItemStack stack : inventory) {
            if (stack == null || stack.getType() == Material.AIR) continue;
            return false;
        }
        for (ItemStack stack : armor) {
            if (stack == null || stack.getType() == Material.AIR) continue;
            return false;
        }
        return true;
    }

    public static boolean restoreFromFile(MobArena plugin, Player p) {
        try {
            File dir = new File(plugin.getDataFolder(), "inventories");
            File file = new File(dir, p.getName());
            YamlConfiguration config = new YamlConfiguration();
            config.load(file);
            List itemsList = config.getList("items");
            List armorList = config.getList("armor");
            ItemStack[] items = itemsList.toArray(new ItemStack[itemsList.size()]);
            ItemStack[] armor = armorList.toArray(new ItemStack[armorList.size()]);
            p.getInventory().setContents(items);
            p.getInventory().setArmorContents(armor);
            file.delete();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

