/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.waves;

import com.garbagemule.MobArena.framework.Arena;
import com.garbagemule.MobArena.waves.MACreature;
import com.garbagemule.MobArena.waves.Wave;
import com.garbagemule.MobArena.waves.WaveUtils;
import com.garbagemule.MobArena.waves.enums.WaveBranch;
import com.garbagemule.MobArena.waves.enums.WaveType;
import java.util.List;
import java.util.Map;
import org.bukkit.Location;

public abstract class AbstractWave
implements Wave {
    private String name;
    private WaveBranch branch;
    private WaveType type;
    private double healthMultiplier;
    private double amountMultiplier;
    private int firstWave;
    private int frequency;
    private int priority;
    private List<Location> spawnpoints;

    @Override
    public abstract Map<MACreature, Integer> getMonstersToSpawn(int var1, int var2, Arena var3);

    @Override
    public List<Location> getSpawnpoints(Arena arena) {
        return WaveUtils.getValidSpawnpoints(arena, this.spawnpoints, arena.getPlayersInArena());
    }

    protected List<Location> getSpawnpoints() {
        return this.spawnpoints;
    }

    @Override
    public void setSpawnpoints(List<Location> spawnpoints) {
        this.spawnpoints = spawnpoints;
    }

    @Override
    public void announce(Arena arena, int wave) {
        this.type.announce(arena, wave);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public WaveBranch getBranch() {
        return this.branch;
    }

    @Override
    public void setBranch(WaveBranch branch) {
        this.branch = branch;
    }

    @Override
    public WaveType getType() {
        return this.type;
    }

    @Override
    public void setType(WaveType type) {
        this.type = type;
    }

    @Override
    public int getFirstWave() {
        return this.firstWave;
    }

    @Override
    public void setFirstWave(int firstWave) {
        this.firstWave = firstWave;
    }

    @Override
    public int getFrequency() {
        return this.frequency;
    }

    @Override
    public void setFrequency(int frequency) {
        this.frequency = frequency;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public double getHealthMultiplier() {
        return this.healthMultiplier;
    }

    @Override
    public void setHealthMultiplier(double healthMultiplier) {
        this.healthMultiplier = healthMultiplier;
    }

    @Override
    public double getAmountMultiplier() {
        return this.amountMultiplier;
    }

    @Override
    public void setAmountMultiplier(double amountMultiplier) {
        this.amountMultiplier = amountMultiplier;
    }

    @Override
    public boolean matches(int wave) {
        return this.branch.matches(wave, this);
    }
}

