/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.waves;

import com.garbagemule.MobArena.framework.Arena;
import com.garbagemule.MobArena.waves.MABoss;
import com.garbagemule.MobArena.waves.ability.Ability;
import com.garbagemule.MobArena.waves.types.BossWave;
import java.util.List;
import java.util.Set;

public class BossAbilityThread
implements Runnable {
    private BossWave wave;
    private List<Ability> abilities;
    private Arena arena;
    private int counter;

    public BossAbilityThread(BossWave wave, List<Ability> abilities, Arena arena) {
        this.wave = wave;
        this.abilities = abilities;
        this.arena = arena;
        this.counter = 0;
    }

    @Override
    public void run() {
        if (this.abilities.isEmpty()) {
            return;
        }
        if (!this.arena.isRunning() || this.arena.getPlayersInArena().isEmpty()) {
            return;
        }
        Set<MABoss> bosses = this.wave.getMABosses();
        if (bosses.isEmpty()) {
            return;
        }
        for (MABoss boss : bosses) {
            if (!boss.isDead()) continue;
            return;
        }
        Ability ability = this.abilities.get(this.counter++ % this.abilities.size());
        for (MABoss boss : bosses) {
            this.wave.announceAbility(ability, boss, this.arena);
            ability.execute(this.arena, boss);
        }
        this.arena.scheduleTask(this, this.wave.getAbilityInterval());
    }
}

