/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.waves;

import com.garbagemule.MobArena.framework.Arena;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class SheepBouncer
implements Runnable {
    public static final int BOUNCE_INTERVAL = 20;
    private Arena arena;
    private Set<LivingEntity> sheep;

    public SheepBouncer(Arena arena) {
        this.arena = arena;
    }

    @Override
    public void run() {
        if (!this.arena.isRunning() || this.arena.getPlayersInArena().isEmpty()) {
            return;
        }
        this.sheep = new HashSet<LivingEntity>(this.arena.getMonsterManager().getExplodingSheep());
        if (this.sheep.isEmpty()) {
            this.arena.scheduleTask(this, 20);
            return;
        }
        for (LivingEntity e : this.sheep) {
            if (e == null) continue;
            if (e.isDead()) {
                this.arena.getMonsterManager().removeMonster((Entity)e);
                this.arena.getMonsterManager().removeExplodingSheep(e);
                continue;
            }
            for (Entity entity : e.getNearbyEntities(2.0, 2.0, 2.0)) {
                if (!(entity instanceof Player)) continue;
                e.getWorld().createExplosion(e.getLocation(), 2.0f);
                e.remove();
                break;
            }
            if (!(Math.abs(e.getVelocity().getY()) < 1.0)) continue;
            e.setVelocity(e.getVelocity().setY(0.5));
        }
        this.arena.scheduleTask(this, 20);
    }
}

