/*
 * Decompiled with CFR 0.152.
 */
package com.garbagemule.MobArena.waves.ability.core;

import com.garbagemule.MobArena.framework.Arena;
import com.garbagemule.MobArena.waves.MABoss;
import com.garbagemule.MobArena.waves.ability.Ability;
import com.garbagemule.MobArena.waves.ability.AbilityInfo;
import com.garbagemule.MobArena.waves.ability.AbilityUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.LivingEntity;

@AbilityInfo(name="Obsidian Bomb", aliases={"obsidianbomb"})
public class ObsidianBomb
implements Ability {
    private final int FUSE = 80;

    @Override
    public void execute(final Arena arena, MABoss boss) {
        LivingEntity target = AbilityUtils.getTarget(arena, boss.getEntity(), true);
        final World world = arena.getWorld();
        Block b = world.getBlockAt(target.getLocation());
        for (int i = 0; i < 3 && b.getType() != Material.AIR; ++i) {
            b = b.getRelative(BlockFace.UP);
        }
        final Location loc = b.getLocation();
        if (b.getType() != Material.AIR) {
            Bukkit.getLogger().warning("[MobArena] Failed to place Obsidian Bomb at: " + target.getLocation());
            return;
        }
        b.setType(Material.OBSIDIAN);
        arena.addBlock(b);
        arena.scheduleTask(new Runnable(){

            @Override
            public void run() {
                if (!arena.isRunning()) {
                    return;
                }
                world.getBlockAt(loc).setType(Material.AIR);
                world.createExplosion(loc, 3.0f);
            }
        }, 80);
    }
}

