/*
 * Decompiled with CFR 0.152.
 */
package com.nukkitx.protocol.bedrock.v428.serializer;

import com.nukkitx.nbt.NbtMap;
import com.nukkitx.network.VarInts;
import com.nukkitx.protocol.bedrock.BedrockPacketHelper;
import com.nukkitx.protocol.bedrock.data.BlockPropertyData;
import com.nukkitx.protocol.bedrock.data.GameType;
import com.nukkitx.protocol.bedrock.data.SyncedPlayerMovementSettings;
import com.nukkitx.protocol.bedrock.packet.StartGamePacket;
import com.nukkitx.protocol.bedrock.v419.serializer.StartGameSerializer_v419;
import io.netty.buffer.ByteBuf;
import java.util.Collection;

public class StartGameSerializer_v428
extends StartGameSerializer_v419 {
    public static final StartGameSerializer_v428 INSTANCE = new StartGameSerializer_v428();

    public void serialize(ByteBuf buffer, BedrockPacketHelper helper, StartGamePacket packet) {
        VarInts.writeLong((ByteBuf)buffer, (long)packet.getUniqueEntityId());
        VarInts.writeUnsignedLong((ByteBuf)buffer, (long)packet.getRuntimeEntityId());
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getPlayerGameType().ordinal());
        helper.writeVector3f(buffer, packet.getPlayerPosition());
        helper.writeVector2f(buffer, packet.getRotation());
        this.writeLevelSettings(buffer, helper, packet);
        helper.writeString(buffer, packet.getLevelId());
        helper.writeString(buffer, packet.getLevelName());
        helper.writeString(buffer, packet.getPremiumWorldTemplateId());
        buffer.writeBoolean(packet.isTrial());
        this.writeSyncedPlayerMovementSettings(buffer, helper, packet.getPlayerMovementSettings());
        buffer.writeLongLE(packet.getCurrentTick());
        VarInts.writeInt((ByteBuf)buffer, (int)packet.getEnchantmentSeed());
        helper.writeArray(buffer, (Collection)packet.getBlockProperties(), (buf, packetHelper, block) -> {
            packetHelper.writeString(buf, block.getName());
            packetHelper.writeTag(buf, (Object)block.getProperties());
        });
        helper.writeArray(buffer, (Collection)packet.getItemEntries(), (buf, packetHelper, entry) -> {
            packetHelper.writeString(buf, entry.getIdentifier());
            buf.writeShortLE((int)entry.getId());
            buf.writeBoolean(entry.isComponentBased());
        });
        helper.writeString(buffer, packet.getMultiplayerCorrelationId());
        buffer.writeBoolean(packet.isInventoriesServerAuthoritative());
    }

    public void deserialize(ByteBuf buffer, BedrockPacketHelper helper, StartGamePacket packet) {
        packet.setUniqueEntityId(VarInts.readLong((ByteBuf)buffer));
        packet.setRuntimeEntityId(VarInts.readUnsignedLong((ByteBuf)buffer));
        packet.setPlayerGameType(GameType.from((int)VarInts.readInt((ByteBuf)buffer)));
        packet.setPlayerPosition(helper.readVector3f(buffer));
        packet.setRotation(helper.readVector2f(buffer));
        this.readLevelSettings(buffer, helper, packet);
        packet.setLevelId(helper.readString(buffer));
        packet.setLevelName(helper.readString(buffer));
        packet.setPremiumWorldTemplateId(helper.readString(buffer));
        packet.setTrial(buffer.readBoolean());
        packet.setPlayerMovementSettings(this.readSyncedPlayerMovementSettings(buffer, helper));
        packet.setCurrentTick(buffer.readLongLE());
        packet.setEnchantmentSeed(VarInts.readInt((ByteBuf)buffer));
        helper.readArray(buffer, (Collection)packet.getBlockProperties(), (buf, packetHelper) -> {
            String name = packetHelper.readString(buf);
            NbtMap properties = (NbtMap)packetHelper.readTag(buf);
            return new BlockPropertyData(name, properties);
        });
        helper.readArray(buffer, (Collection)packet.getItemEntries(), (buf, packetHelper) -> {
            String identifier = packetHelper.readString(buf);
            short id = buf.readShortLE();
            boolean componentBased = buf.readBoolean();
            return new StartGamePacket.ItemEntry(identifier, id, componentBased);
        });
        packet.setMultiplayerCorrelationId(helper.readString(buffer));
        packet.setInventoriesServerAuthoritative(buffer.readBoolean());
    }

    protected void writeSyncedPlayerMovementSettings(ByteBuf buffer, BedrockPacketHelper helper, SyncedPlayerMovementSettings playerMovementSettings) {
        VarInts.writeUnsignedInt((ByteBuf)buffer, (int)playerMovementSettings.getMovementMode().ordinal());
        VarInts.writeInt((ByteBuf)buffer, (int)playerMovementSettings.getRewindHistorySize());
        buffer.writeBoolean(playerMovementSettings.isServerAuthoritativeBlockBreaking());
    }

    protected SyncedPlayerMovementSettings readSyncedPlayerMovementSettings(ByteBuf buffer, BedrockPacketHelper helper) {
        SyncedPlayerMovementSettings playerMovementSettings = new SyncedPlayerMovementSettings();
        playerMovementSettings.setMovementMode(MOVEMENT_MODES[VarInts.readUnsignedInt((ByteBuf)buffer)]);
        playerMovementSettings.setRewindHistorySize(VarInts.readInt((ByteBuf)buffer));
        playerMovementSettings.setServerAuthoritativeBlockBreaking(buffer.readBoolean());
        return playerMovementSettings;
    }

    protected StartGameSerializer_v428() {
    }
}

