/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.zauctionhouse.api.enums;

import fr.maxlego08.zauctionhouse.api.exceptions.ButtonTypeException;

public enum ButtonType {
    NONE,
    NONE_SLOT,
    BACK,
    NEXT,
    HOME,
    PREVIOUS,
    INVENTORY,
    PERFORM_COMMAND,
    AUCTION_ITEM,
    BUY_INVENTORY,
    SHOW_ITEM,
    REMOVE_ITEM,
    BUY_ITEM,
    CHANGE_SORT,
    CATEGORIES,
    REMOVE_ALL,
    SELL_INVENTORY_SLOT,
    SELL_INVENTORY_ACCEPT,
    SELL_INVENTORY_CANCEL,
    SELL_INVENTORY_BUY,
    CLAIM,
    ADMIN_REMOVE,
    SHOW_SLOT;


    public static ButtonType from(String string, String inventoryName, String real) throws ButtonTypeException {
        if (string != null) {
            for (ButtonType type : ButtonType.values()) {
                if (!type.name().equalsIgnoreCase(string)) continue;
                return type;
            }
        }
        throw new ButtonTypeException("Impossible de trouver le " + string + " pour type dans l'inventaire " + inventoryName + " (" + real + ")");
    }

    public boolean isClickable() {
        return this != NONE;
    }

    public boolean isSlots() {
        return this == NONE_SLOT;
    }

    public boolean isOtherClick() {
        switch (this) {
            case AUCTION_ITEM: {
                return true;
            }
        }
        return false;
    }

    public boolean isAuction() {
        switch (this) {
            case AUCTION_ITEM: {
                return true;
            }
        }
        return false;
    }

    public boolean isNeedItems() {
        switch (this) {
            case AUCTION_ITEM: 
            case NEXT: 
            case PREVIOUS: 
            case SELL_INVENTORY_SLOT: 
            case SHOW_ITEM: 
            case SHOW_SLOT: {
                return true;
            }
        }
        return false;
    }

    public boolean isPageChange() {
        switch (this) {
            default: {
                return false;
            }
            case NEXT: 
            case PREVIOUS: 
        }
        return true;
    }

    public boolean isPermament() {
        switch (this) {
            case AUCTION_ITEM: 
            case BACK: {
                return false;
            }
        }
        return true;
    }
}

