/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.zauctionhouse.api.enums;

public enum InventoryType {
    DEFAULT,
    AUCTION,
    EXPIRE,
    BUYING,
    BUY_CONFIRM,
    REMOVE_CONFIRM,
    ITEMS,
    CATEGORIES,
    CATEGORY,
    SELL,
    SELL_SHOW,
    ADMIN_REMOVE,
    SEARCH,
    SHOW;


    public static InventoryType form(String string) {
        if (string == null) {
            return DEFAULT;
        }
        try {
            InventoryType type = InventoryType.valueOf(string.toUpperCase());
            return type == null ? DEFAULT : type;
        }
        catch (Exception e) {
            return DEFAULT;
        }
    }

    public boolean isRemoveAsAdmin() {
        return this == ADMIN_REMOVE;
    }

    public boolean isDefault() {
        return true;
    }

    public boolean isConfirm() {
        return this == BUY_CONFIRM || this == REMOVE_CONFIRM;
    }

    public boolean needToReset() {
        return this == BUY_CONFIRM || this == REMOVE_CONFIRM || this == SELL_SHOW || this == ADMIN_REMOVE;
    }

    public boolean isBuyConfirm() {
        return this == BUY_CONFIRM;
    }

    public boolean isRemove() {
        return this == ADMIN_REMOVE || this == REMOVE_CONFIRM;
    }

    public boolean isPagination() {
        return this == AUCTION || this == EXPIRE || this == BUYING || this == CATEGORY || this == ITEMS;
    }

    public boolean isBuy() {
        return this == BUYING;
    }

    public boolean isAutoRun() {
        return this == AUCTION || this == CATEGORY;
    }

    public boolean isAuction() {
        switch (this) {
            case AUCTION: 
            case CATEGORY: 
            case SEARCH: {
                return true;
            }
        }
        return false;
    }
}

