/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.zauctionhouse.api.filter;

import fr.maxlego08.zauctionhouse.api.AuctionItem;
import fr.maxlego08.zauctionhouse.api.enums.AuctionType;
import fr.maxlego08.zauctionhouse.api.enums.FilterType;
import java.util.Arrays;
import java.util.List;
import org.bukkit.inventory.ItemStack;

public abstract class Filter {
    private final String key;

    public Filter(String key) {
        this.key = key;
    }

    public boolean perform(AuctionItem auctionItem, String string) {
        FilterType filterType = this.findFilterType(string);
        if (filterType == null) {
            return false;
        }
        string = this.stripe(filterType, string);
        return this.perform(auctionItem, filterType, string);
    }

    protected abstract boolean perform(AuctionItem var1, FilterType var2, String var3);

    protected List<ItemStack> getItems(AuctionItem auctionItem) {
        if (auctionItem.getType().equals((Object)AuctionType.INVENTORY)) {
            return auctionItem.getItemStacks();
        }
        return Arrays.asList(auctionItem.getItemStack());
    }

    public String getKey() {
        return this.key;
    }

    public String stripe(FilterType filterType, String string) {
        return string.substring(this.getKey().length() + filterType.getType().length());
    }

    protected FilterType findFilterType(String string) {
        string = String.valueOf(string.substring(this.getKey().length()));
        for (FilterType filterType : FilterType.values()) {
            if (!string.startsWith(filterType.getType())) continue;
            return filterType;
        }
        return null;
    }
}

