/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.zauctionhouse.api.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemBuilder
implements Cloneable {
    private ItemStack item;
    private final Material material;
    private ItemMeta meta;
    private int data;
    private int amount;
    private String name;
    private List<String> lore;
    private List<ItemFlag> flags;
    private int durability;
    private Map<Enchantment, Integer> enchantments;

    public ItemBuilder(Material material, int data, int amount, String name, List<String> lore, List<ItemFlag> flags, Map<Enchantment, Integer> enchantments) {
        this.material = material;
        this.data = data;
        this.amount = amount;
        this.name = name;
        this.lore = lore;
        this.flags = flags;
        this.enchantments = enchantments;
    }

    public ItemBuilder(Material material) {
        this(material, 1);
    }

    public ItemBuilder(Material material, int amount) {
        this(material, 0, amount);
    }

    public ItemBuilder(Material material, int amount, int data) {
        this(material, data, amount, null);
    }

    public ItemBuilder(Material material, int amount, int data, String name) {
        this(material, data, amount, name, null, null, null);
    }

    public ItemBuilder(Material material, int amount, String name) {
        this(material, 0, amount, name, null, null, null);
    }

    public ItemBuilder(Material material, String name) {
        this(material, 0, 1, name, null, null, null);
    }

    public ItemBuilder(Material material, ItemFlag ... flags) {
        this(material, 0, 1, null, null, Arrays.asList(flags), null);
    }

    public ItemBuilder(Material material, String ... lore) {
        this(material, 0, 1, null, Arrays.asList(lore), null, null);
    }

    public ItemBuilder addEnchant(Enchantment enchantment, int value) {
        if (this.enchantments == null) {
            this.enchantments = new HashMap<Enchantment, Integer>();
        }
        this.enchantments.put(enchantment, value);
        return this;
    }

    public ItemBuilder setFlag(ItemFlag ... flags) {
        this.flags = Arrays.asList(flags);
        return this;
    }

    public ItemBuilder setFlag(ItemFlag flag) {
        if (this.flags == null) {
            this.flags = new ArrayList<ItemFlag>();
        }
        this.flags.add(flag);
        return this;
    }

    public ItemBuilder addLine(String format, Object ... args) {
        if (this.lore == null) {
            this.lore = new ArrayList<String>();
        }
        this.lore.add(String.format(format, args));
        return this;
    }

    public ItemBuilder addLine(String format) {
        if (this.lore == null) {
            this.lore = new ArrayList<String>();
        }
        this.lore.add(format);
        return this;
    }

    public ItemBuilder setLore(String ... lores) {
        this.lore = Arrays.asList(lores);
        return this;
    }

    public ItemBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public ItemBuilder durability(int durability) {
        this.durability = durability;
        return this;
    }

    public ItemBuilder glow() {
        this.addEnchant(this.material != Material.BOW ? Enchantment.ARROW_INFINITE : Enchantment.LUCK, 10);
        this.setFlag(ItemFlag.HIDE_ENCHANTS);
        return this;
    }

    public ItemStack build() {
        this.item = new ItemStack(this.material, this.amount, (short)this.data);
        if (this.meta == null) {
            this.meta = this.item.getItemMeta();
        }
        if (this.flags != null) {
            this.flags.forEach(flag -> this.meta.addItemFlags(new ItemFlag[]{flag}));
        }
        if (this.name != null) {
            this.meta.setDisplayName(this.name);
        }
        if (this.lore != null) {
            this.meta.setLore(this.lore);
        }
        if (this.enchantments != null) {
            this.enchantments.forEach((e, l) -> this.meta.addEnchant(e, l.intValue(), true));
        }
        if (this.durability != 0) {
            this.item.setDurability((short)this.durability);
        }
        this.item.setItemMeta(this.meta);
        return this.item;
    }

    public ItemBuilder clone() {
        try {
            return (ItemBuilder)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public ItemStack getItem() {
        return this.item;
    }

    public Material getMaterial() {
        return this.material;
    }

    public ItemMeta getMeta() {
        if (this.meta == null) {
            this.meta = new ItemStack(this.material, this.amount, (short)this.data).getItemMeta();
        }
        return this.meta;
    }

    public int getData() {
        return this.data;
    }

    public int getAmount() {
        return this.amount;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getLore() {
        return this.lore;
    }

    public List<ItemFlag> getFlags() {
        return this.flags;
    }

    public int getDurability() {
        return this.durability;
    }

    public Map<Enchantment, Integer> getEnchantments() {
        return this.enchantments;
    }

    public static ItemStack buildNoMoney() {
        return null;
    }
}

