/*
 * Decompiled with CFR 0.152.
 */
package fr.maxlego08.zauctionhouse.api.utils;

import com.google.gson.Gson;
import fr.maxlego08.zauctionhouse.api.enums.Folder;
import fr.maxlego08.zauctionhouse.api.utils.DiscUtils;
import fr.maxlego08.zauctionhouse.api.utils.Logger;
import java.io.File;
import java.lang.reflect.Type;
import org.bukkit.plugin.Plugin;

public class Persist {
    private final Plugin plugin;
    private final Logger logger;
    private final Gson gson;

    public Persist(Plugin plugin, Logger logger, Gson gson) {
        this.plugin = plugin;
        this.logger = logger;
        this.gson = gson;
    }

    public static String getName(Class<?> clazz) {
        return clazz.getSimpleName().toLowerCase();
    }

    public static String getName(Object o) {
        return Persist.getName(o.getClass());
    }

    public static String getName(Type type) {
        return Persist.getName(type.getClass());
    }

    public File getFile(String name) {
        return new File(this.plugin.getDataFolder(), name + ".json");
    }

    public File getFile(Class<?> clazz) {
        return this.getFile(Persist.getName(clazz));
    }

    public File getFile(Object obj) {
        return this.getFile(Persist.getName(obj));
    }

    public File getFile(Type type) {
        return this.getFile(Persist.getName(type));
    }

    public <T> T loadOrSaveDefault(T def, Class<T> clazz) {
        return this.loadOrSaveDefault(def, clazz, this.getFile(clazz));
    }

    public <T> T loadOrSaveDefault(T def, Class<T> clazz, String name) {
        return this.loadOrSaveDefault(def, clazz, this.getFile(name));
    }

    public <T> T loadOrSaveDefault(T def, Class<T> clazz, Folder folder, String name) {
        return this.loadOrSaveDefault(def, clazz, this.getFile(folder.toFolder() + File.separator + name));
    }

    public <T> T loadOrSaveDefault(T def, Class<T> clazz, File file) {
        if (!file.exists()) {
            this.logger.log("Creating default: " + file, Logger.LogType.SUCCESS);
            this.save(def, file);
            return def;
        }
        T loaded = this.load(clazz, file);
        if (loaded == null) {
            this.logger.log("Using default as I failed to load: " + file, Logger.LogType.WARNING);
            File backup = new File(file.getPath() + "_bad");
            if (backup.exists()) {
                backup.delete();
            }
            this.logger.log("Backing up copy of bad file to: " + backup, Logger.LogType.WARNING);
            file.renameTo(backup);
            return def;
        }
        this.logger.log(file.getAbsolutePath() + " loaded successfully !", Logger.LogType.SUCCESS);
        return loaded;
    }

    public boolean save(Object instance) {
        return this.save(instance, this.getFile(instance));
    }

    public boolean save(Object instance, String name) {
        return this.save(instance, this.getFile(name));
    }

    public boolean save(Object instance, Folder folder, String name) {
        return this.save(instance, this.getFile(folder.toFolder() + File.separator + name));
    }

    public boolean save(Object instance, File file) {
        try {
            boolean b = DiscUtils.writeCatch(file, this.gson.toJson(instance));
            this.logger.log(file.getAbsolutePath() + " successfully saved !", Logger.LogType.SUCCESS);
            return b;
        }
        catch (Exception e) {
            this.logger.log("cannot save file " + file.getAbsolutePath(), Logger.LogType.ERROR);
            e.printStackTrace();
            return false;
        }
    }

    public <T> T load(Class<T> clazz) {
        return this.load(clazz, this.getFile(clazz));
    }

    public <T> T load(Class<T> clazz, String name) {
        return this.load(clazz, this.getFile(name));
    }

    public <T> T load(Class<T> clazz, File file) {
        String content = DiscUtils.readCatch(file);
        if (content == null) {
            this.logger.log("Impossible de trouver le contenu du fichier.");
            return null;
        }
        try {
            Object instance = this.gson.fromJson(content, clazz);
            return (T)instance;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public <T> T load(Type typeOfT, String name) {
        return this.load(typeOfT, this.getFile(name));
    }

    public <T> T load(Type typeOfT, File file) {
        String content = DiscUtils.readCatch(file);
        if (content == null) {
            return null;
        }
        try {
            return (T)this.gson.fromJson(content, typeOfT);
        }
        catch (Exception ex) {
            this.logger.log(ex.getMessage(), Logger.LogType.ERROR);
            return null;
        }
    }
}

