/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes;

import com.dthielke.herochat.Herochat;
import com.herocraftonline.heroes.characters.CharacterDamageManager;
import com.herocraftonline.heroes.characters.CharacterManager;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.characters.classes.HeroClassManager;
import com.herocraftonline.heroes.characters.effects.EffectManager;
import com.herocraftonline.heroes.characters.party.PartyChannelManager;
import com.herocraftonline.heroes.characters.party.PartyManager;
import com.herocraftonline.heroes.characters.skill.OutsourcedSkill;
import com.herocraftonline.heroes.characters.skill.Skill;
import com.herocraftonline.heroes.characters.skill.SkillConfigManager;
import com.herocraftonline.heroes.characters.skill.SkillManager;
import com.herocraftonline.heroes.command.CommandHandler;
import com.herocraftonline.heroes.command.commands.AdminBonusCommand;
import com.herocraftonline.heroes.command.commands.AdminClassCommand;
import com.herocraftonline.heroes.command.commands.AdminExpCommand;
import com.herocraftonline.heroes.command.commands.AdminHealCommand;
import com.herocraftonline.heroes.command.commands.AdminHealthCommand;
import com.herocraftonline.heroes.command.commands.AdminLevelCommand;
import com.herocraftonline.heroes.command.commands.AdminManaCommand;
import com.herocraftonline.heroes.command.commands.AdminProfCommand;
import com.herocraftonline.heroes.command.commands.ArmorCommand;
import com.herocraftonline.heroes.command.commands.BindSkillCommand;
import com.herocraftonline.heroes.command.commands.ChooseCommand;
import com.herocraftonline.heroes.command.commands.ConfigReloadCommand;
import com.herocraftonline.heroes.command.commands.CooldownCommand;
import com.herocraftonline.heroes.command.commands.HealthCommand;
import com.herocraftonline.heroes.command.commands.HelpCommand;
import com.herocraftonline.heroes.command.commands.LeaderboardCommand;
import com.herocraftonline.heroes.command.commands.LevelInformationCommand;
import com.herocraftonline.heroes.command.commands.ManaCommand;
import com.herocraftonline.heroes.command.commands.PartyAcceptCommand;
import com.herocraftonline.heroes.command.commands.PartyChatCommand;
import com.herocraftonline.heroes.command.commands.PartyHeroChatCommand;
import com.herocraftonline.heroes.command.commands.PartyInviteCommand;
import com.herocraftonline.heroes.command.commands.PartyKickCommand;
import com.herocraftonline.heroes.command.commands.PartyLeadCommand;
import com.herocraftonline.heroes.command.commands.PartyLeaveCommand;
import com.herocraftonline.heroes.command.commands.PartyModeCommand;
import com.herocraftonline.heroes.command.commands.PartyWhoCommand;
import com.herocraftonline.heroes.command.commands.PathsCommand;
import com.herocraftonline.heroes.command.commands.ProfessionCommand;
import com.herocraftonline.heroes.command.commands.ResetCommand;
import com.herocraftonline.heroes.command.commands.ScrollCommand;
import com.herocraftonline.heroes.command.commands.SkillListCommand;
import com.herocraftonline.heroes.command.commands.SpecsCommand;
import com.herocraftonline.heroes.command.commands.SuppressCommand;
import com.herocraftonline.heroes.command.commands.ToolsCommand;
import com.herocraftonline.heroes.command.commands.VerboseCommand;
import com.herocraftonline.heroes.command.commands.WhoCommand;
import com.herocraftonline.heroes.command.commands.WhoisCommand;
import com.herocraftonline.heroes.gui.MenuHandler;
import com.herocraftonline.heroes.listeners.HBlockListener;
import com.herocraftonline.heroes.listeners.HBukkitDamageListener;
import com.herocraftonline.heroes.listeners.HDamageListener;
import com.herocraftonline.heroes.listeners.HEntityListener;
import com.herocraftonline.heroes.listeners.HEventListener;
import com.herocraftonline.heroes.listeners.HInventoryListener;
import com.herocraftonline.heroes.listeners.HPlayerListener;
import com.herocraftonline.heroes.listeners.HPluginListener;
import com.herocraftonline.heroes.storage.StorageManager;
import com.herocraftonline.heroes.util.ConfigManager;
import com.herocraftonline.heroes.util.DebugLog;
import com.herocraftonline.heroes.util.Properties;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public class Heroes
extends JavaPlugin {
    public static final File dataFolder = new File("plugins" + File.separator + "Heroes");
    private static Logger log;
    public static DebugLog debugLog;
    private ConfigManager configManager;
    private final CommandHandler commandHandler = new CommandHandler(this);
    private HeroClassManager heroClassManager;
    private EffectManager effectManager;
    private CharacterManager characterManager;
    private PartyManager partyManager;
    private CharacterDamageManager damageManager;
    private SkillManager skillManager;
    private SkillConfigManager skillConfigs;
    private StorageManager storageManager;
    private PartyChannelManager partyChannelManager;
    public static Properties properties;
    public static Economy econ;
    public static Permission perms;
    public static Herochat herochat;
    private static Heroes instance;
    public static boolean useSMS;

    public static void debugLog(Level level, String msg) {
        if (Heroes.properties.debug) {
            debugLog.log(level, "[Debug] " + msg);
        }
    }

    public static void debugThrow(String sourceClass, String sourceMethod, Throwable thrown) {
        if (Heroes.properties.debug) {
            debugLog.throwing(sourceClass, sourceMethod, thrown);
        }
    }

    public HeroClassManager getClassManager() {
        return this.heroClassManager;
    }

    public CommandHandler getCommandHandler() {
        return this.commandHandler;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public CharacterDamageManager getDamageManager() {
        return this.damageManager;
    }

    public CharacterManager getCharacterManager() {
        return this.characterManager;
    }

    public PartyManager getPartyManager() {
        return this.partyManager;
    }

    public SkillManager getSkillManager() {
        return this.skillManager;
    }

    public EffectManager getEffectManager() {
        return this.effectManager;
    }

    public SkillConfigManager getSkillConfigs() {
        return this.skillConfigs;
    }

    public void setSkillConfigs(SkillConfigManager config) {
        this.skillConfigs = config;
    }

    public StorageManager getStorageManager() {
        return this.storageManager;
    }

    public PartyChannelManager getPartyChannelManager() {
        return herochat != null ? this.partyChannelManager : null;
    }

    public static Heroes getInstance() {
        return instance;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        return this.commandHandler.dispatch(sender, command.getName(), label, args);
    }

    public void onDisable() {
        if (this.characterManager != null) {
            this.characterManager.shutdown();
            this.characterManager.stopTimers();
        }
        econ = null;
        log.info(" version " + this.getDescription().getVersion() + " is disabled!");
        if (Heroes.properties.debug) {
            debugLog.close();
        }
    }

    public void onEnable() {
        Player[] players;
        log = this.getLogger();
        log.info("You are running Heroes on " + this.getServer().getVersion());
        try {
            new Properties();
        }
        catch (UnsupportedOperationException e) {
            log.severe(e.getMessage());
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        catch (RuntimeException e) {
            log.severe(e.getMessage());
            e.printStackTrace();
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        catch (Exception e) {
            log.severe("Unhandled exception during configuration loading, plugin will now disable");
            e.printStackTrace();
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        if (this.getServer().getPluginManager().getPlugin("Vault") == null || !this.setupPermissions()) {
            log.warning("Heroes requires Vault! Please install it to use Heroes!");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.setupEconomy();
        this.setupSMS();
        this.setupHerochat();
        properties.load(this);
        instance = this;
        this.configManager = new ConfigManager(this);
        try {
            this.configManager.load();
        }
        catch (Exception e) {
            e.printStackTrace();
            Heroes.log(Level.SEVERE, "Critical error encountered while loading. Disabling...");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        if (Heroes.properties.debug) {
            debugLog = new DebugLog("Heroes", dataFolder + File.separator + "debug.log");
        }
        this.effectManager = new EffectManager(this);
        this.partyManager = new PartyManager(this);
        this.storageManager = new StorageManager(this);
        this.characterManager = new CharacterManager(this);
        this.damageManager = new CharacterDamageManager(this);
        this.skillManager = new SkillManager(this);
        if (herochat != null) {
            this.partyChannelManager = new PartyChannelManager();
        }
        if (!this.configManager.loadManagers()) {
            this.getPluginLoader().disablePlugin((Plugin)this);
            Heroes.log(Level.SEVERE, "Critical error encountered while loading. Disabling Heroes!");
            return;
        }
        this.registerEvents();
        this.registerCommands();
        Heroes.log(Level.INFO, "version " + this.getDescription().getVersion() + " is enabled!");
        for (Player player : players = this.getServer().getOnlinePlayers()) {
            Hero hero = this.characterManager.getHero(player);
            HeroClass heroClass = hero.getHeroClass();
            if (heroClass != this.heroClassManager.getDefaultClass() && !perms.has(player, "heroes.classes." + heroClass.getName().toLowerCase())) {
                hero.setHeroClass(this.heroClassManager.getDefaultClass(), false);
            }
            for (Skill skill : this.skillManager.getSkills()) {
                if (!(skill instanceof OutsourcedSkill)) continue;
                ((OutsourcedSkill)skill).tryLearningSkill(hero);
            }
            this.characterManager.getHero(player).checkInventory();
        }
    }

    public void onLoad() {
        dataFolder.mkdirs();
    }

    public void setClassManager(HeroClassManager heroClassManager) {
        this.heroClassManager = heroClassManager;
    }

    public boolean setupEconomy() {
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp != null) {
            econ = (Economy)rsp.getProvider();
        }
        return econ != null;
    }

    private void setupHerochat() {
        Plugin p = Bukkit.getServer().getPluginManager().getPlugin("Herochat");
        if (p != null) {
            herochat = Herochat.getPlugin();
        }
    }

    private void setupSMS() {
        Plugin p = Bukkit.getServer().getPluginManager().getPlugin("ScrollingMenuSign");
        if (p != null) {
            MenuHandler.setup(p);
        }
    }

    public boolean setupPermissions() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Permission.class);
        if (rsp != null) {
            perms = (Permission)rsp.getProvider();
        }
        return perms != null;
    }

    private void registerCommands() {
        this.commandHandler.addCommand(new PathsCommand(this));
        this.commandHandler.addCommand(new SpecsCommand(this));
        this.commandHandler.addCommand(new ChooseCommand(this));
        this.commandHandler.addCommand(new ProfessionCommand(this));
        this.commandHandler.addCommand(new LevelInformationCommand(this));
        this.commandHandler.addCommand(new SkillListCommand(this));
        this.commandHandler.addCommand(new BindSkillCommand(this));
        this.commandHandler.addCommand(new ArmorCommand(this));
        this.commandHandler.addCommand(new ToolsCommand(this));
        this.commandHandler.addCommand(new ManaCommand(this));
        this.commandHandler.addCommand(new CooldownCommand(this));
        this.commandHandler.addCommand(new VerboseCommand(this));
        this.commandHandler.addCommand(new SuppressCommand(this));
        this.commandHandler.addCommand(new WhoCommand(this));
        this.commandHandler.addCommand(new WhoisCommand(this));
        this.commandHandler.addCommand(new PartyAcceptCommand(this));
        this.commandHandler.addCommand(new PartyInviteCommand(this));
        this.commandHandler.addCommand(new PartyWhoCommand(this));
        this.commandHandler.addCommand(new PartyLeaveCommand(this));
        this.commandHandler.addCommand(new PartyModeCommand(this));
        if (herochat != null) {
            this.commandHandler.addCommand(new PartyHeroChatCommand(this));
        } else {
            this.commandHandler.addCommand(new PartyChatCommand(this));
        }
        this.commandHandler.addCommand(new PartyLeadCommand(this));
        this.commandHandler.addCommand(new PartyKickCommand(this));
        this.commandHandler.addCommand(new ConfigReloadCommand(this));
        this.commandHandler.addCommand(new HelpCommand(this));
        if (useSMS) {
            this.commandHandler.addCommand(new ScrollCommand(this));
        }
        this.commandHandler.addCommand(new AdminExpCommand(this));
        this.commandHandler.addCommand(new AdminLevelCommand(this));
        this.commandHandler.addCommand(new AdminClassCommand(this));
        this.commandHandler.addCommand(new AdminProfCommand(this));
        this.commandHandler.addCommand(new AdminHealthCommand(this));
        this.commandHandler.addCommand(new AdminManaCommand(this));
        this.commandHandler.addCommand(new AdminHealCommand(this));
        this.commandHandler.addCommand(new AdminBonusCommand(this));
        this.commandHandler.addCommand(new HealthCommand(this));
        this.commandHandler.addCommand(new LeaderboardCommand(this));
        this.commandHandler.addCommand(new ResetCommand(this));
    }

    private void registerEvents() {
        Bukkit.getPluginManager().registerEvents((Listener)new HPlayerListener(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new HPluginListener(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new HEntityListener(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new HBlockListener(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new HEventListener(this), (Plugin)this);
        if (Properties.serverType == Properties.ServerType.SPIGOT) {
            Bukkit.getPluginManager().registerEvents((Listener)new HDamageListener(this, this.getDamageManager()), (Plugin)this);
        } else {
            Bukkit.getPluginManager().registerEvents((Listener)new HBukkitDamageListener(this, this.getDamageManager()), (Plugin)this);
        }
        Bukkit.getPluginManager().registerEvents((Listener)new HInventoryListener(this), (Plugin)this);
    }

    public static void log(Level level, String msg) {
        log.log(level, msg);
        if (Heroes.properties.debug) {
            debugLog.log(level, "[Heroes] " + msg);
        }
    }

    static {
        useSMS = false;
    }
}

