/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.api;

import com.herocraftonline.heroes.characters.skill.Skill;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.plugin.Plugin;

public final class SkillRegistrar {
    private static List<Pair<Plugin, Class<? extends Skill>>> classList = new ArrayList<Pair<Plugin, Class<? extends Skill>>>();
    private static boolean accepting = true;

    public static void stopRegistration() {
        accepting = false;
    }

    public static void registerSkill(Plugin p, Class<? extends Skill> clazz) {
        if (!accepting) {
            throw new LateSkillRegistrationException(p.getName(), clazz.getSimpleName());
        }
        if (!Skill.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Incorrect Skill class " + clazz.getSimpleName());
        }
        classList.add(new Pair<Plugin, Class<? extends Skill>>(p, clazz));
    }

    public static List<Pair<Plugin, Class<? extends Skill>>> getRegisteredSkillClasses() {
        return classList;
    }

    public static class Pair<A, B> {
        private A a;
        private B b;

        public Pair(A a, B b) {
            this.a = a;
            this.b = b;
        }

        public A getLeft() {
            return this.a;
        }

        public B getRight() {
            return this.b;
        }
    }

    public static class LateSkillRegistrationException
    extends RuntimeException {
        private static final long serialVersionUID = -7009039680023866251L;

        public LateSkillRegistrationException(String pluginName, String className) {
            super(pluginName + " attempted to register skill " + className + " after Heroes was loaded");
        }
    }
}

