/*
 * Decompiled with CFR 0.152.
 */
package com.herocraftonline.heroes.characters;

import com.herocraftonline.heroes.Heroes;
import com.herocraftonline.heroes.api.SkillUseInfo;
import com.herocraftonline.heroes.characters.CharacterTemplate;
import com.herocraftonline.heroes.characters.Hero;
import com.herocraftonline.heroes.characters.classes.HeroClass;
import com.herocraftonline.heroes.characters.skill.Skill;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.Material;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Egg;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Snowball;
import org.bukkit.event.entity.EntityDamageEvent;

public class CharacterDamageManager {
    private final Heroes plugin;
    private Map<Material, Double> itemDamage;
    private Map<ProjectileType, Double> projectileDamage;
    private Map<EntityType, Double> creatureHealth;
    private Map<EntityType, Double> creatureDamage;
    private Map<EntityDamageEvent.DamageCause, Double> environmentalDamage;
    private Map<Enchantment, Double> enchantmentDamage;
    private final Map<Integer, SkillUseInfo> spellTargs = new HashMap<Integer, SkillUseInfo>();

    public CharacterDamageManager(Heroes plugin) {
        this.plugin = plugin;
    }

    public void addSpellTarget(Entity o, CharacterTemplate character, Skill skill) {
        SkillUseInfo skillInfo = new SkillUseInfo(character, skill);
        this.spellTargs.put(o.getEntityId(), skillInfo);
    }

    public boolean isSpellTarget(Entity o) {
        return this.spellTargs.containsKey(o.getEntityId());
    }

    public SkillUseInfo getSpellTargetInfo(Entity o) {
        return this.spellTargs.get(o.getEntityId());
    }

    protected double getEntityDamage(EntityType type) {
        Double val = this.creatureDamage.get(type);
        return val != null ? val : 1.0;
    }

    protected double getEntityMaxHealth(LivingEntity lEntity) {
        Double val = this.creatureHealth.get(lEntity.getType());
        return val != null ? val.doubleValue() : lEntity.getMaxHealth();
    }

    public Double getEnvironmentalDamage(EntityDamageEvent.DamageCause cause) {
        return this.environmentalDamage.get(cause);
    }

    public Double getEnchantmentDamage(Enchantment ench) {
        return this.enchantmentDamage.get(ench);
    }

    public Double getItemDamage(Material item, HumanEntity entity) {
        if (entity != null && entity instanceof Player) {
            Hero hero = this.plugin.getCharacterManager().getHero((Player)entity);
            HeroClass heroClass = hero.getHeroClass();
            HeroClass secondClass = hero.getSecondClass();
            Double classDamage = heroClass.getItemDamage(item);
            if (classDamage != null) {
                classDamage = classDamage + (double)((int)(heroClass.getItemDamageLevel(item) * (double)hero.getLevel(heroClass)));
            }
            Double secondDamage = null;
            if (secondClass != null && (secondDamage = secondClass.getItemDamage(item)) != null) {
                secondDamage = secondDamage + (double)((int)(secondClass.getItemDamageLevel(item) * (double)hero.getLevel(secondClass)));
            }
            if (classDamage != null && secondDamage != null) {
                return classDamage > secondDamage ? classDamage : secondDamage;
            }
            if (classDamage != null) {
                return classDamage;
            }
            if (secondDamage != null) {
                return secondDamage;
            }
        }
        return this.itemDamage.get(item);
    }

    public Double getProjectileDamage(ProjectileType type, HumanEntity entity) {
        if (entity != null && entity instanceof Player) {
            Hero hero = this.plugin.getCharacterManager().getHero((Player)entity);
            HeroClass heroClass = hero.getHeroClass();
            HeroClass secondClass = hero.getSecondClass();
            Double classDamage = heroClass.getProjectileDamage(type);
            if (classDamage != null) {
                classDamage = classDamage + heroClass.getProjDamageLevel(type) * (double)hero.getLevel(heroClass);
            }
            Double secondDamage = null;
            if (secondClass != null && (secondDamage = secondClass.getProjectileDamage(type)) != null) {
                secondDamage = secondDamage + secondClass.getProjDamageLevel(type) * (double)hero.getLevel(secondClass);
            }
            if (classDamage != null && secondDamage != null) {
                return classDamage > secondDamage ? classDamage : secondDamage;
            }
            if (classDamage != null) {
                return classDamage;
            }
            if (secondDamage != null) {
                return secondDamage;
            }
        }
        return this.projectileDamage.get((Object)type);
    }

    public void load(Configuration config) {
        Object type;
        Set keys;
        Heroes.properties.potHealthPerTier = config.getDouble("potions.health-per-tier", 0.1);
        this.creatureHealth = new EnumMap<EntityType, Double>(EntityType.class);
        ConfigurationSection section = config.getConfigurationSection("creature-health");
        boolean errored = false;
        if (section != null && (keys = section.getKeys(false)) != null) {
            for (String key : keys) {
                try {
                    type = EntityType.fromName((String)key);
                    if (type == null) {
                        throw new IllegalArgumentException();
                    }
                    double health = section.getDouble(key, 20.0);
                    if (health <= 0.0) {
                        health = 20.0;
                    }
                    this.creatureHealth.put((EntityType)type, health);
                }
                catch (IllegalArgumentException e) {
                    Heroes.log(Level.WARNING, "Invalid creature type (" + key + ") found in damages.yml.");
                    errored = true;
                }
            }
        }
        this.creatureDamage = new EnumMap<EntityType, Double>(EntityType.class);
        section = config.getConfigurationSection("creature-damage");
        if (section != null && (keys = section.getKeys(false)) != null) {
            for (String key : keys) {
                try {
                    type = EntityType.fromName((String)key);
                    if (type == null) {
                        throw new IllegalArgumentException();
                    }
                    this.creatureDamage.put((EntityType)type, section.getDouble(key, 10.0));
                }
                catch (IllegalArgumentException e) {
                    Heroes.log(Level.WARNING, "Invalid creature type (" + key + ") found in damages.yml.");
                    errored = true;
                }
            }
        }
        if (errored) {
            Heroes.log(Level.WARNING, "Remember, creature-names are case-sensetive, and must be exactly the same as found in the defaults!");
        }
        this.itemDamage = new EnumMap<Material, Double>(Material.class);
        section = config.getConfigurationSection("item-damage");
        if (section != null && (keys = section.getKeys(false)) != null) {
            for (String key : keys) {
                try {
                    Material item = Material.matchMaterial((String)key);
                    if (item == null) {
                        throw new IllegalArgumentException();
                    }
                    this.itemDamage.put(item, section.getDouble(key, 2.0));
                }
                catch (IllegalArgumentException e) {
                    Heroes.log(Level.WARNING, "Invalid item type (" + key + ") found in damages.yml.");
                }
            }
        }
        this.environmentalDamage = new EnumMap<EntityDamageEvent.DamageCause, Double>(EntityDamageEvent.DamageCause.class);
        section = config.getConfigurationSection("environmental-damage");
        if (section != null && (keys = section.getKeys(false)) != null) {
            for (String key : keys) {
                try {
                    EntityDamageEvent.DamageCause cause = EntityDamageEvent.DamageCause.valueOf((String)key.toUpperCase());
                    if (cause == null) {
                        throw new IllegalArgumentException();
                    }
                    double damage = section.getDouble(key, 0.0);
                    this.environmentalDamage.put(cause, damage);
                }
                catch (IllegalArgumentException e) {
                    Heroes.log(Level.WARNING, "Invalid environmental damage type (" + key + ") found in damages.yml");
                }
            }
        }
        this.projectileDamage = new EnumMap<ProjectileType, Double>(ProjectileType.class);
        section = config.getConfigurationSection("projectile-damage");
        if (section != null && (keys = section.getKeys(false)) != null) {
            for (String key : keys) {
                type = ProjectileType.valueOf(key.toUpperCase());
                if (type == null) continue;
                this.projectileDamage.put((ProjectileType)((Object)type), section.getDouble(key, 0.0));
            }
        }
        this.enchantmentDamage = new HashMap<Enchantment, Double>();
        section = config.getConfigurationSection("enchantment-damage");
        if (section != null && (keys = section.getKeys(false)) != null) {
            for (String key : keys) {
                Enchantment enchant = Enchantment.getByName((String)key);
                if (enchant == null) continue;
                this.enchantmentDamage.put(enchant, section.getDouble(key, 0.0));
            }
        }
    }

    public SkillUseInfo removeSpellTarget(Entity o) {
        return this.spellTargs.remove(o.getEntityId());
    }

    public static enum ProjectileType {
        ARROW,
        EGG,
        SNOWBALL;


        public static ProjectileType matchProjectile(String name) {
            if (name.equalsIgnoreCase("arrow")) {
                return ARROW;
            }
            if (name.equalsIgnoreCase("snowball")) {
                return SNOWBALL;
            }
            if (name.equalsIgnoreCase("egg")) {
                return EGG;
            }
            return null;
        }

        public static ProjectileType valueOf(Entity entity) {
            if (entity instanceof Arrow) {
                return ARROW;
            }
            if (entity instanceof Snowball) {
                return SNOWBALL;
            }
            if (entity instanceof Egg) {
                return EGG;
            }
            return null;
        }
    }
}

